/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.graphics;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.shapes.Shape;

public class BaseShape
extends Shape {
    private static final boolean DEBUG = false;
    protected final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected final RectF mBoundsRect = new RectF();
    protected final float mStdWidth;
    protected final float mStdHeight;
    protected final float mStdWidth2;
    protected final float mStdHeight2;
    protected float mScaleX;
    protected float mScaleY;
    protected float mRotation;
    protected float mPivotX;
    protected float mPivotY;
    final Paint debugPaint = new Paint();

    public BaseShape(float std_width, float std_height) {
        this.mStdWidth = std_width;
        this.mStdHeight = std_height;
        this.mStdWidth2 = std_width / 2.0f;
        this.mStdHeight2 = this.mStdHeight / 2.0f;
    }

    @TargetApi(value=21)
    public void getOutline(Outline outline) {
        RectF rect = this.boundsRect();
        outline.setRect((int)Math.ceil(rect.left), (int)Math.ceil(rect.top), (int)Math.floor(rect.right), (int)Math.floor(rect.bottom));
    }

    protected void onResize(float width, float height) {
        this.mBoundsRect.set(0.0f, 0.0f, width, height);
        this.mScaleX = width / this.mStdWidth;
        this.mScaleY = height / this.mStdHeight;
        this.mPivotX = width / 2.0f;
        this.mPivotY = height / 2.0f;
    }

    protected final RectF boundsRect() {
        return this.mBoundsRect;
    }

    public BaseShape clone() throws CloneNotSupportedException {
        BaseShape shape = (BaseShape)super.clone();
        shape.mBoundsRect.set(this.mBoundsRect);
        return shape;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public void setRotation(float rotation) {
        this.mRotation = rotation;
    }

    public float getRotation() {
        return this.mRotation;
    }

    public void draw(Canvas canvas, Paint paint) {
        int count = canvas.save();
        canvas.translate(this.mPivotX, this.mPivotY);
        canvas.rotate(this.mRotation);
        canvas.scale(this.mScaleX, this.mScaleY);
        canvas.translate(-this.mStdWidth2, -this.mStdHeight2);
        this.doDraw(canvas, paint);
        canvas.restoreToCount(count);
    }

    protected void doDraw(Canvas canvas, Paint paint) {
        canvas.drawRect(this.mBoundsRect, paint);
    }
}

