/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.glutils;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jiangdg.glutils.EglTask;
import com.jiangdg.glutils.GLDrawer2D;
import com.jiangdg.glutils.GLHelper;
import com.jiangdg.glutils.RendererSurfaceRec;
import com.jiangdg.glutils.TextureOffscreen;

public class StaticTextureSource {
    private static final boolean DEBUG = false;
    private static final String TAG = StaticTextureSource.class.getSimpleName();
    private final Object mSync = new Object();
    private RendererTask mRendererTask;
    private volatile boolean isRunning;
    private static final int REQUEST_DRAW = 1;
    private static final int REQUEST_ADD_SURFACE = 3;
    private static final int REQUEST_REMOVE_SURFACE = 4;
    private static final int REQUEST_SET_BITMAP = 7;
    private Runnable mOnFrameTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long ms = StaticTextureSource.this.mRendererTask.mIntervalsNs / 1000000L;
            int ns = (int)(StaticTextureSource.this.mRendererTask.mIntervalsNs % 1000000L);
            while (StaticTextureSource.this.isRunning && StaticTextureSource.this.mRendererTask != null) {
                Object object = StaticTextureSource.this.mSync;
                synchronized (object) {
                    try {
                        StaticTextureSource.this.mSync.wait(ms, ns);
                        if (StaticTextureSource.this.mRendererTask.mImageSource != null) {
                            StaticTextureSource.this.mRendererTask.removeRequest(1);
                            StaticTextureSource.this.mRendererTask.offer(1);
                            StaticTextureSource.this.mSync.notify();
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
            }
        }
    };

    public StaticTextureSource(float fps) {
        this(null, fps);
    }

    public StaticTextureSource(@Nullable Bitmap bitmap) {
        this(bitmap, 10.0f);
    }

    public StaticTextureSource(@Nullable Bitmap bitmap, float fps) {
        int width = bitmap != null ? bitmap.getWidth() : 1;
        int height = bitmap != null ? bitmap.getHeight() : 1;
        this.mRendererTask = new RendererTask(this, width, height, fps);
        new Thread((Runnable)this.mRendererTask, TAG).start();
        if (!this.mRendererTask.waitReady()) {
            throw new RuntimeException("failed to start renderer thread");
        }
        this.setBitmap(bitmap);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.isRunning = false;
        Object object = this.mSync;
        synchronized (object) {
            this.mSync.notifyAll();
        }
        if (this.mRendererTask != null) {
            this.mRendererTask.release();
        }
        object = this.mSync;
        synchronized (object) {
            this.mRendererTask = null;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSurface(int id2, Object surface, boolean isRecordable) {
        Object object = this.mSync;
        synchronized (object) {
            this.mRendererTask.addSurface(id2, surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSurface(int id2, Object surface, boolean isRecordable, int maxFps) {
        Object object = this.mSync;
        synchronized (object) {
            this.mRendererTask.addSurface(id2, surface, maxFps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSurface(int id2) {
        Object object = this.mSync;
        synchronized (object) {
            this.mRendererTask.removeSurface(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFrame() {
        Object object = this.mSync;
        synchronized (object) {
            this.mRendererTask.removeRequest(1);
            this.mRendererTask.offer(1);
            this.mSync.notify();
        }
    }

    public int getCount() {
        return this.mRendererTask.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            Object object = this.mSync;
            synchronized (object) {
                this.mRendererTask.setBitmap(bitmap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTask != null ? this.mRendererTask.mVideoWidth : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTask != null ? this.mRendererTask.mVideoHeight : 0;
        }
    }

    private static class RendererTask
    extends EglTask {
        private final Object mClientSync = new Object();
        private final SparseArray<RendererSurfaceRec> mClients = new SparseArray();
        private final StaticTextureSource mParent;
        private final long mIntervalsNs;
        private GLDrawer2D mDrawer;
        private int mVideoWidth;
        private int mVideoHeight;
        private TextureOffscreen mImageSource;

        public RendererTask(StaticTextureSource parent, int width, int height, float fps) {
            super(3, null, 0);
            this.mParent = parent;
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            this.mIntervalsNs = fps <= 0.0f ? 100000000L : (long)(1.0E9f / fps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onStart() {
            this.mDrawer = new GLDrawer2D(false);
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = true;
                this.mParent.mSync.notifyAll();
            }
            new Thread(this.mParent.mOnFrameTask, TAG).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onStop() {
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = false;
                this.mParent.mSync.notifyAll();
            }
            this.makeCurrent();
            if (this.mDrawer != null) {
                this.mDrawer.release();
                this.mDrawer = null;
            }
            if (this.mImageSource != null) {
                this.mImageSource.release();
                this.mImageSource = null;
            }
            this.handleRemoveAll();
        }

        @Override
        protected boolean onError(Exception e) {
            return false;
        }

        @Override
        protected Object processRequest(int request, int arg1, int arg2, Object obj) {
            switch (request) {
                case 1: {
                    this.handleDraw();
                    break;
                }
                case 3: {
                    this.handleAddSurface(arg1, obj, arg2);
                    break;
                }
                case 4: {
                    this.handleRemoveSurface(arg1);
                    break;
                }
                case 7: {
                    this.handleSetBitmap((Bitmap)obj);
                }
            }
            return null;
        }

        public void addSurface(int id2, Object surface) {
            this.addSurface(id2, surface, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSurface(int id2, Object surface, int maxFps) {
            this.checkFinished();
            if (!(surface instanceof SurfaceTexture || surface instanceof Surface || surface instanceof SurfaceHolder)) {
                throw new IllegalArgumentException("Surface should be one of Surface, SurfaceTexture or SurfaceHolder");
            }
            Object object = this.mClientSync;
            synchronized (object) {
                if (this.mClients.get(id2) == null) {
                    while (true) {
                        if (this.offer(3, id2, maxFps, surface)) {
                            try {
                                this.mClientSync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mClientSync.wait(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSurface(int id2) {
            Object object = this.mClientSync;
            synchronized (object) {
                if (this.mClients.get(id2) != null) {
                    while (true) {
                        if (this.offer(4, id2)) {
                            try {
                                this.mClientSync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mClientSync.wait(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        public void setBitmap(@NonNull Bitmap bitmap) {
            this.offer(7, bitmap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCount() {
            Object object = this.mClientSync;
            synchronized (object) {
                return this.mClients.size();
            }
        }

        private void checkFinished() {
            if (this.isFinished()) {
                throw new RuntimeException("already finished");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDraw() {
            this.makeCurrent();
            if (this.mImageSource != null) {
                int texId = this.mImageSource.getTexture();
                Object object = this.mClientSync;
                synchronized (object) {
                    int n = this.mClients.size();
                    for (int i = n - 1; i >= 0; --i) {
                        RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                        if (client == null || !client.canDraw()) continue;
                        try {
                            client.draw(this.mDrawer, texId, null);
                            GLHelper.checkGlError("handleSetBitmap");
                            continue;
                        }
                        catch (Exception e) {
                            this.mClients.removeAt(i);
                            client.release();
                        }
                    }
                }
            } else {
                Log.w((String)TAG, (String)"mImageSource is not ready");
            }
            GLES20.glClear((int)16384);
            GLES20.glFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAddSurface(int id2, Object surface, int maxFps) {
            this.checkSurface();
            Object object = this.mClientSync;
            synchronized (object) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client == null) {
                    try {
                        client = RendererSurfaceRec.newInstance(this.getEgl(), surface, maxFps);
                        this.mClients.append(id2, (Object)client);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)("invalid surface: surface=" + surface), (Throwable)e);
                    }
                } else {
                    Log.w((String)TAG, (String)("surface is already added: id=" + id2));
                }
                this.mClientSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRemoveSurface(int id2) {
            Object object = this.mClientSync;
            synchronized (object) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client != null) {
                    this.mClients.remove(id2);
                    client.release();
                }
                this.checkSurface();
                this.mClientSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRemoveAll() {
            Object object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null) continue;
                    this.makeCurrent();
                    client.release();
                }
                this.mClients.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSurface() {
            Object object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null || client.isValid()) continue;
                    int id2 = this.mClients.keyAt(i);
                    ((RendererSurfaceRec)this.mClients.valueAt(i)).release();
                    this.mClients.remove(id2);
                }
            }
        }

        private void handleSetBitmap(Bitmap bitmap) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (this.mImageSource == null) {
                this.mImageSource = new TextureOffscreen(width, height, false);
                GLHelper.checkGlError("handleSetBitmap");
                this.mImageSource.loadBitmap(bitmap);
            } else {
                this.mImageSource.loadBitmap(bitmap);
            }
            this.mVideoWidth = width;
            this.mVideoHeight = height;
        }
    }
}

