/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.glutils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.opengl.Matrix;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jiangdg.glutils.EGLBase;
import com.jiangdg.glutils.EglTask;
import com.jiangdg.glutils.GLDrawer2D;
import com.jiangdg.glutils.GLHelper;
import com.jiangdg.glutils.IRendererHolder;
import com.jiangdg.glutils.RenderHolderCallback;
import com.jiangdg.glutils.RendererHolder;
import com.jiangdg.glutils.RendererSurfaceRec;
import com.jiangdg.utils.BuildCheck;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class AbstractRendererHolder
implements IRendererHolder {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractRendererHolder.class.getSimpleName();
    private static final String RENDERER_THREAD_NAME = "RendererHolder";
    private static final String CAPTURE_THREAD_NAME = "CaptureTask";
    protected static final int REQUEST_DRAW = 1;
    protected static final int REQUEST_UPDATE_SIZE = 2;
    protected static final int REQUEST_ADD_SURFACE = 3;
    protected static final int REQUEST_REMOVE_SURFACE = 4;
    protected static final int REQUEST_REMOVE_SURFACE_ALL = 12;
    protected static final int REQUEST_RECREATE_MASTER_SURFACE = 5;
    protected static final int REQUEST_MIRROR = 6;
    protected static final int REQUEST_ROTATE = 7;
    protected static final int REQUEST_CLEAR = 8;
    protected static final int REQUEST_CLEAR_ALL = 9;
    protected static final int REQUEST_SET_MVP = 10;
    protected final Object mSync = new Object();
    @Nullable
    private final RenderHolderCallback mCallback;
    private volatile boolean isRunning;
    private OutputStream mCaptureStream;
    private int mCaptureFormat;
    @IntRange(from=1L, to=99L)
    private int mCaptureCompression = 80;
    protected final RendererTask mRendererTask;
    private final Runnable mCaptureTask = new Runnable(){
        EGLBase eglBase;
        EGLBase.IEglSurface captureSurface;
        GLDrawer2D drawer;
        final float[] mMvpMatrix = new float[16];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AbstractRendererHolder.this.mSync;
            synchronized (object) {
                while (!AbstractRendererHolder.this.isRunning && !AbstractRendererHolder.this.mRendererTask.isFinished()) {
                    try {
                        AbstractRendererHolder.this.mSync.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            if (AbstractRendererHolder.this.isRunning) {
                this.init();
                try {
                    if (this.eglBase.getGlVersion() > 2 && BuildCheck.isAndroid4_3()) {
                        this.captureLoopGLES3();
                    } else {
                        this.captureLoopGLES2();
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                finally {
                    this.release();
                }
            }
        }

        private final void init() {
            this.eglBase = EGLBase.createFrom(3, AbstractRendererHolder.this.mRendererTask.getContext(), false, 0, false);
            this.captureSurface = this.eglBase.createOffscreen(AbstractRendererHolder.this.mRendererTask.width(), AbstractRendererHolder.this.mRendererTask.height());
            Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
            this.drawer = new GLDrawer2D(true);
            AbstractRendererHolder.this.setupCaptureDrawer(this.drawer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void captureLoopGLES2() {
            Object object;
            int width = -1;
            int height = -1;
            ByteBuffer buf = null;
            int captureCompression = 80;
            while (AbstractRendererHolder.this.isRunning) {
                object = AbstractRendererHolder.this.mSync;
                synchronized (object) {
                    if (AbstractRendererHolder.this.mCaptureStream == null) {
                        try {
                            AbstractRendererHolder.this.mSync.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        if (AbstractRendererHolder.this.mCaptureStream != null) {
                            captureCompression = AbstractRendererHolder.this.mCaptureCompression;
                            if (captureCompression <= 0 || captureCompression >= 100) {
                                captureCompression = 90;
                            }
                        } else {
                            continue;
                        }
                    }
                    if (buf == null || width != AbstractRendererHolder.this.mRendererTask.width() || height != AbstractRendererHolder.this.mRendererTask.height()) {
                        width = AbstractRendererHolder.this.mRendererTask.width();
                        height = AbstractRendererHolder.this.mRendererTask.height();
                        buf = ByteBuffer.allocateDirect(width * height * 4);
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        if (this.captureSurface != null) {
                            this.captureSurface.release();
                            this.captureSurface = null;
                        }
                        this.captureSurface = this.eglBase.createOffscreen(width, height);
                    }
                    if (AbstractRendererHolder.this.isRunning && width > 0 && height > 0) {
                        AbstractRendererHolder.setMirror(this.mMvpMatrix, AbstractRendererHolder.this.mRendererTask.mirror());
                        this.mMvpMatrix[5] = this.mMvpMatrix[5] * -1.0f;
                        this.drawer.setMvpMatrix(this.mMvpMatrix, 0);
                        this.captureSurface.makeCurrent();
                        this.drawer.draw(AbstractRendererHolder.this.mRendererTask.mTexId, AbstractRendererHolder.this.mRendererTask.mTexMatrix, 0);
                        this.captureSurface.swap();
                        buf.clear();
                        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
                        Bitmap.CompressFormat compressFormat = AbstractRendererHolder.getCaptureFormat(AbstractRendererHolder.this.mCaptureFormat);
                        try {
                            try {
                                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                buf.clear();
                                bmp.copyPixelsFromBuffer((Buffer)buf);
                                bmp.compress(compressFormat, captureCompression, AbstractRendererHolder.this.mCaptureStream);
                                bmp.recycle();
                                AbstractRendererHolder.this.mCaptureStream.flush();
                            }
                            finally {
                                AbstractRendererHolder.this.mCaptureStream.close();
                            }
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                    } else if (AbstractRendererHolder.this.isRunning) {
                        Log.w((String)TAG, (String)"#captureLoopGLES3:unexpectedly width/height is zero");
                    }
                    AbstractRendererHolder.this.mCaptureStream = null;
                    AbstractRendererHolder.this.mSync.notifyAll();
                }
            }
            object = AbstractRendererHolder.this.mSync;
            synchronized (object) {
                AbstractRendererHolder.this.mSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TargetApi(value=18)
        private final void captureLoopGLES3() {
            Object object;
            int width = -1;
            int height = -1;
            ByteBuffer buf = null;
            int captureCompression = 90;
            while (AbstractRendererHolder.this.isRunning) {
                object = AbstractRendererHolder.this.mSync;
                synchronized (object) {
                    if (AbstractRendererHolder.this.mCaptureStream == null) {
                        try {
                            AbstractRendererHolder.this.mSync.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        if (AbstractRendererHolder.this.mCaptureStream != null) {
                            captureCompression = AbstractRendererHolder.this.mCaptureCompression;
                            if (captureCompression <= 0 || captureCompression >= 100) {
                                captureCompression = 90;
                            }
                        } else {
                            continue;
                        }
                    }
                    if (buf == null || width != AbstractRendererHolder.this.mRendererTask.width() || height != AbstractRendererHolder.this.mRendererTask.height()) {
                        width = AbstractRendererHolder.this.mRendererTask.width();
                        height = AbstractRendererHolder.this.mRendererTask.height();
                        buf = ByteBuffer.allocateDirect(width * height * 4);
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        if (this.captureSurface != null) {
                            this.captureSurface.release();
                            this.captureSurface = null;
                        }
                        this.captureSurface = this.eglBase.createOffscreen(width, height);
                    }
                    if (AbstractRendererHolder.this.isRunning && width > 0 && height > 0) {
                        AbstractRendererHolder.setMirror(this.mMvpMatrix, AbstractRendererHolder.this.mRendererTask.mirror());
                        this.mMvpMatrix[5] = this.mMvpMatrix[5] * -1.0f;
                        this.drawer.setMvpMatrix(this.mMvpMatrix, 0);
                        this.captureSurface.makeCurrent();
                        this.drawer.draw(AbstractRendererHolder.this.mRendererTask.mTexId, AbstractRendererHolder.this.mRendererTask.mTexMatrix, 0);
                        this.captureSurface.swap();
                        buf.clear();
                        GLES30.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
                        Bitmap.CompressFormat compressFormat = AbstractRendererHolder.getCaptureFormat(AbstractRendererHolder.this.mCaptureFormat);
                        try {
                            try {
                                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                buf.clear();
                                bmp.copyPixelsFromBuffer((Buffer)buf);
                                bmp.compress(compressFormat, captureCompression, AbstractRendererHolder.this.mCaptureStream);
                                bmp.recycle();
                                AbstractRendererHolder.this.mCaptureStream.flush();
                            }
                            finally {
                                AbstractRendererHolder.this.mCaptureStream.close();
                            }
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                    } else if (AbstractRendererHolder.this.isRunning) {
                        Log.w((String)TAG, (String)"#captureLoopGLES3:unexpectedly width/height is zero");
                    }
                    AbstractRendererHolder.this.mCaptureStream = null;
                    AbstractRendererHolder.this.mSync.notifyAll();
                }
            }
            object = AbstractRendererHolder.this.mSync;
            synchronized (object) {
                AbstractRendererHolder.this.mSync.notifyAll();
            }
        }

        private final void release() {
            if (this.captureSurface != null) {
                this.captureSurface.makeCurrent();
                this.captureSurface.release();
                this.captureSurface = null;
            }
            if (this.drawer != null) {
                this.drawer.release();
                this.drawer = null;
            }
            if (this.eglBase != null) {
                this.eglBase.release();
                this.eglBase = null;
            }
        }
    };

    protected AbstractRendererHolder(int width, int height, @Nullable RenderHolderCallback callback) {
        this(width, height, 3, null, 2, callback);
    }

    protected AbstractRendererHolder(int width, int height, int maxClientVersion, EGLBase.IContext sharedContext, int flags, @Nullable RenderHolderCallback callback) {
        this.mCallback = callback;
        this.mRendererTask = this.createRendererTask(width, height, maxClientVersion, sharedContext, flags);
        new Thread((Runnable)this.mRendererTask, RENDERER_THREAD_NAME).start();
        if (!this.mRendererTask.waitReady()) {
            throw new RuntimeException("failed to start renderer thread");
        }
        this.startCaptureTask();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.mRendererTask.release();
        Object object = this.mSync;
        synchronized (object) {
            this.isRunning = false;
            this.mSync.notifyAll();
        }
    }

    @Override
    @Nullable
    public EGLBase.IContext getContext() {
        return this.mRendererTask.getContext();
    }

    @Override
    public Surface getSurface() {
        return this.mRendererTask.getSurface();
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mRendererTask.getSurfaceTexture();
    }

    @Override
    public void reset() {
        this.mRendererTask.checkMasterSurface();
    }

    @Override
    public void resize(int width, int height) throws IllegalStateException {
        this.mRendererTask.resize(width, height);
    }

    @Override
    public void setMirror(int mirror) {
        this.mRendererTask.mirror(mirror % 4);
    }

    @Override
    public int getMirror() {
        return this.mRendererTask.mirror();
    }

    @Override
    public void addSurface(int id2, Object surface, boolean isRecordable) throws IllegalStateException, IllegalArgumentException {
        this.mRendererTask.addSurface(id2, surface);
    }

    @Override
    public void addSurface(int id2, Object surface, boolean isRecordable, int maxFps) throws IllegalStateException, IllegalArgumentException {
        this.mRendererTask.addSurface(id2, surface, maxFps);
    }

    @Override
    public void removeSurface(int id2) {
        this.mRendererTask.removeSurface(id2);
    }

    @Override
    public void removeSurfaceAll() {
        this.mRendererTask.removeSurfaceAll();
    }

    @Override
    public void clearSurface(int id2, int color) {
        this.mRendererTask.clearSurface(id2, color);
    }

    @Override
    public void clearSurfaceAll(int color) {
        this.mRendererTask.clearSurfaceAll(color);
    }

    @Override
    public void setMvpMatrix(int id2, int offset, @NonNull float[] matrix) {
        this.mRendererTask.setMvpMatrix(id2, offset, matrix);
    }

    @Override
    public boolean isEnabled(int id2) {
        return this.mRendererTask.isEnabled(id2);
    }

    @Override
    public void setEnabled(int id2, boolean enable) {
        this.mRendererTask.setEnabled(id2, enable);
    }

    @Override
    public void requestFrame() {
        this.mRendererTask.removeRequest(1);
        this.mRendererTask.offer(1);
    }

    @Override
    public int getCount() {
        return this.mRendererTask.getCount();
    }

    @Override
    @Deprecated
    public void captureStillAsync(@NonNull String path) throws FileNotFoundException, IllegalStateException {
        this.captureStill(new BufferedOutputStream(new FileOutputStream(path)), AbstractRendererHolder.getCaptureFormat(path), 80, false);
    }

    @Override
    @Deprecated
    public void captureStillAsync(@NonNull String path, @IntRange(from=1L, to=99L) int captureCompression) throws FileNotFoundException, IllegalStateException {
        this.captureStill(new BufferedOutputStream(new FileOutputStream(path)), AbstractRendererHolder.getCaptureFormat(path), captureCompression, false);
    }

    @Override
    public void captureStill(@NonNull String path) throws FileNotFoundException, IllegalStateException {
        this.captureStill(new BufferedOutputStream(new FileOutputStream(path)), AbstractRendererHolder.getCaptureFormat(path), 80, true);
    }

    @Override
    public void captureStill(@NonNull String path, @IntRange(from=1L, to=99L) int captureCompression) throws FileNotFoundException, IllegalStateException {
        this.captureStill(new BufferedOutputStream(new FileOutputStream(path)), AbstractRendererHolder.getCaptureFormat(path), captureCompression, true);
    }

    @Override
    public void captureStill(@NonNull OutputStream out, int captureFormat, @IntRange(from=1L, to=99L) int captureCompression) throws IllegalStateException {
        this.captureStill(out, captureFormat, captureCompression, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureStill(@NonNull OutputStream out, int captureFormat, @IntRange(from=1L, to=99L) int captureCompression, boolean needWait) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isRunning) {
                throw new IllegalStateException("already released?");
            }
            if (this.mCaptureStream != null) {
                throw new IllegalStateException("already run still capturing now");
            }
            this.mCaptureStream = out;
            this.mCaptureFormat = captureFormat;
            this.mCaptureCompression = captureCompression;
            this.mSync.notifyAll();
            if (needWait) {
                while (this.isRunning && this.mCaptureStream != null) {
                    try {
                        this.mSync.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private static int getCaptureFormat(@NonNull String path) throws IllegalArgumentException {
        int result;
        String _path = path.toLowerCase();
        if (path.endsWith(".jpg") || path.endsWith(".jpeg")) {
            result = 0;
        } else if (path.endsWith(".png")) {
            result = 1;
        } else if (path.endsWith(".webp")) {
            result = 2;
        } else {
            throw new IllegalArgumentException("unknown compress format(extension)");
        }
        return result;
    }

    private static Bitmap.CompressFormat getCaptureFormat(int captureFormat) {
        Bitmap.CompressFormat result;
        switch (captureFormat) {
            case 0: {
                result = Bitmap.CompressFormat.JPEG;
                break;
            }
            case 1: {
                result = Bitmap.CompressFormat.PNG;
                break;
            }
            case 2: {
                result = Bitmap.CompressFormat.WEBP;
                break;
            }
            default: {
                result = Bitmap.CompressFormat.JPEG;
            }
        }
        return result;
    }

    @NonNull
    protected abstract RendererTask createRendererTask(int var1, int var2, int var3, EGLBase.IContext var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startCaptureTask() {
        new Thread(this.mCaptureTask, CAPTURE_THREAD_NAME).start();
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isRunning) {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCapture() {
        Runnable runnable = this.mCaptureTask;
        synchronized (runnable) {
            this.mCaptureTask.notify();
        }
    }

    protected void callOnCreate(Surface surface) {
        if (this.mCallback != null) {
            try {
                this.mCallback.onCreate(surface);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void callOnFrameAvailable() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onFrameAvailable();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void callOnDestroy() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onDestroy();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void setupCaptureDrawer(GLDrawer2D drawer) {
    }

    protected static void setMirror(float[] mvp, int mirror) {
        switch (mirror) {
            case 0: {
                mvp[0] = Math.abs(mvp[0]);
                mvp[5] = Math.abs(mvp[5]);
                break;
            }
            case 1: {
                mvp[0] = -Math.abs(mvp[0]);
                mvp[5] = Math.abs(mvp[5]);
                break;
            }
            case 2: {
                mvp[0] = Math.abs(mvp[0]);
                mvp[5] = -Math.abs(mvp[5]);
                break;
            }
            case 3: {
                mvp[0] = -Math.abs(mvp[0]);
                mvp[5] = -Math.abs(mvp[5]);
            }
        }
    }

    protected static void rotate(float[] mvp, int degrees) {
        if (degrees % 180 != 0) {
            Matrix.rotateM((float[])mvp, (int)0, (float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected static void setRotation(float[] mvp, int degrees) {
        Matrix.setIdentityM((float[])mvp, (int)0);
        if (degrees % 180 != 0) {
            Matrix.rotateM((float[])mvp, (int)0, (float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected static abstract class RendererTask
    extends BaseRendererTask {
        protected GLDrawer2D mDrawer;

        public RendererTask(@NonNull AbstractRendererHolder parent, int width, int height) {
            super(parent, width, height);
        }

        public RendererTask(@NonNull AbstractRendererHolder parent, int width, int height, int maxClientVersion, EGLBase.IContext sharedContext, int flags) {
            super(parent, width, height, maxClientVersion, sharedContext, flags);
        }

        @Override
        protected void internalOnStart() {
            this.mDrawer = new GLDrawer2D(true);
        }

        @Override
        protected void internalOnStop() {
            if (this.mDrawer != null) {
                this.mDrawer.release();
                this.mDrawer = null;
            }
        }

        @Override
        protected void preprocess() {
        }

        @Override
        protected void onDrawClient(@NonNull RendererSurfaceRec client, int texId, float[] texMatrix) {
            client.draw(this.mDrawer, texId, texMatrix);
        }
    }

    protected static abstract class BaseRendererTask
    extends EglTask {
        private final SparseArray<RendererSurfaceRec> mClients = new SparseArray();
        private final AbstractRendererHolder mParent;
        private int mVideoWidth;
        private int mVideoHeight;
        final float[] mTexMatrix = new float[16];
        int mTexId;
        private SurfaceTexture mMasterTexture;
        private Surface mMasterSurface;
        private int mMirror = 0;
        private int mRotation = 0;
        private volatile boolean mIsFirstFrameRendered;
        protected final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                this.removeRequest(1);
                mIsFirstFrameRendered = true;
                this.offer(1);
            }
        };

        public BaseRendererTask(@NonNull AbstractRendererHolder parent, int width, int height) {
            this(parent, width, height, 3, null, 2);
        }

        public BaseRendererTask(@NonNull AbstractRendererHolder parent, int width, int height, int maxClientVersion, EGLBase.IContext sharedContext, int flags) {
            super(maxClientVersion, sharedContext, flags);
            this.mParent = parent;
            this.mVideoWidth = width > 0 ? width : 640;
            this.mVideoHeight = height > 0 ? height : 480;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onStart() {
            this.handleReCreateMasterSurface();
            this.internalOnStart();
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = true;
                this.mParent.mSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onStop() {
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = false;
                this.mParent.mSync.notifyAll();
            }
            this.makeCurrent();
            this.internalOnStop();
            this.handleReleaseMasterSurface();
            this.handleRemoveAll();
        }

        @Override
        protected boolean onError(Exception e) {
            return false;
        }

        protected abstract void internalOnStart();

        protected abstract void internalOnStop();

        @Override
        protected Object processRequest(int request, int arg1, int arg2, Object obj) {
            switch (request) {
                case 1: {
                    this.handleDraw();
                    break;
                }
                case 2: {
                    this.handleResize(arg1, arg2);
                    break;
                }
                case 3: {
                    this.handleAddSurface(arg1, obj, arg2);
                    break;
                }
                case 4: {
                    this.handleRemoveSurface(arg1);
                    break;
                }
                case 12: {
                    this.handleRemoveAll();
                    break;
                }
                case 5: {
                    this.handleReCreateMasterSurface();
                    break;
                }
                case 6: {
                    this.handleMirror(arg1);
                    break;
                }
                case 7: {
                    this.handleRotate(arg1, arg2);
                    break;
                }
                case 8: {
                    this.handleClear(arg1, arg2);
                    break;
                }
                case 9: {
                    this.handleClearAll(arg1);
                    break;
                }
                case 10: {
                    this.handleSetMvp(arg1, arg2, obj);
                }
            }
            return null;
        }

        public Surface getSurface() {
            this.checkMasterSurface();
            return this.mMasterSurface;
        }

        public SurfaceTexture getSurfaceTexture() {
            this.checkMasterSurface();
            return this.mMasterTexture;
        }

        public void addSurface(int id2, Object surface) throws IllegalStateException, IllegalArgumentException {
            this.addSurface(id2, surface, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSurface(int id2, Object surface, int maxFps) throws IllegalStateException, IllegalArgumentException {
            this.checkFinished();
            if (!(surface instanceof SurfaceTexture || surface instanceof Surface || surface instanceof SurfaceHolder)) {
                throw new IllegalArgumentException("Surface should be one of Surface, SurfaceTexture or SurfaceHolder");
            }
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                if (this.mClients.get(id2) == null) {
                    while (this.isRunning()) {
                        if (this.offer(3, id2, maxFps, surface)) {
                            try {
                                this.mClients.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mClients.wait(5L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSurface(int id2) {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                if (this.mClients.get(id2) != null) {
                    while (this.isRunning()) {
                        if (this.offer(4, id2)) {
                            try {
                                this.mClients.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mClients.wait(5L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSurfaceAll() {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                while (this.isRunning()) {
                    if (this.offer(12)) {
                        try {
                            this.mClients.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                    try {
                        this.mClients.wait(5L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }

        public void clearSurface(int id2, int color) {
            this.checkFinished();
            this.offer(8, id2, color);
        }

        public void clearSurfaceAll(int color) {
            this.checkFinished();
            this.offer(9, color);
        }

        public void setMvpMatrix(int id2, int offset, @NonNull float[] matrix) {
            this.checkFinished();
            this.offer(10, id2, offset, matrix);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(int id2) {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                RendererSurfaceRec rec = (RendererSurfaceRec)this.mClients.get(id2);
                return rec != null && rec.isEnabled();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(int id2, boolean enable) {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                RendererSurfaceRec rec = (RendererSurfaceRec)this.mClients.get(id2);
                if (rec != null) {
                    rec.setEnabled(enable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCount() {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                return this.mClients.size();
            }
        }

        public void resize(int width, int height) throws IllegalStateException {
            this.checkFinished();
            if (width > 0 && height > 0 && (this.mVideoWidth != width || this.mVideoHeight != height)) {
                this.offer(2, width, height);
            }
        }

        protected int width() {
            return this.mVideoWidth;
        }

        protected int height() {
            return this.mVideoHeight;
        }

        public void mirror(int mirror) {
            this.checkFinished();
            if (this.mMirror != mirror) {
                this.offer(6, mirror);
            }
        }

        public int mirror() {
            return this.mMirror;
        }

        public void checkMasterSurface() {
            this.checkFinished();
            if (this.mMasterSurface == null || !this.mMasterSurface.isValid()) {
                Log.d((String)TAG, (String)"checkMasterSurface:invalid master surface");
                this.offerAndWait(5, 0, 0, null);
            }
        }

        protected void checkFinished() throws IllegalStateException {
            if (this.isFinished()) {
                throw new IllegalStateException("already finished");
            }
        }

        protected AbstractRendererHolder getParent() {
            return this.mParent;
        }

        protected void handleDraw() {
            if (this.mMasterSurface == null || !this.mMasterSurface.isValid()) {
                Log.e((String)TAG, (String)"checkMasterSurface:invalid master surface");
                this.offer(5);
                return;
            }
            if (this.mIsFirstFrameRendered) {
                try {
                    this.makeCurrent();
                    this.handleUpdateTexture();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("draw:thread id =" + Thread.currentThread().getId()), (Throwable)e);
                    this.offer(5);
                    return;
                }
                this.mParent.notifyCapture();
                this.preprocess();
                this.handleDrawClients();
                this.mParent.callOnFrameAvailable();
            }
            this.makeCurrent();
            GLES20.glClear((int)16384);
            GLES20.glFlush();
        }

        protected void handleUpdateTexture() {
            this.mMasterTexture.updateTexImage();
            this.mMasterTexture.getTransformMatrix(this.mTexMatrix);
        }

        protected abstract void preprocess();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleDrawClients() {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                int n = this.mClients.size();
                for (int i = n - 1; i >= 0; --i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null || !client.canDraw()) continue;
                    try {
                        this.onDrawClient(client, this.mTexId, this.mTexMatrix);
                        continue;
                    }
                    catch (Exception e) {
                        this.mClients.removeAt(i);
                        client.release();
                    }
                }
            }
        }

        protected abstract void onDrawClient(@NonNull RendererSurfaceRec var1, int var2, float[] var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleAddSurface(int id2, Object surface, int maxFps) {
            this.checkSurface();
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client == null) {
                    try {
                        client = RendererSurfaceRec.newInstance(this.getEgl(), surface, maxFps);
                        this.setMirror(client, this.mMirror);
                        this.mClients.append(id2, (Object)client);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)("invalid surface: surface=" + surface), (Throwable)e);
                    }
                } else {
                    Log.w((String)TAG, (String)("surface is already added: id=" + id2));
                }
                this.mClients.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleRemoveSurface(int id2) {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client != null) {
                    this.mClients.remove(id2);
                    if (client.isValid()) {
                        client.clear(0);
                    }
                    client.release();
                }
                this.checkSurface();
                this.mClients.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleRemoveAll() {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null) continue;
                    if (client.isValid()) {
                        client.clear(0);
                    }
                    client.release();
                }
                this.mClients.clear();
                this.mClients.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkSurface() {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null || client.isValid()) continue;
                    int id2 = this.mClients.keyAt(i);
                    ((RendererSurfaceRec)this.mClients.valueAt(i)).release();
                    this.mClients.remove(id2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleClear(int id2, int color) {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client != null && client.isValid()) {
                    client.clear(color);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleClearAll(int color) {
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null || !client.isValid()) continue;
                    client.clear(color);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleSetMvp(int id2, int offset, Object mvp) {
            if (mvp instanceof float[] && ((float[])mvp).length >= 16 + offset) {
                float[] array = (float[])mvp;
                SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
                synchronized (sparseArray) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                    if (client != null && client.isValid()) {
                        System.arraycopy(array, offset, client.mMvpMatrix, 0, 16);
                    }
                }
            }
        }

        @SuppressLint(value={"NewApi"})
        protected void handleReCreateMasterSurface() {
            this.makeCurrent();
            this.handleReleaseMasterSurface();
            this.makeCurrent();
            this.mTexId = GLHelper.initTex(36197, 9728);
            this.mMasterTexture = new SurfaceTexture(this.mTexId);
            this.mMasterSurface = new Surface(this.mMasterTexture);
            if (BuildCheck.isAndroid4_1()) {
                this.mMasterTexture.setDefaultBufferSize(this.mVideoWidth, this.mVideoHeight);
            }
            this.mMasterTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
            this.mParent.callOnCreate(this.mMasterSurface);
        }

        protected void handleReleaseMasterSurface() {
            if (this.mMasterSurface != null) {
                try {
                    this.mMasterSurface.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mMasterSurface = null;
                this.mParent.callOnDestroy();
            }
            if (this.mMasterTexture != null) {
                try {
                    this.mMasterTexture.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mMasterTexture = null;
            }
            if (this.mTexId != 0) {
                GLHelper.deleteTex(this.mTexId);
                this.mTexId = 0;
            }
        }

        @SuppressLint(value={"NewApi"})
        protected void handleResize(int width, int height) {
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            if (BuildCheck.isAndroid4_1()) {
                this.mMasterTexture.setDefaultBufferSize(this.mVideoWidth, this.mVideoHeight);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleMirror(int mirror) {
            this.mMirror = mirror;
            SparseArray<RendererSurfaceRec> sparseArray = this.mClients;
            synchronized (sparseArray) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null) continue;
                    this.setMirror(client, mirror);
                }
            }
        }

        protected void setMirror(RendererSurfaceRec client, int mirror) {
            RendererHolder.setMirror(client.mMvpMatrix, mirror);
        }

        protected void handleRotate(int id2, int degree) {
        }
    }
}

