/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jiangdg.graphics.BitmapHelper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SQLiteBlobHelper {
    public static byte[] floatArrayToByteArray(@NonNull float[] array, int offset, int num) {
        int i;
        ByteBuffer buf = ByteBuffer.allocate(num * 32 / 8);
        buf.order(ByteOrder.nativeOrder());
        int n8 = num % 8 + offset;
        int n = offset + num;
        for (i = offset; i < n8; ++i) {
            buf.putFloat(array[i]);
        }
        for (i = n8; i < n; i += 8) {
            buf.putFloat(array[i]);
            buf.putFloat(array[i + 1]);
            buf.putFloat(array[i + 2]);
            buf.putFloat(array[i + 3]);
            buf.putFloat(array[i + 4]);
            buf.putFloat(array[i + 5]);
            buf.putFloat(array[i + 6]);
            buf.putFloat(array[i + 7]);
        }
        buf.flip();
        return buf.array();
    }

    @Nullable
    public static float[] byteArrayToFloatArray(@Nullable byte[] bytes) {
        int i;
        if (bytes == null || bytes.length < 4) {
            return null;
        }
        ByteBuffer tmp = ByteBuffer.wrap(bytes);
        tmp.order(ByteOrder.nativeOrder());
        int n = tmp.limit() / 4;
        float[] array = new float[n];
        int n8 = n % 8;
        for (i = 0; i < n8; ++i) {
            array[i] = tmp.getFloat();
        }
        for (i = n8; i < n; i += 8) {
            array[i] = tmp.getFloat();
            array[i + 1] = tmp.getFloat();
            array[i + 2] = tmp.getFloat();
            array[i + 3] = tmp.getFloat();
            array[i + 4] = tmp.getFloat();
            array[i + 5] = tmp.getFloat();
            array[i + 6] = tmp.getFloat();
            array[i + 7] = tmp.getFloat();
        }
        return array;
    }

    public static byte[] doubleArrayToByteArray(@NonNull double[] array, int offset, int num) {
        int i;
        ByteBuffer buf = ByteBuffer.allocate(num * 64 / 8);
        buf.order(ByteOrder.nativeOrder());
        int n8 = num % 8 + offset;
        int n = offset + num;
        for (i = offset; i < n8; ++i) {
            buf.putDouble(array[i]);
        }
        for (i = n8; i < n; i += 8) {
            buf.putDouble(array[i]);
            buf.putDouble(array[i + 1]);
            buf.putDouble(array[i + 2]);
            buf.putDouble(array[i + 3]);
            buf.putDouble(array[i + 4]);
            buf.putDouble(array[i + 5]);
            buf.putDouble(array[i + 6]);
            buf.putDouble(array[i + 7]);
        }
        buf.flip();
        return buf.array();
    }

    @Nullable
    public static double[] byteArrayToDoubleArray(@Nullable byte[] bytes) {
        int i;
        if (bytes == null || bytes.length < 8) {
            return null;
        }
        ByteBuffer tmp = ByteBuffer.wrap(bytes);
        tmp.order(ByteOrder.nativeOrder());
        int n = tmp.limit() / 8;
        double[] array = new double[n];
        int n8 = n % 8;
        for (i = 0; i < n8; ++i) {
            array[i] = tmp.getDouble();
        }
        for (i = n8; i < n; i += 8) {
            array[i] = tmp.getDouble();
            array[i + 1] = tmp.getDouble();
            array[i + 2] = tmp.getDouble();
            array[i + 3] = tmp.getDouble();
            array[i + 4] = tmp.getDouble();
            array[i + 5] = tmp.getDouble();
            array[i + 6] = tmp.getDouble();
            array[i + 7] = tmp.getDouble();
        }
        return array;
    }

    public static byte[] intArrayToByteArray(@NonNull int[] array, int offset, int num) {
        int i;
        ByteBuffer buf = ByteBuffer.allocate(num * 32 / 8);
        buf.order(ByteOrder.nativeOrder());
        int n8 = num % 8 + offset;
        int n = offset + num;
        for (i = offset; i < n8; ++i) {
            buf.putInt(array[i]);
        }
        for (i = n8; i < n; i += 8) {
            buf.putInt(array[i]);
            buf.putInt(array[i + 1]);
            buf.putInt(array[i + 2]);
            buf.putInt(array[i + 3]);
            buf.putInt(array[i + 4]);
            buf.putInt(array[i + 5]);
            buf.putInt(array[i + 6]);
            buf.putInt(array[i + 7]);
        }
        buf.flip();
        return buf.array();
    }

    @Nullable
    public static int[] byteArrayToIntArray(@Nullable byte[] bytes) {
        int i;
        if (bytes == null || bytes.length < 4) {
            return null;
        }
        ByteBuffer tmp = ByteBuffer.wrap(bytes);
        tmp.order(ByteOrder.nativeOrder());
        int n = tmp.limit() / 4;
        int[] array = new int[n];
        int n8 = n % 8;
        for (i = 0; i < n8; ++i) {
            array[i] = tmp.getInt();
        }
        for (i = n8; i < n; i += 8) {
            array[i] = tmp.getInt();
            array[i + 1] = tmp.getInt();
            array[i + 2] = tmp.getInt();
            array[i + 3] = tmp.getInt();
            array[i + 4] = tmp.getInt();
            array[i + 5] = tmp.getInt();
            array[i + 6] = tmp.getInt();
            array[i + 7] = tmp.getInt();
        }
        return array;
    }

    public static byte[] shortArrayToByteArray(@NonNull short[] array, int offset, int num) {
        int i;
        ByteBuffer buf = ByteBuffer.allocate(num * 16 / 8);
        buf.order(ByteOrder.nativeOrder());
        int n8 = num % 8 + offset;
        int n = offset + num;
        for (i = offset; i < n8; ++i) {
            buf.putShort(array[i]);
        }
        for (i = n8; i < n; i += 8) {
            buf.putShort(array[i]);
            buf.putShort(array[i + 1]);
            buf.putShort(array[i + 2]);
            buf.putShort(array[i + 3]);
            buf.putShort(array[i + 4]);
            buf.putShort(array[i + 5]);
            buf.putShort(array[i + 6]);
            buf.putShort(array[i + 7]);
        }
        buf.flip();
        return buf.array();
    }

    @Nullable
    public static short[] byteArrayToShortArray(@Nullable byte[] bytes) {
        int i;
        if (bytes == null || bytes.length < 2) {
            return null;
        }
        ByteBuffer tmp = ByteBuffer.wrap(bytes);
        tmp.order(ByteOrder.nativeOrder());
        int n = tmp.limit() / 2;
        short[] buf = new short[n];
        int n8 = n % 8;
        for (i = 0; i < n8; ++i) {
            buf[i] = tmp.getShort();
        }
        for (i = n8; i < n; i += 8) {
            buf[i] = tmp.getShort();
            buf[i + 1] = tmp.getShort();
            buf[i + 2] = tmp.getShort();
            buf[i + 3] = tmp.getShort();
            buf[i + 4] = tmp.getShort();
            buf[i + 5] = tmp.getShort();
            buf[i + 6] = tmp.getShort();
            buf[i + 7] = tmp.getShort();
        }
        return buf;
    }

    public static byte[] longArrayToByteArray(@NonNull long[] array, int offset, int num) {
        int i;
        ByteBuffer buf = ByteBuffer.allocate(num * 64 / 8);
        buf.order(ByteOrder.nativeOrder());
        int n8 = num % 8 + offset;
        int n = offset + num;
        for (i = offset; i < n8; ++i) {
            buf.putLong(array[i]);
        }
        for (i = n8; i < n; i += 8) {
            buf.putLong(array[i]);
            buf.putLong(array[i + 1]);
            buf.putLong(array[i + 2]);
            buf.putLong(array[i + 3]);
            buf.putLong(array[i + 4]);
            buf.putLong(array[i + 5]);
            buf.putLong(array[i + 6]);
            buf.putLong(array[i + 7]);
        }
        buf.flip();
        return buf.array();
    }

    @Nullable
    public static long[] byteArrayToLongArray(@Nullable byte[] bytes) {
        int i;
        if (bytes == null || bytes.length < 8) {
            return null;
        }
        ByteBuffer tmp = ByteBuffer.wrap(bytes);
        tmp.order(ByteOrder.nativeOrder());
        int n = tmp.limit() / 8;
        long[] array = new long[n];
        int n8 = n % 8;
        for (i = 0; i < n8; ++i) {
            array[i] = tmp.getLong();
        }
        for (i = n8; i < n; i += 8) {
            array[i] = tmp.getLong();
            array[i + 1] = tmp.getLong();
            array[i + 2] = tmp.getLong();
            array[i + 3] = tmp.getLong();
            array[i + 4] = tmp.getLong();
            array[i + 5] = tmp.getLong();
            array[i + 6] = tmp.getLong();
            array[i + 7] = tmp.getLong();
        }
        return array;
    }

    public static void bindBlobFloatArray(@NonNull SQLiteStatement stat, int index, @NonNull float[] array) {
        stat.bindBlob(index, SQLiteBlobHelper.floatArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobFloatArray(@NonNull SQLiteStatement stat, int index, @NonNull float[] array, int offset, int num) {
        stat.bindBlob(index, SQLiteBlobHelper.floatArrayToByteArray(array, offset, num));
    }

    public static void bindBlobDoubleArray(@NonNull SQLiteStatement stat, int index, @NonNull double[] array) {
        stat.bindBlob(index, SQLiteBlobHelper.doubleArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobDoubleArray(@NonNull SQLiteStatement stat, int index, @NonNull double[] array, int offset, int num) {
        stat.bindBlob(index, SQLiteBlobHelper.doubleArrayToByteArray(array, offset, num));
    }

    public static void bindBlobIntArray(@NonNull SQLiteStatement stat, int index, @NonNull int[] array) {
        stat.bindBlob(index, SQLiteBlobHelper.intArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobIntArray(@NonNull SQLiteStatement stat, int index, @NonNull int[] array, int offset, int num) {
        stat.bindBlob(index, SQLiteBlobHelper.intArrayToByteArray(array, offset, num));
    }

    public static void bindBlobShortArray(@NonNull SQLiteStatement stat, int index, @NonNull short[] array) {
        stat.bindBlob(index, SQLiteBlobHelper.shortArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobShortArray(@NonNull SQLiteStatement stat, int index, @NonNull short[] array, int offset, int num) {
        stat.bindBlob(index, SQLiteBlobHelper.shortArrayToByteArray(array, offset, num));
    }

    public static void bindBlobLongArray(@NonNull SQLiteStatement stat, int index, @NonNull long[] array) {
        stat.bindBlob(index, SQLiteBlobHelper.longArrayToByteArray(array, 0, array.length));
    }

    public static void bindBlobLongArray(@NonNull SQLiteStatement stat, int index, long[] array, int offset, int num) {
        stat.bindBlob(index, SQLiteBlobHelper.longArrayToByteArray(array, offset, num));
    }

    public static void bindBlobBitmap(@NonNull SQLiteStatement stat, int index, @NonNull Bitmap bitmap) {
        stat.bindBlob(index, BitmapHelper.BitmapToByteArray(bitmap));
    }

    public static float[] getBlobFloatArray(@NonNull Cursor cursor, int columnIndex) {
        return SQLiteBlobHelper.byteArrayToFloatArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static float[] getBlobFloatArray(@NonNull Cursor cursor, String columnName, @Nullable float[] defaultValue) {
        float[] result = SQLiteBlobHelper.byteArrayToFloatArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static double[] getBlobDoubleArray(@NonNull Cursor cursor, int columnIndex) {
        return SQLiteBlobHelper.byteArrayToDoubleArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static double[] getBlobDoubleArray(@NonNull Cursor cursor, String columnName, @Nullable double[] defaultValue) {
        double[] result = SQLiteBlobHelper.byteArrayToDoubleArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Nullable
    public static byte[] getBlob(@NonNull Cursor cursor, String columnName, @Nullable byte[] defaultValue) {
        byte[] result = defaultValue;
        try {
            result = cursor.getBlob(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int[] getBlobIntArray(@NonNull Cursor cursor, int columnIndex) {
        return SQLiteBlobHelper.byteArrayToIntArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static int[] getBlobIntArray(@NonNull Cursor cursor, String columnName, @Nullable int[] defaultValue) {
        int[] result = SQLiteBlobHelper.byteArrayToIntArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static short[] getBlobShortArray(@NonNull Cursor cursor, int columnIndex) {
        return SQLiteBlobHelper.byteArrayToShortArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static short[] getBlobShortArray(@NonNull Cursor cursor, String columnName, @Nullable short[] defaultValue) {
        short[] result = SQLiteBlobHelper.byteArrayToShortArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static long[] getBlobLongArray(@NonNull Cursor cursor, int columnIndex) {
        return SQLiteBlobHelper.byteArrayToLongArray(cursor.getBlob(columnIndex));
    }

    @Nullable
    public static long[] getBlobLongArray(@NonNull Cursor cursor, String columnName, @Nullable long[] defaultValue) {
        long[] result = SQLiteBlobHelper.byteArrayToLongArray(SQLiteBlobHelper.getBlob(cursor, columnName, null));
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static Bitmap getBlobBitmap(@NonNull Cursor cursor, int columnIndex) {
        return BitmapHelper.asBitmap(cursor.getBlob(columnIndex));
    }

    public static Bitmap getBlobBitmap(@NonNull Cursor cursor, String columnName) {
        return BitmapHelper.asBitmap(SQLiteBlobHelper.getBlob(cursor, columnName, null));
    }

    @Nullable
    public static Bitmap getBlobBitmap(@NonNull Cursor cursor, int columnIndex, int requestWidth, int requestHeight) {
        return BitmapHelper.asBitmap(cursor.getBlob(columnIndex), requestWidth, requestHeight);
    }

    @Nullable
    public static Bitmap getBlobBitmap(@NonNull Cursor cursor, String columnName, int requestWidth, int requestHeight) {
        return BitmapHelper.asBitmap(SQLiteBlobHelper.getBlob(cursor, columnName, null), requestWidth, requestHeight);
    }

    @Nullable
    public static Bitmap getBlobBitmapStrictSize(@NonNull Cursor cursor, int columnIndex, int requestWidth, int requestHeight) {
        return BitmapHelper.asBitmapStrictSize(cursor.getBlob(columnIndex), requestWidth, requestHeight);
    }

    @Nullable
    public static Bitmap getBlobBitmapStrictSize(@NonNull Cursor cursor, String columnName, int requestWidth, int requestHeight) {
        return BitmapHelper.asBitmapStrictSize(SQLiteBlobHelper.getBlob(cursor, columnName, null), requestWidth, requestHeight);
    }
}

