/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.bluetooth;

import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;

public class BluetoothDeviceInfo
implements Parcelable {
    public static final Parcelable.Creator<BluetoothDeviceInfo> CREATOR = new Parcelable.Creator<BluetoothDeviceInfo>(){

        public BluetoothDeviceInfo createFromParcel(Parcel in) {
            return new BluetoothDeviceInfo(in);
        }

        public BluetoothDeviceInfo[] newArray(int size) {
            return new BluetoothDeviceInfo[size];
        }
    };
    public final String name;
    public final String address;
    public final int type;
    public final int deviceClass;
    public final int bondState;

    BluetoothDeviceInfo(BluetoothDevice device) {
        this.name = device.getName();
        this.address = device.getAddress();
        this.type = Build.VERSION.SDK_INT >= 18 ? device.getType() : 0;
        BluetoothClass clazz = device.getBluetoothClass();
        this.deviceClass = clazz != null ? clazz.getDeviceClass() : 0;
        this.bondState = device.getBondState();
    }

    protected BluetoothDeviceInfo(Parcel in) {
        this.name = in.readString();
        this.address = in.readString();
        this.type = in.readInt();
        this.deviceClass = in.readInt();
        this.bondState = in.readInt();
    }

    public boolean isPaired() {
        return this.bondState == 12;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.name);
        parcel.writeString(this.address);
        parcel.writeInt(this.type);
        parcel.writeInt(this.deviceClass);
        parcel.writeInt(this.bondState);
    }

    public String toString() {
        return String.format("BluetoothDeviceInfo(%s/%s)", this.name, this.address);
    }
}

