/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.bluetooth;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import com.serenegiant.bluetooth.BluetoothDeviceInfo;
import com.serenegiant.common.R;
import java.util.List;

public class BluetoothDeviceInfoAdapter
extends ArrayAdapter<BluetoothDeviceInfo> {
    private static final String TAG = BluetoothDeviceInfoAdapter.class.getSimpleName();
    private final LayoutInflater mInflater;
    private final int mLayoutId;

    public BluetoothDeviceInfoAdapter(@NonNull Context context, @LayoutRes int resource) {
        super(context, resource);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = resource;
    }

    public BluetoothDeviceInfoAdapter(@NonNull Context context, @LayoutRes int resource, List<BluetoothDeviceInfo> objects) {
        super(context, resource, objects);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = resource;
    }

    public BluetoothDeviceInfoAdapter(@NonNull Context context, @LayoutRes int resource, BluetoothDeviceInfo[] objects) {
        super(context, resource, (Object[])objects);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = resource;
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        View rootView = convertView;
        if (rootView == null) {
            rootView = this.mInflater.inflate(this.mLayoutId, parent, false);
            ViewHolder holder = new ViewHolder();
            holder.nameTv = (TextView)rootView.findViewById(R.id.name);
            holder.addressTv = (TextView)rootView.findViewById(R.id.address);
            holder.icon = (ImageView)rootView.findViewById(R.id.icon);
            rootView.setTag((Object)holder);
        }
        ViewHolder holder = (ViewHolder)rootView.getTag();
        try {
            BluetoothDeviceInfo item = (BluetoothDeviceInfo)this.getItem(position);
            if (item != null) {
                if (holder.nameTv != null) {
                    holder.nameTv.setText((CharSequence)item.name);
                }
                if (holder.addressTv != null) {
                    holder.addressTv.setText((CharSequence)item.address);
                }
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return rootView;
    }

    private static class ViewHolder {
        ImageView icon;
        TextView nameTv;
        TextView addressTv;

        private ViewHolder() {
        }
    }
}

