/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.Checkable;
import androidx.appcompat.widget.AppCompatImageButton;

public class CheckableImageButton
extends AppCompatImageButton
implements Checkable {
    private static final boolean DEBUG = false;
    private static final String TAG = CheckableImageButton.class.getSimpleName();
    private boolean mIsChecked;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public CheckableImageButton(Context context) {
        this(context, null, 0);
    }

    public CheckableImageButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CheckableImageButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setChecked(boolean checked) {
        if (this.mIsChecked != checked) {
            this.mIsChecked = checked;
            this.refreshDrawableState();
        }
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void toggle() {
        this.setChecked(!this.mIsChecked);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckableImageButton.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }
}

