/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReentrantReadWriteReference<T> {
    private final ReentrantReadWriteLock mSensorLock = new ReentrantReadWriteLock();
    private final Lock mReadLock = this.mSensorLock.readLock();
    private final Lock mWriteLock = this.mSensorLock.writeLock();
    private T mRef;

    public ReentrantReadWriteReference() {
    }

    public ReentrantReadWriteReference(@Nullable T obj) {
        this.set(obj);
    }

    public ReentrantReadWriteReference(@Nullable WeakReference<T> ref) {
        this.set(ref);
    }

    public ReentrantReadWriteReference(@Nullable ReentrantReadWriteReference<T> ref) {
        if (ref != null) {
            this.set(ref.get());
        }
    }

    @Nullable
    public T get() {
        this.mReadLock.lock();
        try {
            T t = this.mRef;
            return t;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Nullable
    public T tryGet() {
        if (this.mReadLock.tryLock()) {
            try {
                T t = this.mRef;
                return t;
            }
            finally {
                this.mReadLock.unlock();
            }
        }
        return null;
    }

    @Nullable
    public T set(@Nullable T obj) {
        T prev;
        this.mWriteLock.lock();
        try {
            prev = this.mRef;
            this.mRef = obj;
        }
        finally {
            this.mWriteLock.unlock();
        }
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T set(@Nullable WeakReference<T> ref) {
        T prev;
        Object obj = ref != null ? ref.get() : null;
        this.mWriteLock.lock();
        try {
            prev = this.mRef;
            this.mRef = obj;
        }
        finally {
            this.mWriteLock.unlock();
        }
        return prev;
    }

    @Nullable
    public T set(@Nullable ReentrantReadWriteReference<T> ref) {
        return this.set(ref != null ? (T)ref.get() : null);
    }

    @Nullable
    public T clear() {
        return this.set((T)null);
    }

    @Nullable
    public T swap(@Nullable T ref) {
        return this.set(ref);
    }

    public boolean isEmpty() {
        return this.tryGet() == null;
    }

    public void readLock() {
        this.mReadLock.lock();
    }

    public void readUnlock() {
        this.mReadLock.unlock();
    }

    public void writeLock() {
        this.mWriteLock.lock();
    }

    public void writeUnlock() {
        this.mWriteLock.unlock();
    }
}

