/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class Pool<T> {
    private final List<T> mPool = new ArrayList<T>();
    private final int mInitNum;
    private final int mMaxNumInPool;
    private final int mLimitNum;
    private int mCreatedObjects;

    public Pool(int initNum, int maxNumInPool) {
        this(initNum, maxNumInPool, maxNumInPool);
    }

    public Pool(int initNum, int maxNumInPool, int limitNum) {
        this.mInitNum = initNum;
        this.mMaxNumInPool = maxNumInPool < limitNum ? maxNumInPool : limitNum;
        this.mLimitNum = limitNum;
        this.init();
    }

    public void init() {
        this.clear();
        for (int i = 0; i < this.mInitNum && i < this.mMaxNumInPool; ++i) {
            T obj = this.createObject(new Object[0]);
            if (obj == null) continue;
            this.mPool.add(obj);
            ++this.mCreatedObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T obtain(Object ... args) {
        T result = null;
        List<T> list = this.mPool;
        synchronized (list) {
            if (!this.mPool.isEmpty()) {
                result = this.mPool.remove(this.mPool.size() - 1);
            }
            if (result == null && this.mCreatedObjects < this.mLimitNum && (result = (T)this.createObject(args)) != null) {
                ++this.mCreatedObjects;
            }
        }
        return result;
    }

    @Nullable
    protected abstract T createObject(Object ... var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(@NonNull T obj) {
        List<T> list = this.mPool;
        synchronized (list) {
            if (this.mPool.size() < this.mMaxNumInPool) {
                this.mPool.add(obj);
            } else {
                --this.mCreatedObjects;
            }
        }
    }

    public void recycle(@NonNull Collection<T> objects) {
        for (T obj : objects) {
            if (obj == null) continue;
            this.recycle(obj);
        }
    }

    public void recycle(@NonNull T[] objects) {
        for (T obj : objects) {
            if (obj == null) continue;
            this.recycle(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<T> list = this.mPool;
        synchronized (list) {
            this.mPool.clear();
            this.mCreatedObjects = 0;
        }
    }
}

