/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaFormat;
import com.serenegiant.media.AbstractFakeEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.IVideoEncoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=16)
public class FakeVideoEncoder
extends AbstractFakeEncoder
implements IVideoEncoder {
    private static final String TAG = FakeVideoEncoder.class.getSimpleName();
    public static final String MIME_AVC = "video/avc";
    protected int mWidth;
    protected int mHeight;

    public FakeVideoEncoder(IRecorder recorder, EncoderListener listener) {
        super(MIME_AVC, recorder, listener);
    }

    public FakeVideoEncoder(IRecorder recorder, EncoderListener listener, int frameSz) {
        super(MIME_AVC, recorder, listener, frameSz);
    }

    public FakeVideoEncoder(IRecorder recorder, EncoderListener listener, int frameSz, int maxPoolSz, int maxQueueSz) {
        super(MIME_AVC, recorder, listener, frameSz, maxPoolSz, maxQueueSz);
    }

    public FakeVideoEncoder(String mime_type, IRecorder recorder, EncoderListener listener) {
        super(mime_type, recorder, listener);
    }

    public FakeVideoEncoder(String mime_type, IRecorder recorder, EncoderListener listener, int defaultFrameSz) {
        super(mime_type, recorder, listener, defaultFrameSz);
    }

    public FakeVideoEncoder(String mime_type, IRecorder recorder, EncoderListener listener, int defaultFrameSz, int maxPoolSz, int maxQueueSz) {
        super(mime_type, recorder, listener, defaultFrameSz, maxPoolSz, maxQueueSz);
    }

    @Override
    @Deprecated
    public boolean isAudio() {
        return false;
    }

    @Override
    protected MediaFormat createOutputFormat(String mime, byte[] csd, int size, int ix0, int ix1, int ix2) {
        MediaFormat outFormat;
        if (ix0 >= 0) {
            outFormat = MediaFormat.createVideoFormat((String)mime, (int)this.mWidth, (int)this.mHeight);
            ByteBuffer csd0 = ByteBuffer.allocateDirect(ix1 - ix0).order(ByteOrder.nativeOrder());
            csd0.put(csd, ix0, ix1 - ix0);
            csd0.flip();
            outFormat.setByteBuffer("csd-0", csd0);
            if (ix1 > ix0) {
                int sz = ix2 > ix1 ? ix2 - ix1 : size - ix1;
                ByteBuffer csd1 = ByteBuffer.allocateDirect(sz).order(ByteOrder.nativeOrder());
                csd1.put(csd, ix1, sz);
                csd1.flip();
                outFormat.setByteBuffer("csd-1", csd1);
            }
        } else {
            throw new RuntimeException("unexpected csd data came.");
        }
        return outFormat;
    }

    @Override
    public void setVideoSize(int width, int height) throws IllegalArgumentException, IllegalStateException {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }
}

