/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils.es1;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.opengl.GLES10;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import android.text.TextUtils;
import com.serenegiant.glutils.ITexture;
import com.serenegiant.glutils.es1.GLHelper;
import java.io.IOException;

public class GLTexture
implements ITexture {
    final int mTextureTarget;
    final int mTextureUnit;
    int mTextureId;
    final float[] mTexMatrix = new float[16];
    int mTexWidth;
    int mTexHeight;
    int mImageWidth;
    int mImageHeight;

    public GLTexture(int width, int height, int filter_param) {
        this(3553, 33984, width, height, filter_param);
    }

    public GLTexture(int texTarget, int texUnit, int width, int height, int filter_param) {
        int h;
        int w;
        this.mTextureTarget = texTarget;
        this.mTextureUnit = texUnit;
        for (w = 32; w < width; w <<= 1) {
        }
        for (h = 32; h < height; h <<= 1) {
        }
        if (this.mTexWidth != w || this.mTexHeight != h) {
            this.mTexWidth = w;
            this.mTexHeight = h;
        }
        this.mTextureId = GLHelper.initTex(this.mTextureTarget, filter_param);
        GLES10.glTexImage2D((int)this.mTextureTarget, (int)0, (int)6408, (int)this.mTexWidth, (int)this.mTexHeight, (int)0, (int)6408, (int)5121, null);
        Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
        this.mTexMatrix[0] = (float)width / (float)this.mTexWidth;
        this.mTexMatrix[5] = (float)height / (float)this.mTexHeight;
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @Override
    public void release() {
        if (this.mTextureId > 0) {
            GLHelper.deleteTex(this.mTextureId);
            this.mTextureId = 0;
        }
    }

    @Override
    public void bind() {
        GLES10.glActiveTexture((int)this.mTextureUnit);
        GLES10.glBindTexture((int)this.mTextureTarget, (int)this.mTextureId);
    }

    @Override
    public void unbind() {
        GLES10.glActiveTexture((int)this.mTextureUnit);
        GLES10.glBindTexture((int)this.mTextureTarget, (int)0);
    }

    @Override
    public int getTexTarget() {
        return this.mTextureTarget;
    }

    @Override
    public int getTexture() {
        return this.mTextureId;
    }

    @Override
    public float[] getTexMatrix() {
        return this.mTexMatrix;
    }

    @Override
    public void getTexMatrix(float[] matrix, int offset) {
        System.arraycopy(this.mTexMatrix, 0, matrix, offset, this.mTexMatrix.length);
    }

    @Override
    public int getTexWidth() {
        return this.mTexWidth;
    }

    @Override
    public int getTexHeight() {
        return this.mTexHeight;
    }

    @Override
    public void loadTexture(String filePath) throws NullPointerException, IOException {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new NullPointerException("image file path should not be a null");
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int imageWidth = options.outWidth;
        int imageHeight = options.outHeight;
        int inSampleSize = 1;
        if (imageHeight > this.mTexHeight || imageWidth > this.mTexWidth) {
            inSampleSize = imageWidth > imageHeight ? (int)Math.ceil((float)imageHeight / (float)this.mTexHeight) : (int)Math.ceil((float)imageWidth / (float)this.mTexWidth);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        this.loadTexture(BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options));
    }

    @Override
    public void loadTexture(Bitmap bitmap) throws NullPointerException {
        this.mImageWidth = bitmap.getWidth();
        this.mImageHeight = bitmap.getHeight();
        Bitmap texture = Bitmap.createBitmap((int)this.mTexWidth, (int)this.mTexHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(texture);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
        this.mTexMatrix[0] = (float)this.mImageWidth / (float)this.mTexWidth;
        this.mTexMatrix[5] = (float)this.mImageHeight / (float)this.mTexHeight;
        this.bind();
        GLUtils.texImage2D((int)this.mTextureTarget, (int)0, (Bitmap)texture, (int)0);
        this.unbind();
        texture.recycle();
    }
}

