/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReentrantReadWriteMap<K, V> {
    private final ReentrantReadWriteLock mSensorLock = new ReentrantReadWriteLock();
    private final Lock mReadLock = this.mSensorLock.readLock();
    private final Lock mWriteLock = this.mSensorLock.writeLock();
    private final Map<K, V> mMap = new HashMap();

    @Nullable
    public V get(@NonNull K key) {
        this.mReadLock.lock();
        try {
            V v = this.mMap.containsKey(key) ? (V)this.mMap.get(key) : null;
            return v;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Nullable
    public V tryGet(@NonNull K key) {
        if (this.mReadLock.tryLock()) {
            try {
                V v = this.mMap.containsKey(key) ? (V)this.mMap.get(key) : null;
                return v;
            }
            finally {
                this.mReadLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(@NonNull K key, @NonNull V value) {
        V prev;
        this.mWriteLock.lock();
        try {
            prev = this.mMap.remove(key);
            this.mMap.put(key, value);
        }
        finally {
            this.mWriteLock.unlock();
        }
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        V v;
        this.mWriteLock.lock();
        try {
            v = this.mMap.get(key);
            if (v == null) {
                v = this.mMap.put(key, value);
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
        return v;
    }

    public void putAll(@NonNull Map<? extends K, ? extends V> map) {
        this.mWriteLock.lock();
        try {
            this.mMap.putAll(map);
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public V remove(@NonNull K key) {
        this.mWriteLock.lock();
        try {
            V v = this.mMap.remove(key);
            return v;
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(@NonNull K key, V value) {
        V v = null;
        this.mWriteLock.lock();
        try {
            if (this.mMap.containsKey(key) && ReentrantReadWriteMap.isEquals(this.mMap.get(key), value)) {
                v = this.mMap.remove(key);
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
        return v;
    }

    public Collection<V> removeAll() {
        ArrayList<V> result = new ArrayList<V>();
        this.mWriteLock.lock();
        try {
            result.addAll(this.mMap.values());
            this.mMap.clear();
        }
        finally {
            this.mWriteLock.unlock();
        }
        return result;
    }

    public void clear() {
        this.mWriteLock.lock();
        try {
            this.mMap.clear();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public int size() {
        this.mReadLock.lock();
        try {
            int n = this.mMap.size();
            return n;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean containsKey(K key) {
        this.mReadLock.lock();
        try {
            boolean bl = this.mMap.containsKey(key);
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean containsValue(Object value) {
        this.mReadLock.lock();
        try {
            boolean bl = this.mMap.containsValue(value);
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrDefault(K key, @Nullable V defaultValue) {
        this.mReadLock.lock();
        try {
            V v = this.mMap.containsKey(key) ? this.mMap.get(key) : defaultValue;
            return v;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.mReadLock.lock();
        try {
            boolean bl = this.mMap.isEmpty();
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @NonNull
    public Collection<K> keys() {
        ArrayList<K> result = new ArrayList<K>();
        this.mReadLock.lock();
        try {
            result.addAll(this.mMap.keySet());
        }
        finally {
            this.mReadLock.unlock();
        }
        return result;
    }

    @NonNull
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        this.mReadLock.lock();
        try {
            if (!this.mMap.isEmpty()) {
                result.addAll(this.mMap.values());
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return result;
    }

    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        this.mReadLock.lock();
        try {
            result.addAll(this.mMap.entrySet());
        }
        finally {
            this.mReadLock.unlock();
        }
        return result;
    }

    private static final boolean isEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected void readLock() {
        this.mReadLock.lock();
    }

    protected void readUnlock() {
        this.mReadLock.unlock();
    }

    protected void writeLock() {
        this.mWriteLock.lock();
    }

    protected void writeUnlock() {
        this.mWriteLock.unlock();
    }

    protected Collection<V> valuesLocked() {
        return this.mMap.values();
    }

    protected Set<K> keysLocked() {
        return this.mMap.keySet();
    }

    protected Map<K, V> mapLocked() {
        return this.mMap;
    }
}

