/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.math;

import android.graphics.Rect;
import com.serenegiant.math.BaseBounds;
import com.serenegiant.math.Vector;

public class RectangleBounds
extends BaseBounds {
    private static final long serialVersionUID = 260429282595037220L;
    public final Vector box = new Vector();
    private final Rect boundsRect = new Rect();
    private final Vector w = new Vector();

    public RectangleBounds(float center_x, float center_y, float center_z, float width, float height, float depth) {
        this.position.set(center_x, center_y, center_z);
        this.box.set(width / 2.0f, height / 2.0f, depth / 2.0f);
        this.radius = this.box.len();
    }

    public RectangleBounds(float center_x, float center_y, float width, float height) {
        this(center_x, center_y, 0.0f, width, height, 0.0f);
    }

    public RectangleBounds(Vector center, float width, float height) {
        this(center.x, center.y, center.z, width, height, 0.0f);
    }

    public RectangleBounds(Vector lowerLeft, Vector upperRight) {
        float a;
        if (lowerLeft.x > upperRight.x) {
            a = lowerLeft.x;
            lowerLeft.x = upperRight.x;
            upperRight.x = a;
        }
        if (lowerLeft.y > upperRight.y) {
            a = lowerLeft.y;
            lowerLeft.y = upperRight.y;
            upperRight.y = a;
        }
        if (lowerLeft.z > upperRight.z) {
            a = lowerLeft.z;
            lowerLeft.z = upperRight.z;
            upperRight.z = a;
        }
        this.setPosition((upperRight.x - lowerLeft.x) / 2.0f, (upperRight.y - lowerLeft.y) / 2.0f, (upperRight.z - lowerLeft.z) / 2.0f);
        this.box.set(this.position).sub(lowerLeft);
        this.radius = this.box.len();
    }

    public RectangleBounds(Rect rect) {
        this(rect.centerX(), rect.centerY(), rect.width(), rect.height());
    }

    @Override
    public boolean ptInBounds(float x, float y, float z) {
        boolean f = this.ptInBoundsSphere(x, y, z, this.radius);
        if (f) {
            this.w.set(x, y, z).sub(this.position).rotate(this.angle, -1.0f);
            float x1 = this.position.x - this.box.x;
            float x2 = this.position.x + this.box.x;
            float y1 = this.position.y - this.box.y;
            float y2 = this.position.y + this.box.y;
            float z1 = this.position.z - this.box.z;
            float z2 = this.position.z + this.box.z;
            f = this.w.x >= x1 && this.w.x <= x2 && this.w.y >= y1 && this.w.y <= y2 && this.w.z >= z1 && this.w.z <= z2;
        }
        return f;
    }

    public Rect boundsRect() {
        this.boundsRect.set((int)(this.position.x - this.box.x), (int)(this.position.y - this.box.y), (int)(this.position.x + this.box.x), (int)(this.position.y + this.box.y));
        return this.boundsRect;
    }

    public Rect boundsRect(float a) {
        this.boundsRect.set((int)(this.position.x - this.box.x * a), (int)(this.position.y - this.box.y * a), (int)(this.position.x + this.box.x * a), (int)(this.position.y + this.box.y * a));
        return this.boundsRect;
    }
}

