/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.serenegiant.media.MediaEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractRecorder {
    private static final boolean DEBUG = false;
    private static final String TAG = "AbstractRecorder";
    protected final String mOutputPath;
    protected int mEncoderCount;
    protected int mStartedCount;
    protected volatile boolean mIsStarted;
    protected MediaEncoder mVideoEncoder;
    protected MediaEncoder mAudioEncoder;

    public AbstractRecorder(String output_path) {
        this.mOutputPath = output_path;
        this.mStartedCount = 0;
        this.mEncoderCount = 0;
        this.mIsStarted = false;
    }

    public void prepare() throws IOException {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.prepare();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.prepare();
        }
    }

    public void startRecording() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.start();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.start();
        }
    }

    public void stopRecording() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.stop();
        }
        this.mVideoEncoder = null;
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.stop();
        }
        this.mAudioEncoder = null;
    }

    public void release() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.release();
            this.mVideoEncoder = null;
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
        }
    }

    public boolean isStarted() {
        return this.mIsStarted;
    }

    void addEncoder(MediaEncoder encoder) {
        if (encoder.isAudio()) {
            if (this.mAudioEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mAudioEncoder = encoder;
        } else {
            if (this.mVideoEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mVideoEncoder = encoder;
        }
        this.mEncoderCount = (this.mVideoEncoder != null ? 1 : 0) + (this.mAudioEncoder != null ? 1 : 0);
    }

    protected abstract void internal_start();

    synchronized boolean start() {
        ++this.mStartedCount;
        if (this.mEncoderCount > 0 && this.mStartedCount == this.mEncoderCount) {
            this.internal_start();
            this.mIsStarted = true;
            this.notifyAll();
        }
        return this.mIsStarted;
    }

    protected abstract void internal_stop();

    synchronized void stop() {
        --this.mStartedCount;
        if (this.mEncoderCount > 0 && this.mStartedCount <= 0) {
            this.mIsStarted = false;
            this.internal_stop();
        }
    }

    abstract int addTrack(MediaFormat var1);

    abstract void writeSampleData(int var1, ByteBuffer var2, MediaCodec.BufferInfo var3);

    public abstract int getWidth();

    public abstract int getHeight();

    public void frameAvailableSoon() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.frameAvailableSoon();
        }
    }

    public abstract Surface getInputSurface() throws IllegalStateException;

    public String getOutputPath() {
        return this.mOutputPath;
    }
}

