/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.common;

import android.app.Service;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.jiangdg.utils.HandlerThreadHandler;

public abstract class BaseService
extends Service {
    private static boolean DEBUG = false;
    private static final String TAG = BaseService.class.getSimpleName();
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private final Thread mUiThread = this.mUIHandler.getLooper().getThread();
    private Handler mWorkerHandler;
    private long mWorkerThreadID = -1L;

    public void onCreate() {
        super.onCreate();
        if (this.mWorkerHandler == null) {
            this.mWorkerHandler = HandlerThreadHandler.createHandler((String)TAG);
            this.mWorkerThreadID = this.mWorkerHandler.getLooper().getThread().getId();
        }
    }

    public synchronized void onDestroy() {
        if (this.mWorkerHandler != null) {
            try {
                this.mWorkerHandler.getLooper().quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mWorkerHandler = null;
        }
        super.onDestroy();
    }

    public final void runOnUiThread(Runnable task, long duration) {
        if (task == null) {
            return;
        }
        this.mUIHandler.removeCallbacks(task);
        if (duration > 0L || Thread.currentThread() != this.mUiThread) {
            this.mUIHandler.postDelayed(task, duration);
        } else {
            try {
                task.run();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public final void removeFromUiThread(Runnable task) {
        if (task == null) {
            return;
        }
        this.mUIHandler.removeCallbacks(task);
    }

    protected final synchronized void queueEvent(Runnable task, long delayMillis) {
        if (task == null || this.mWorkerHandler == null) {
            return;
        }
        try {
            this.mWorkerHandler.removeCallbacks(task);
            if (delayMillis > 0L) {
                this.mWorkerHandler.postDelayed(task, delayMillis);
            } else if (this.mWorkerThreadID == Thread.currentThread().getId()) {
                task.run();
            } else {
                this.mWorkerHandler.post(task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final synchronized void removeEvent(Runnable task) {
        if (task == null) {
            return;
        }
        try {
            this.mWorkerHandler.removeCallbacks(task);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

