/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jiangdg.ausbc.R;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0004HIJKB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010*\u001a\u00020\fH\u0002J\b\u0010+\u001a\u00020#H\u0002J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0002J\u0010\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\tH\u0002J\b\u00100\u001a\u00020#H\u0014J\u0010\u00101\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u00102\u001a\u00020#2\u0006\u0010-\u001a\u00020\t2\u0006\u0010/\u001a\u00020\tH\u0014J(\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\tH\u0014J\u0010\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020#2\b\u0010<\u001a\u0004\u0018\u00010\u0012J\u000e\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020\tJ\u000e\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020\tJ\u0010\u0010A\u001a\u00020#2\b\u0010B\u001a\u0004\u0018\u00010\u0016J\u0010\u0010C\u001a\u00020#2\b\u0010D\u001a\u0004\u0018\u00010\u0018J\u0010\u0010E\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010F\u001a\u00020#2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010G\u001a\u00020#H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "circleX", "", "circleY", "internalCirclePercent", "", "listener", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$OnViewClickListener;", "mAnimator", "Landroid/animation/ObjectAnimator;", "mCaptureModel", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureMode;", "mCaptureVideoDuration", "mCaptureVideoProgress", "mCaptureVideoState", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureVideoState;", "mCaptureViewTheme", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureViewTheme;", "mFirstDraw", "", "mHeight", "mPaint", "Landroid/graphics/Paint;", "mWidth", "radius", "dp2px", "dpValue", "drawCapturePicture", "", "canvas", "Landroid/graphics/Canvas;", "drawCaptureVideo", "drawCaptureVideoDoingState", "drawCaptureVideoPauseState", "drawCaptureVideoUndoState", "getInternalCirclePercent", "init", "measureHeight", "widthMeasureSpec", "measureWidth", "heightMeasureSpec", "onDetachedFromWindow", "onDraw", "onMeasure", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "setCaptureMode", "model", "setCaptureVideoDuration", "duration", "setCaptureVideoProgress", "progress", "setCaptureVideoState", "state", "setCaptureViewTheme", "theme", "setInternalCirclePercent", "setOnViewClickListener", "showClickAnimation", "CaptureMode", "CaptureVideoState", "CaptureViewTheme", "OnViewClickListener", "libausbc_release"})
public final class CaptureMediaView
extends View {
    @Nullable
    private ObjectAnimator mAnimator;
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int circleX;
    private int circleY;
    private int radius;
    @Nullable
    private CaptureVideoState mCaptureVideoState;
    @Nullable
    private CaptureMode mCaptureModel;
    @Nullable
    private CaptureViewTheme mCaptureViewTheme;
    private int mCaptureVideoDuration;
    private int mCaptureVideoProgress;
    private float internalCirclePercent;
    @Nullable
    private OnViewClickListener listener;
    private boolean mFirstDraw;

    public final void setOnViewClickListener(@Nullable OnViewClickListener listener2) {
        this.listener = listener2;
    }

    public CaptureMediaView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mFirstDraw = true;
        this.init();
    }

    public CaptureMediaView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mFirstDraw = true;
        this.init();
    }

    private final void init() {
        this.mPaint = new Paint();
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setAntiAlias(true);
        this.mCaptureVideoState = CaptureVideoState.UNDO;
        this.mCaptureModel = CaptureMode.MODE_CAPTURE_PIC;
        this.mCaptureViewTheme = CaptureViewTheme.THEME_BLUE;
        this.mCaptureVideoProgress = 0;
        this.internalCirclePercent = 1.0f;
        this.mCaptureVideoDuration = 60;
    }

    public final void setCaptureVideoProgress(int progress) {
        this.mCaptureVideoProgress = progress;
        this.invalidate();
    }

    public final void setCaptureVideoDuration(int duration) {
        this.mCaptureVideoDuration = duration;
    }

    public final void setCaptureMode(@Nullable CaptureMode model) {
        this.mCaptureModel = model;
        this.invalidate();
    }

    public final void setCaptureViewTheme(@Nullable CaptureViewTheme theme) {
        this.mCaptureViewTheme = theme;
    }

    public final void setCaptureVideoState(@Nullable CaptureVideoState state) {
        this.mCaptureVideoState = state;
        this.invalidate();
    }

    private final void setInternalCirclePercent(float internalCirclePercent) {
        this.internalCirclePercent = internalCirclePercent;
        this.invalidate();
    }

    private final float getInternalCirclePercent() {
        return this.internalCirclePercent;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() == 1 && this.listener != null) {
            this.showClickAnimation();
            OnViewClickListener onViewClickListener = this.listener;
            Intrinsics.checkNotNull((Object)onViewClickListener);
            onViewClickListener.onViewClick(this.mCaptureModel);
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private final int measureHeight(int widthMeasureSpec) {
        int measureW = 0;
        int specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (specMode == 0x40000000) {
            measureW = specSize;
        } else {
            measureW = this.dp2px(80.0f);
            if (specMode == Integer.MIN_VALUE) {
                measureW = RangesKt.coerceAtMost((int)measureW, (int)specSize);
            }
        }
        return measureW;
    }

    private final int measureWidth(int heightMeasureSpec) {
        int measureH = 0;
        int specMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (specMode == 0x40000000) {
            measureH = specSize;
        } else {
            measureH = this.dp2px(80.0f);
            if (specMode == Integer.MIN_VALUE) {
                measureH = RangesKt.coerceAtMost((int)measureH, (int)specSize);
            }
        }
        return measureH;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.circleX = this.mWidth / 2;
        this.circleY = this.mHeight / 2;
        this.radius = this.mWidth / 2;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.mCaptureModel == CaptureMode.MODE_CAPTURE_VIDEO || this.mCaptureModel == CaptureMode.MODE_CAPTURE_AUDIO) {
            this.drawCaptureVideo(canvas);
        } else {
            this.drawCapturePicture(canvas);
        }
        if (this.mFirstDraw) {
            this.mFirstDraw = false;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimator != null) {
            ObjectAnimator objectAnimator = this.mAnimator;
            Intrinsics.checkNotNull((Object)objectAnimator);
            if (objectAnimator.isRunning()) {
                ObjectAnimator objectAnimator2 = this.mAnimator;
                Intrinsics.checkNotNull((Object)objectAnimator2);
                objectAnimator2.cancel();
                this.mAnimator = null;
            }
        }
    }

    private final void showClickAnimation() {
        if (this.mCaptureModel == CaptureMode.MODE_CAPTURE_PIC) {
            Object object = new float[]{1.0f, 0.85f, 1.0f};
            this.mAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"internalCirclePercent", (float[])object);
            object = this.mAnimator;
            if (object != null) {
                object.setDuration(150L);
            }
            object = this.mAnimator;
            if (object != null) {
                object.start();
            }
        }
    }

    private final void drawCapturePicture(Canvas canvas) {
        if (this.mCaptureViewTheme == CaptureViewTheme.THEME_BLUE) {
            Paint paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStyle(Paint.Style.FILL);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setColor(-1);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)this.radius, paint);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStyle(Paint.Style.FILL);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStrokeWidth(2.0f);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setColor(Color.parseColor((String)"#2E5BFF"));
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)((double)this.radius - (double)this.radius * 0.2) * this.internalCirclePercent, paint);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStrokeWidth((float)((double)this.radius * 0.1));
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStyle(Paint.Style.STROKE);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setColor(Color.parseColor((String)"#2E5BFF"));
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)((double)this.radius - (double)this.radius * 0.05), paint);
        } else {
            Paint paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStyle(Paint.Style.FILL);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setColor(0);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)this.radius, paint);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStyle(Paint.Style.FILL);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStrokeWidth(2.0f);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setColor(-1);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)((double)this.radius - (double)this.radius * 0.2) * this.internalCirclePercent, paint);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStrokeWidth((float)((double)this.radius * 0.1));
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setStyle(Paint.Style.STROKE);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            paint.setColor(-1);
            paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)((double)this.radius - (double)this.radius * 0.05), paint);
        }
    }

    private final void drawCaptureVideo(Canvas canvas) {
        CaptureVideoState captureVideoState = this.mCaptureVideoState;
        int n = captureVideoState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[captureVideoState.ordinal()];
        switch (n) {
            case 1: {
                this.drawCaptureVideoDoingState(canvas);
                break;
            }
            case 2: {
                this.drawCaptureVideoPauseState(canvas);
                break;
            }
            default: {
                this.drawCaptureVideoUndoState(canvas);
            }
        }
    }

    private final void drawCaptureVideoDoingState(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.FILL);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(this.getResources().getColor(R.color.common_30_black));
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)this.radius, paint);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.FILL);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(-1);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)this.radius * 0.575f, paint);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.FILL);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStrokeWidth(2.0f);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(Color.parseColor((String)"#FF0000"));
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawRoundRect(new RectF((float)((double)this.mWidth * 0.4125), (float)((double)this.mWidth * 0.3875), (float)((double)this.mWidth * 0.4625), (float)((double)this.mWidth * 0.6125)), 8.0f, 8.0f, paint);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawRoundRect(new RectF((float)((double)this.mWidth * 0.5375), (float)((double)this.mWidth * 0.3875), (float)((double)this.mWidth * 0.5875), (float)((double)this.mWidth * 0.6125)), 8.0f, 8.0f, paint);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStrokeWidth((float)((double)this.radius * 0.08));
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.STROKE);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(Color.parseColor((String)"#2E5BFF"));
        RectF rectF = new RectF((float)((double)this.radius * 0.03), (float)((double)this.radius * 0.03), (float)(2 * this.radius) - (float)((double)this.radius * 0.03), (float)(2 * this.radius) - (float)((double)this.radius * 0.03));
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("0.00");
        format.setDecimalFormatSymbols(dfs);
        String result = format.format((float)this.mCaptureVideoProgress / (float)this.mCaptureVideoDuration);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        String string = result;
        boolean bl = false;
        float f = Float.parseFloat(string) * (float)360;
        string = this.mPaint;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawArc(rectF, 270.0f, f, false, (Paint)string);
    }

    private final void drawCaptureVideoPauseState(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.FILL);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(this.getResources().getColor(R.color.common_30_black));
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)this.radius, paint);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.FILL);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(-1);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)this.radius * 0.6f, paint);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStrokeWidth((float)((double)this.radius * 0.08));
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.STROKE);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(Color.parseColor((String)"#2E5BFF"));
        RectF rectF = new RectF((float)((double)this.radius * 0.03), (float)((double)this.radius * 0.03), (float)(2 * this.radius) - (float)((double)this.radius * 0.03), (float)(2 * this.radius) - (float)((double)this.radius * 0.03));
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("0.00");
        format.setDecimalFormatSymbols(dfs);
        String result = format.format((float)this.mCaptureVideoProgress / (float)this.mCaptureVideoDuration);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        String string = result;
        boolean bl = false;
        float f = Float.parseFloat(string) * (float)360;
        string = this.mPaint;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawArc(rectF, 270.0f, f, false, (Paint)string);
    }

    private final void drawCaptureVideoUndoState(Canvas canvas) {
        this.mCaptureVideoProgress = 0;
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.FILL);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(0);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)this.radius, paint);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStrokeWidth(2.0f);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.FILL);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(-1);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        canvas.drawCircle((float)this.circleX, (float)this.circleY, (float)((double)this.radius - (double)this.radius * 0.3), paint);
        canvas.save();
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStrokeWidth((float)this.dp2px(2.0f));
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setStyle(Paint.Style.FILL);
        paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            throw null;
        }
        paint.setColor(-1);
        float startX = (float)this.mWidth / (float)2;
        float startY = this.mHeight / 2 - this.radius;
        int count = 30;
        int n = 0;
        do {
            int i = n++;
            Paint paint2 = this.mPaint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                throw null;
            }
            canvas.drawLine(startX, startY, startX, startY + (float)10, paint2);
            canvas.rotate(360.0f / (float)count, (float)this.getWidth() / (float)2, (float)this.getHeight() / (float)2);
        } while (n < count);
        canvas.restore();
    }

    private final int dp2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureVideoState;", "", "(Ljava/lang/String;I)V", "DOING", "UNDO", "PAUSE", "libausbc_release"})
    public static final class CaptureVideoState
    extends Enum<CaptureVideoState> {
        public static final /* enum */ CaptureVideoState DOING = new CaptureVideoState();
        public static final /* enum */ CaptureVideoState UNDO = new CaptureVideoState();
        public static final /* enum */ CaptureVideoState PAUSE = new CaptureVideoState();
        private static final /* synthetic */ CaptureVideoState[] $VALUES;

        public static CaptureVideoState[] values() {
            return (CaptureVideoState[])$VALUES.clone();
        }

        public static CaptureVideoState valueOf(String value) {
            return Enum.valueOf(CaptureVideoState.class, value);
        }

        static {
            $VALUES = captureVideoStateArray = new CaptureVideoState[]{CaptureVideoState.DOING, CaptureVideoState.UNDO, CaptureVideoState.PAUSE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureMode;", "", "(Ljava/lang/String;I)V", "MODE_CAPTURE_PIC", "MODE_CAPTURE_VIDEO", "MODE_CAPTURE_AUDIO", "libausbc_release"})
    public static final class CaptureMode
    extends Enum<CaptureMode> {
        public static final /* enum */ CaptureMode MODE_CAPTURE_PIC = new CaptureMode();
        public static final /* enum */ CaptureMode MODE_CAPTURE_VIDEO = new CaptureMode();
        public static final /* enum */ CaptureMode MODE_CAPTURE_AUDIO = new CaptureMode();
        private static final /* synthetic */ CaptureMode[] $VALUES;

        public static CaptureMode[] values() {
            return (CaptureMode[])$VALUES.clone();
        }

        public static CaptureMode valueOf(String value) {
            return Enum.valueOf(CaptureMode.class, value);
        }

        static {
            $VALUES = captureModeArray = new CaptureMode[]{CaptureMode.MODE_CAPTURE_PIC, CaptureMode.MODE_CAPTURE_VIDEO, CaptureMode.MODE_CAPTURE_AUDIO};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureViewTheme;", "", "(Ljava/lang/String;I)V", "THEME_BLUE", "THEME_WHITE", "libausbc_release"})
    public static final class CaptureViewTheme
    extends Enum<CaptureViewTheme> {
        public static final /* enum */ CaptureViewTheme THEME_BLUE = new CaptureViewTheme();
        public static final /* enum */ CaptureViewTheme THEME_WHITE = new CaptureViewTheme();
        private static final /* synthetic */ CaptureViewTheme[] $VALUES;

        public static CaptureViewTheme[] values() {
            return (CaptureViewTheme[])$VALUES.clone();
        }

        public static CaptureViewTheme valueOf(String value) {
            return Enum.valueOf(CaptureViewTheme.class, value);
        }

        static {
            $VALUES = captureViewThemeArray = new CaptureViewTheme[]{CaptureViewTheme.THEME_BLUE, CaptureViewTheme.THEME_WHITE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView$OnViewClickListener;", "", "onViewClick", "", "mode", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureMode;", "libausbc_release"})
    public static interface OnViewClickListener {
        public void onViewClick(@Nullable CaptureMode var1);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CaptureVideoState.values().length];
            nArray[CaptureVideoState.DOING.ordinal()] = 1;
            nArray[CaptureVideoState.PAUSE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

