/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.location.Location;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.provider.MediaStore;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.jiangdg.ausbc.MultiCameraClient;
import com.jiangdg.ausbc.callback.ICameraStateCallBack;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IDeviceConnectCallBack;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.encode.AACEncodeProcessor;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.encode.H264EncodeProcessor;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.encode.muxer.Mp4Muxer;
import com.jiangdg.ausbc.utils.CameraUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.MediaUtils;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.natives.YUVUtils;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UVCCamera;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0014\u001a\u00020\u0010J \u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0010J\u0014\u0010 \u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010!\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\"\u001a\u00020\u0010R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jiangdg/ausbc/MultiCameraClient;", "", "ctx", "Landroid/content/Context;", "callback", "Lcom/jiangdg/ausbc/callback/IDeviceConnectCallBack;", "(Landroid/content/Context;Lcom/jiangdg/ausbc/callback/IDeviceConnectCallBack;)V", "mMainHandler", "Landroid/os/Handler;", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "Lkotlin/Lazy;", "mUsbMonitor", "Lcom/serenegiant/usb/USBMonitor;", "addDeviceFilters", "", "list", "", "Lcom/serenegiant/usb/DeviceFilter;", "destroy", "getDeviceList", "", "Landroid/hardware/usb/UsbDevice;", "hasPermission", "", "device", "(Landroid/hardware/usb/UsbDevice;)Ljava/lang/Boolean;", "isMonitorRegistered", "openDebug", "debug", "register", "removeDeviceFilters", "requestPermission", "unRegister", "Camera", "Companion", "libausbc_release"})
public final class MultiCameraClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private USBMonitor mUsbMonitor;
    @NotNull
    private final Lazy mMainHandler$delegate;
    @NotNull
    private static final String TAG = "MultiCameraClient";
    private static final int MIN_FS = 10;
    private static final int MAX_FS = 60;
    private static final int MSG_START_PREVIEW = 1;
    private static final int MSG_STOP_PREVIEW = 2;
    private static final int MSG_CAPTURE_IMAGE = 3;
    private static final int MSG_CAPTURE_VIDEO_START = 4;
    private static final int MSG_CAPTURE_VIDEO_STOP = 5;
    private static final int MSG_SEND_COMMAND = 6;
    private static final int DEFAULT_PREVIEW_WIDTH = 640;
    private static final int DEFAULT_PREVIEW_HEIGHT = 480;
    private static final int MAX_NV21_DATA = 5;
    private static final long CAPTURE_TIMES_OUT_SEC = 3L;

    public MultiCameraClient(final @NotNull Context ctx, final @Nullable IDeviceConnectCallBack callback) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.mMainHandler$delegate = LazyKt.lazy((Function0)mMainHandler.2.INSTANCE);
        this.mUsbMonitor = new USBMonitor(ctx, new USBMonitor.OnDeviceConnectListener(){

            public void onAttach(@Nullable UsbDevice device) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"attach device = ", (Object)(usbDevice == null ? null : usbDevice.toString())));
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onAttach$lambda-0(callback, device));
            }

            public void onDetach(@Nullable UsbDevice device) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"onDetach device = ", (Object)(usbDevice == null ? null : usbDevice.toString())));
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onDetach$lambda-1(callback, device));
            }

            public void onConnect(@Nullable UsbDevice device, @Nullable USBMonitor.UsbControlBlock ctrlBlock, boolean createNew) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"onConnect device = ", (Object)(usbDevice == null ? null : usbDevice.toString())));
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onConnect$lambda-2(callback, device, ctrlBlock));
            }

            public void onDisconnect(@Nullable UsbDevice device, @Nullable USBMonitor.UsbControlBlock ctrlBlock) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"onDisconnect device = ", (Object)(usbDevice == null ? null : usbDevice.toString())));
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onDisconnect$lambda-3(callback, device, ctrlBlock));
            }

            public void onCancel(@Nullable UsbDevice device) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"onCancel device = ", (Object)(usbDevice == null ? null : usbDevice.toString())));
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onCancel$lambda-4(callback, device));
            }

            private static final void onAttach$lambda-0(IDeviceConnectCallBack $callback, UsbDevice $device) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onAttachDev($device);
                }
            }

            private static final void onDetach$lambda-1(IDeviceConnectCallBack $callback, UsbDevice $device) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onDetachDec($device);
                }
            }

            private static final void onConnect$lambda-2(IDeviceConnectCallBack $callback, UsbDevice $device, USBMonitor.UsbControlBlock $ctrlBlock) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onConnectDev($device, $ctrlBlock);
                }
            }

            private static final void onDisconnect$lambda-3(IDeviceConnectCallBack $callback, UsbDevice $device, USBMonitor.UsbControlBlock $ctrlBlock) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onDisConnectDec($device, $ctrlBlock);
                }
            }

            private static final void onCancel$lambda-4(IDeviceConnectCallBack $callback, UsbDevice $device) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onCancelDev($device);
                }
            }
        });
    }

    private final Handler getMMainHandler() {
        Lazy lazy = this.mMainHandler$delegate;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    public final void register() {
        if (this.isMonitorRegistered()) {
            return;
        }
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.register();
        }
    }

    public final void unRegister() {
        if (!this.isMonitorRegistered()) {
            return;
        }
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.unregister();
        }
    }

    public final boolean requestPermission(@Nullable UsbDevice device) {
        if (!this.isMonitorRegistered()) {
            Logger.INSTANCE.w(TAG, "Usb monitor haven't been registered.");
            return false;
        }
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.requestPermission(device);
        }
        return true;
    }

    @Nullable
    public final Boolean hasPermission(@Nullable UsbDevice device) {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        return uSBMonitor == null ? null : Boolean.valueOf(uSBMonitor.hasPermission(device));
    }

    @Nullable
    public final List<UsbDevice> getDeviceList(@Nullable List<DeviceFilter> list) {
        USBMonitor uSBMonitor = list;
        if (uSBMonitor != null) {
            USBMonitor uSBMonitor2 = uSBMonitor;
            boolean bl = false;
            boolean bl2 = false;
            USBMonitor it = uSBMonitor2;
            boolean bl3 = false;
            this.addDeviceFilters((List<DeviceFilter>)it);
        }
        uSBMonitor = this.mUsbMonitor;
        return uSBMonitor == null ? null : uSBMonitor.getDeviceList();
    }

    public static /* synthetic */ List getDeviceList$default(MultiCameraClient multiCameraClient, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return multiCameraClient.getDeviceList(list);
    }

    public final void addDeviceFilters(@NotNull List<DeviceFilter> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.addDeviceFilter(list);
        }
    }

    public final void removeDeviceFilters(@NotNull List<DeviceFilter> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.removeDeviceFilter(list);
        }
    }

    public final void destroy() {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.destroy();
        }
    }

    public final void openDebug(boolean debug) {
        Utils.INSTANCE.setDebugCamera(debug);
        USBMonitor.DEBUG = debug;
        UVCCamera.DEBUG = debug;
    }

    private final boolean isMonitorRegistered() {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        return uSBMonitor == null ? false : uSBMonitor.isRegistered();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020%J\u000e\u0010A\u001a\u00020?2\u0006\u0010@\u001a\u000203J\u001a\u0010B\u001a\u00020?2\u0006\u0010@\u001a\u00020C2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010E\u001a\u00020?2\b\u0010F\u001a\u0004\u0018\u00010\u000e2\u0006\u0010G\u001a\u00020CH\u0002J$\u0010H\u001a\u00020?2\u0006\u0010@\u001a\u00020C2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010I\u001a\u00020JJ\"\u0010K\u001a\u00020?2\b\u0010D\u001a\u0004\u0018\u00010\u000e2\u0006\u0010I\u001a\u00020J2\u0006\u0010@\u001a\u00020CH\u0002J\u0006\u0010L\u001a\u00020?J\b\u0010M\u001a\u00020?H\u0002J\u0006\u0010N\u001a\u00020?J\b\u0010O\u001a\u00020?H\u0002J\u001d\u0010P\u001a\b\u0012\u0004\u0012\u0002050Q2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010S\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u0004\u0018\u00010\u0016J\b\u0010V\u001a\u00020\u0016H\u0002J\u0018\u0010W\u001a\u0002052\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020YH\u0002J\u0006\u0010[\u001a\u00020\u0005J\u0010\u0010\\\u001a\u00020\n2\u0006\u0010]\u001a\u00020^H\u0016J\u0018\u0010_\u001a\u00020?2\u0006\u0010`\u001a\u00020Y2\u0006\u0010a\u001a\u00020YH\u0002J\u0006\u0010b\u001a\u00020\nJ\u0010\u0010c\u001a\u00020\n2\u0006\u0010d\u001a\u000205H\u0002J\u0006\u0010e\u001a\u00020\nJ\u001e\u0010f\u001a\u00020?2\n\b\u0002\u0010g\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010\u0016J#\u0010i\u001a\u00020?\"\u0004\b\u0000\u0010j2\u0006\u0010g\u001a\u0002Hj2\u0006\u0010k\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010lJ\b\u0010m\u001a\u00020?H\u0002J\u000e\u0010n\u001a\u00020?2\u0006\u0010o\u001a\u00020YJ\u0010\u0010p\u001a\u00020?2\u0006\u0010o\u001a\u00020YH\u0002J\u000e\u0010q\u001a\u00020?2\u0006\u0010G\u001a\u00020\u0018J\u0010\u0010r\u001a\u00020?2\b\u0010s\u001a\u0004\u0018\u00010\u001eJ\u0016\u0010t\u001a\u00020?2\u0006\u0010u\u001a\u00020Y2\u0006\u0010v\u001a\u00020YR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0012\u001a\u0004\b!\u0010\"R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010&\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0012\u001a\u0004\b'\u0010(R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0012\u001a\u0004\b/\u00100R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00106\u001a\u0002078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u0012\u001a\u0004\b8\u00109R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/jiangdg/ausbc/MultiCameraClient$Camera;", "Landroid/os/Handler$Callback;", "ctx", "Landroid/content/Context;", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/content/Context;Landroid/hardware/usb/UsbDevice;)V", "frameCallBack", "Lcom/serenegiant/usb/IFrameCallback;", "isPreviewed", "", "mAudioProcess", "Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "mCameraDir", "", "getMCameraDir", "()Ljava/lang/String;", "mCameraDir$delegate", "Lkotlin/Lazy;", "mCameraHandler", "Landroid/os/Handler;", "mCameraRequest", "Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "mCameraStateCallback", "Lcom/jiangdg/ausbc/callback/ICameraStateCallBack;", "mCameraThread", "Landroid/os/HandlerThread;", "mCameraView", "", "mCtrlBlock", "Lcom/serenegiant/usb/USBMonitor$UsbControlBlock;", "mDateFormat", "Ljava/text/SimpleDateFormat;", "getMDateFormat", "()Ljava/text/SimpleDateFormat;", "mDateFormat$delegate", "mEncodeDataCallBack", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack;", "mMainHandler", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "mMediaMuxer", "Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer;", "mNV21DataQueue", "Ljava/util/concurrent/LinkedBlockingDeque;", "", "getMNV21DataQueue", "()Ljava/util/concurrent/LinkedBlockingDeque;", "mNV21DataQueue$delegate", "mPreviewCallback", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack;", "mPreviewSize", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "mSaveImageExecutor", "Ljava/util/concurrent/ExecutorService;", "getMSaveImageExecutor", "()Ljava/util/concurrent/ExecutorService;", "mSaveImageExecutor$delegate", "mUvcCamera", "Lcom/serenegiant/usb/UVCCamera;", "mVideoProcess", "addEncodeDataCallBack", "", "callBack", "addPreviewDataCallBack", "captureImage", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "path", "captureImageInternal", "savePath", "callback", "captureVideoStart", "durationInSec", "", "captureVideoStartInternal", "captureVideoStop", "captureVideoStopInternal", "closeCamera", "closeCameraInternal", "getAllPreviewSizes", "", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getCameraRequest", "getDefaultCameraRequest", "getSuitableSize", "maxWidth", "", "maxHeight", "getUsbDevice", "handleMessage", "msg", "Landroid/os/Message;", "initEncodeProcessor", "previewWidth", "previewHeight", "isCameraOpened", "isPreviewSizeSupported", "previewSize", "isRecordVideo", "openCamera", "cameraView", "cameraRequest", "openCameraInternal", "T", "request", "(Ljava/lang/Object;Lcom/jiangdg/ausbc/camera/bean/CameraRequest;)V", "releaseEncodeProcessor", "sendCameraCommand", "command", "sendCameraCommandInternal", "setCameraStateCallBack", "setUsbControlBlock", "ctrlBlock", "updateResolution", "width", "height", "libausbc_release"})
    public static final class Camera
    implements Handler.Callback {
        @NotNull
        private final Context ctx;
        @NotNull
        private final UsbDevice device;
        @Nullable
        private ICameraStateCallBack mCameraStateCallback;
        @Nullable
        private Mp4Muxer mMediaMuxer;
        @Nullable
        private Object mCameraView;
        @Nullable
        private CameraRequest mCameraRequest;
        @Nullable
        private PreviewSize mPreviewSize;
        private boolean isPreviewed;
        @Nullable
        private HandlerThread mCameraThread;
        @Nullable
        private Handler mCameraHandler;
        @Nullable
        private UVCCamera mUvcCamera;
        @Nullable
        private IPreviewDataCallBack mPreviewCallback;
        @Nullable
        private IEncodeDataCallBack mEncodeDataCallBack;
        @Nullable
        private AbstractProcessor mAudioProcess;
        @Nullable
        private AbstractProcessor mVideoProcess;
        @Nullable
        private USBMonitor.UsbControlBlock mCtrlBlock;
        @NotNull
        private final Lazy mMainHandler$delegate;
        @NotNull
        private final Lazy mSaveImageExecutor$delegate;
        @NotNull
        private final Lazy mNV21DataQueue$delegate;
        @NotNull
        private final Lazy mDateFormat$delegate;
        @NotNull
        private final Lazy mCameraDir$delegate;
        @NotNull
        private final IFrameCallback frameCallBack;

        public Camera(@NotNull Context ctx, @NotNull UsbDevice device) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            this.ctx = ctx;
            this.device = device;
            this.mMainHandler$delegate = LazyKt.lazy((Function0)mMainHandler.2.INSTANCE);
            this.mSaveImageExecutor$delegate = LazyKt.lazy((Function0)mSaveImageExecutor.2.INSTANCE);
            this.mNV21DataQueue$delegate = LazyKt.lazy((Function0)mNV21DataQueue.2.INSTANCE);
            this.mDateFormat$delegate = LazyKt.lazy((Function0)mDateFormat.2.INSTANCE);
            this.mCameraDir$delegate = LazyKt.lazy((Function0)mCameraDir.2.INSTANCE);
            this.frameCallBack = arg_0 -> Camera.frameCallBack$lambda-2(this, arg_0);
        }

        private final Handler getMMainHandler() {
            Lazy lazy = this.mMainHandler$delegate;
            boolean bl = false;
            return (Handler)lazy.getValue();
        }

        private final ExecutorService getMSaveImageExecutor() {
            Lazy lazy = this.mSaveImageExecutor$delegate;
            boolean bl = false;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-mSaveImageExecutor>(...)");
            return (ExecutorService)object;
        }

        private final LinkedBlockingDeque<byte[]> getMNV21DataQueue() {
            Lazy lazy = this.mNV21DataQueue$delegate;
            boolean bl = false;
            return (LinkedBlockingDeque)lazy.getValue();
        }

        private final SimpleDateFormat getMDateFormat() {
            Lazy lazy = this.mDateFormat$delegate;
            boolean bl = false;
            return (SimpleDateFormat)lazy.getValue();
        }

        private final String getMCameraDir() {
            Lazy lazy = this.mCameraDir$delegate;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        public boolean handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            int n = msg.what;
            switch (n) {
                case 1: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                    }
                    object = (Pair)object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object $this$handleMessage_u24lambda_u2d3 = object;
                    boolean bl3 = false;
                    Object object2 = $this$handleMessage_u24lambda_u2d3.getSecond();
                    CameraRequest cameraRequest = object2 instanceof CameraRequest ? (CameraRequest)object2 : null;
                    this.openCameraInternal($this$handleMessage_u24lambda_u2d3.getFirst(), cameraRequest == null ? this.getDefaultCameraRequest() : cameraRequest);
                    break;
                }
                case 2: {
                    this.closeCameraInternal();
                    break;
                }
                case 3: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                    }
                    object = (Pair)object;
                    boolean bl = false;
                    boolean bl4 = false;
                    Object $this$handleMessage_u24lambda_u2d4 = object;
                    boolean bl5 = false;
                    Object object3 = $this$handleMessage_u24lambda_u2d4.getFirst();
                    String string = object3 instanceof String ? (String)object3 : null;
                    object3 = $this$handleMessage_u24lambda_u2d4.getSecond();
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jiangdg.ausbc.callback.ICaptureCallBack");
                    }
                    this.captureImageInternal(string, (ICaptureCallBack)object3);
                    break;
                }
                case 6: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    this.sendCameraCommandInternal((Integer)object);
                    break;
                }
                case 4: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Triple<*, *, *>");
                    }
                    object = (Triple)object;
                    boolean bl = false;
                    boolean bl6 = false;
                    Object $this$handleMessage_u24lambda_u2d5 = object;
                    boolean bl7 = false;
                    Object object4 = $this$handleMessage_u24lambda_u2d5.getFirst();
                    String string = object4 instanceof String ? (String)object4 : null;
                    object4 = $this$handleMessage_u24lambda_u2d5.getSecond();
                    if (object4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                    long l = (Long)object4;
                    object4 = $this$handleMessage_u24lambda_u2d5.getThird();
                    if (object4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jiangdg.ausbc.callback.ICaptureCallBack");
                    }
                    this.captureVideoStartInternal(string, l, (ICaptureCallBack)object4);
                    break;
                }
                case 5: {
                    this.captureVideoStopInternal();
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final <T> void openCameraInternal(T cameraView, CameraRequest request) {
            UVCCamera uVCCamera;
            Object object;
            if (Utils.INSTANCE.isTargetSdkOverP(this.ctx) && !CameraUtils.INSTANCE.hasCameraPermission(this.ctx)) {
                this.closeCamera();
                this.getMMainHandler().post(() -> Camera.openCameraInternal$lambda-6(this));
                Logger.INSTANCE.e(MultiCameraClient.TAG, "open camera failed, need Manifest.permission.CAMERA permission when targetSdk>=28");
                return;
            }
            if (this.mCtrlBlock == null) {
                this.closeCamera();
                this.getMMainHandler().post(() -> Camera.openCameraInternal$lambda-7(this));
                return;
            }
            try {
                void $this$openCameraInternal_u24lambda_u2d8;
                object = new UVCCamera();
                boolean bl = false;
                boolean bl2 = false;
                UVCCamera uVCCamera2 = object;
                Camera camera = this;
                boolean bl3 = false;
                $this$openCameraInternal_u24lambda_u2d8.open(this.mCtrlBlock);
                Unit unit = Unit.INSTANCE;
                camera.mUvcCamera = object;
            }
            catch (Exception e) {
                this.getMMainHandler().post(() -> Camera.openCameraInternal$lambda-9(this, e));
                Logger.INSTANCE.e(MultiCameraClient.TAG, "open camera failed.", e);
                this.closeCamera();
            }
            try {
                PreviewSize previewSize = this.getSuitableSize(request.getPreviewWidth(), request.getPreviewHeight());
                if (!this.isPreviewSizeSupported(previewSize)) {
                    this.getMMainHandler().post(() -> Camera.openCameraInternal$lambda-10(this));
                    this.closeCamera();
                    UVCCamera uVCCamera3 = this.mUvcCamera;
                    Logger.INSTANCE.e(MultiCameraClient.TAG, "open camera failed, preview size(" + previewSize + ") unsupported-> " + (uVCCamera3 == null ? null : uVCCamera3.getSupportedSizeList()));
                    return;
                }
                this.initEncodeProcessor(previewSize.getWidth(), previewSize.getHeight());
                this.mPreviewSize = previewSize;
                uVCCamera = this.mUvcCamera;
                if (uVCCamera != null) {
                    uVCCamera.setPreviewSize(previewSize.getWidth(), previewSize.getHeight(), 10, 60, 1, 1.0f);
                }
            }
            catch (Exception e) {
                try {
                    PreviewSize previewSize = this.getSuitableSize(request.getPreviewWidth(), request.getPreviewHeight());
                    if (!this.isPreviewSizeSupported(previewSize)) {
                        this.getMMainHandler().post(() -> Camera.openCameraInternal$lambda-11(this));
                        this.closeCamera();
                        UVCCamera uVCCamera4 = this.mUvcCamera;
                        Logger.INSTANCE.e(MultiCameraClient.TAG, "open camera failed, preview size(" + previewSize + ") unsupported-> " + (uVCCamera4 == null ? null : uVCCamera4.getSupportedSizeList()));
                        return;
                    }
                    Logger.INSTANCE.e(MultiCameraClient.TAG, " setPreviewSize failed, try to use yuv format...");
                    UVCCamera uVCCamera5 = this.mUvcCamera;
                    if (uVCCamera5 != null) {
                        PreviewSize previewSize2 = this.mPreviewSize;
                        Intrinsics.checkNotNull((Object)previewSize2);
                        int n = previewSize2.getWidth();
                        PreviewSize previewSize3 = this.mPreviewSize;
                        Intrinsics.checkNotNull((Object)previewSize3);
                        uVCCamera5.setPreviewSize(n, previewSize3.getHeight(), 10, 60, 0, 1.0f);
                    }
                }
                catch (Exception e2) {
                    this.getMMainHandler().post(() -> Camera.openCameraInternal$lambda-12(this, e2));
                    this.closeCamera();
                    Logger.INSTANCE.e(MultiCameraClient.TAG, " setPreviewSize failed, even using yuv format", e2);
                    return;
                }
            }
            object = this.mUvcCamera;
            if (object != null) {
                object.setFrameCallback(this.frameCallBack, 4);
            }
            object = cameraView;
            if (object instanceof Surface) {
                uVCCamera = this.mUvcCamera;
                if (uVCCamera != null) {
                    uVCCamera.setPreviewDisplay((Surface)cameraView);
                }
            } else if (object instanceof SurfaceTexture) {
                uVCCamera = this.mUvcCamera;
                if (uVCCamera != null) {
                    uVCCamera.setPreviewTexture((SurfaceTexture)cameraView);
                }
            } else if (object instanceof SurfaceView) {
                uVCCamera = this.mUvcCamera;
                if (uVCCamera != null) {
                    uVCCamera.setPreviewDisplay(((SurfaceView)cameraView).getHolder());
                }
            } else if (object instanceof TextureView) {
                uVCCamera = this.mUvcCamera;
                if (uVCCamera != null) {
                    uVCCamera.setPreviewTexture(((TextureView)cameraView).getSurfaceTexture());
                }
            } else {
                throw new IllegalStateException("Only support Surface or SurfaceTexture or SurfaceView or TextureView or GLSurfaceView");
            }
            object = this.mUvcCamera;
            if (object != null) {
                object.setAutoFocus(true);
            }
            object = this.mUvcCamera;
            if (object != null) {
                object.setAutoWhiteBlance(true);
            }
            object = this.mUvcCamera;
            if (object != null) {
                object.startPreview();
            }
            object = this.mUvcCamera;
            if (object != null) {
                object.updateCameraParams();
            }
            this.isPreviewed = true;
            this.getMMainHandler().post(() -> Camera.openCameraInternal$lambda-13(this));
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(MultiCameraClient.TAG, " start preview, name = " + this.device.getDeviceName() + ", preview=" + this.mPreviewSize);
            }
        }

        private final void closeCameraInternal() {
            this.isPreviewed = false;
            this.releaseEncodeProcessor();
            UVCCamera uVCCamera = this.mUvcCamera;
            if (uVCCamera != null) {
                uVCCamera.destroy();
            }
            this.mUvcCamera = null;
            this.getMMainHandler().post(() -> Camera.closeCameraInternal$lambda-14(this));
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(MultiCameraClient.TAG, " stop preview, name = " + this.device.getDeviceName() + ", preview=" + this.mPreviewSize);
            }
        }

        private final void captureImageInternal(String savePath, ICaptureCallBack callback) {
            this.getMSaveImageExecutor().submit(() -> Camera.captureImageInternal$lambda-21(this, savePath, callback));
        }

        private final void sendCameraCommandInternal(int command) {
            UVCCamera uVCCamera = this.mUvcCamera;
            if (uVCCamera != null) {
                uVCCamera.sendCommand(command);
            }
        }

        private final void captureVideoStartInternal(String path, long durationInSec, ICaptureCallBack callBack) {
            boolean bl;
            boolean bl2;
            AbstractProcessor abstractProcessor;
            if (!CameraUtils.INSTANCE.hasStoragePermission(this.ctx) || !CameraUtils.INSTANCE.hasAudioPermission(this.ctx)) {
                this.getMMainHandler().post(() -> Camera.captureVideoStartInternal$lambda-22(callBack));
                Logger.INSTANCE.e(MultiCameraClient.TAG, "open camera failed, have no storage and audio permission");
                return;
            }
            this.mMediaMuxer = new Mp4Muxer(this.ctx, callBack, path, durationInSec);
            AbstractProcessor abstractProcessor2 = this.mVideoProcess;
            H264EncodeProcessor h264EncodeProcessor = abstractProcessor = abstractProcessor2 instanceof H264EncodeProcessor ? (H264EncodeProcessor)abstractProcessor2 : null;
            if (abstractProcessor != null) {
                abstractProcessor2 = abstractProcessor;
                bl2 = false;
                bl = false;
                AbstractProcessor $this$captureVideoStartInternal_u24lambda_u2d23 = abstractProcessor2;
                boolean bl3 = false;
                $this$captureVideoStartInternal_u24lambda_u2d23.startEncode();
                Mp4Muxer mp4Muxer = this.mMediaMuxer;
                Intrinsics.checkNotNull((Object)mp4Muxer);
                $this$captureVideoStartInternal_u24lambda_u2d23.setMp4Muxer(mp4Muxer, true);
                $this$captureVideoStartInternal_u24lambda_u2d23.addEncodeDataCallBack(this.mEncodeDataCallBack);
            }
            abstractProcessor2 = this.mAudioProcess;
            AbstractProcessor abstractProcessor3 = abstractProcessor = abstractProcessor2 instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor2 : null;
            if (abstractProcessor != null) {
                abstractProcessor2 = abstractProcessor;
                bl2 = false;
                bl = false;
                AbstractProcessor $this$captureVideoStartInternal_u24lambda_u2d24 = abstractProcessor2;
                boolean bl4 = false;
                $this$captureVideoStartInternal_u24lambda_u2d24.startEncode();
                Mp4Muxer mp4Muxer = this.mMediaMuxer;
                Intrinsics.checkNotNull((Object)mp4Muxer);
                $this$captureVideoStartInternal_u24lambda_u2d24.setMp4Muxer(mp4Muxer, false);
                $this$captureVideoStartInternal_u24lambda_u2d24.addEncodeDataCallBack(this.mEncodeDataCallBack);
            }
        }

        private final void captureVideoStopInternal() {
            Object object = this.mMediaMuxer;
            if (object != null) {
                ((Mp4Muxer)object).release();
            }
            object = this.mVideoProcess;
            if (object != null) {
                ((AbstractProcessor)object).stopEncode();
            }
            object = this.mAudioProcess;
            if (object != null) {
                ((AbstractProcessor)object).stopEncode();
            }
            this.mMediaMuxer = null;
        }

        public final void setUsbControlBlock(@Nullable USBMonitor.UsbControlBlock ctrlBlock) {
            this.mCtrlBlock = ctrlBlock;
        }

        public final void setCameraStateCallBack(@NotNull ICameraStateCallBack callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.mCameraStateCallback = callback;
        }

        public final void openCamera(@Nullable Object cameraView, @Nullable CameraRequest cameraRequest) {
            Message message;
            CameraRequest cameraRequest2;
            Object object = cameraView;
            this.mCameraView = object == null ? this.mCameraView : object;
            object = cameraRequest;
            this.mCameraRequest = object == null ? ((cameraRequest2 = this.mCameraRequest) == null ? this.getDefaultCameraRequest() : cameraRequest2) : object;
            cameraRequest2 = new HandlerThread(this.device.getDeviceName() + '-' + this.device.getDeviceId());
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest $this$openCamera_u24lambda_u2d25 = cameraRequest2;
            boolean bl3 = false;
            $this$openCamera_u24lambda_u2d25.start();
            bl = false;
            bl2 = false;
            CameraRequest it = cameraRequest2;
            boolean bl4 = false;
            Handler handler = this.mCameraHandler = new Handler(it.getLooper(), (Handler.Callback)this);
            if (handler != null && (message = handler.obtainMessage(1, (Object)new Pair(cameraView, (Object)cameraRequest))) != null) {
                message.sendToTarget();
            }
            CameraRequest thread = cameraRequest2;
            this.mCameraThread = thread;
        }

        public static /* synthetic */ void openCamera$default(Camera camera, Object object, CameraRequest cameraRequest, int n, Object object2) {
            if ((n & 1) != 0) {
                object = null;
            }
            if ((n & 2) != 0) {
                cameraRequest = null;
            }
            camera.openCamera(object, cameraRequest);
        }

        public final void closeCamera() {
            Message message;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(2)) != null) {
                message.sendToTarget();
            }
            if ((handler = this.mCameraThread) != null) {
                handler.quitSafely();
            }
            this.mCameraThread = null;
            this.mCameraHandler = null;
        }

        public final boolean isCameraOpened() {
            return this.isPreviewed;
        }

        @Nullable
        public final CameraRequest getCameraRequest() {
            return this.mCameraRequest;
        }

        public final void captureImage(@NotNull ICaptureCallBack callBack, @Nullable String path) {
            Message message;
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            Pair pair = new Pair((Object)path, (Object)callBack);
            boolean bl = false;
            boolean bl2 = false;
            Pair $this$captureImage_u24lambda_u2d27 = pair;
            boolean bl3 = false;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(3, (Object)$this$captureImage_u24lambda_u2d27)) != null) {
                message.sendToTarget();
            }
        }

        public static /* synthetic */ void captureImage$default(Camera camera, ICaptureCallBack iCaptureCallBack, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            camera.captureImage(iCaptureCallBack, string);
        }

        public final void captureVideoStart(@NotNull ICaptureCallBack callBack, @Nullable String path, long durationInSec) {
            Message message;
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            Triple triple = new Triple((Object)path, (Object)durationInSec, (Object)callBack);
            boolean bl = false;
            boolean bl2 = false;
            Triple $this$captureVideoStart_u24lambda_u2d28 = triple;
            boolean bl3 = false;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(4, (Object)$this$captureVideoStart_u24lambda_u2d28)) != null) {
                message.sendToTarget();
            }
        }

        public static /* synthetic */ void captureVideoStart$default(Camera camera, ICaptureCallBack iCaptureCallBack, String string, long l, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                l = 0L;
            }
            camera.captureVideoStart(iCaptureCallBack, string, l);
        }

        public final void captureVideoStop() {
            Message message;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(5)) != null) {
                message.sendToTarget();
            }
        }

        public final void sendCameraCommand(int command) {
            Message message;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(6, (Object)command)) != null) {
                message.sendToTarget();
            }
        }

        public final void updateResolution(int width, int height) {
            if (this.mCameraRequest == null) {
                Logger.INSTANCE.w(MultiCameraClient.TAG, "updateResolution failed, please open camera first.");
                return;
            }
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor == null ? false : abstractProcessor.isEncoding()) {
                Logger.INSTANCE.e(MultiCameraClient.TAG, "updateResolution failed, video recording...");
                return;
            }
            this.closeCamera();
            this.getMMainHandler().postDelayed(() -> Camera.updateResolution$lambda-29(this, width, height), 100L);
        }

        public final boolean isRecordVideo() {
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            return abstractProcessor == null ? false : abstractProcessor.isEncoding();
        }

        public final void addEncodeDataCallBack(@NotNull IEncodeDataCallBack callBack) {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            this.mEncodeDataCallBack = callBack;
        }

        public final void addPreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            this.mPreviewCallback = callBack;
        }

        @NotNull
        public final UsbDevice getUsbDevice() {
            return this.device;
        }

        @NotNull
        public final List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
            boolean bl;
            boolean bl2 = false;
            ArrayList<PreviewSize> previewSizeList = new ArrayList<PreviewSize>();
            Object object = this.mUvcCamera;
            if (object == null) {
                bl = false;
            } else {
                List list = object.getSupportedSizeList();
                if (list == null) {
                    bl = false;
                } else {
                    Collection collection = list;
                    boolean bl3 = false;
                    bl = !collection.isEmpty();
                }
            }
            object = bl ? ((object = this.mUvcCamera) == null ? null : object.getSupportedSizeList()) : ((object = this.mUvcCamera) == null ? null : object.getSupportedSizeList(0));
            boolean bl4 = false;
            boolean bl5 = false;
            Object sizeList = object;
            boolean bl6 = false;
            Object object2 = sizeList;
            if (object2 != null) {
                Iterable $this$forEach$iv = (Iterable)object2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Size size = (Size)element$iv;
                    boolean bl7 = false;
                    int width = size.width;
                    int height = size.height;
                    double ratio = (double)width / (double)height;
                    if (aspectRatio != null && !Intrinsics.areEqual((Double)aspectRatio, (double)ratio)) continue;
                    previewSizeList.add(new PreviewSize(width, height));
                }
            }
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(MultiCameraClient.TAG, "aspect ratio = " + aspectRatio + ", getAllPreviewSizes = " + previewSizeList + ", ");
            }
            return previewSizeList;
        }

        public static /* synthetic */ List getAllPreviewSizes$default(Camera camera, Double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = null;
            }
            return camera.getAllPreviewSizes(d);
        }

        private final void initEncodeProcessor(int previewWidth, int previewHeight) {
            this.releaseEncodeProcessor();
            this.mAudioProcess = new AACEncodeProcessor();
            this.mVideoProcess = new H264EncodeProcessor(previewWidth, previewHeight, false);
        }

        private final void releaseEncodeProcessor() {
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor != null) {
                abstractProcessor.stopEncode();
            }
            abstractProcessor = this.mAudioProcess;
            if (abstractProcessor != null) {
                abstractProcessor.stopEncode();
            }
            this.mVideoProcess = null;
            this.mAudioProcess = null;
        }

        private final PreviewSize getSuitableSize(int maxWidth, int maxHeight) {
            PreviewSize previewSize;
            Iterable iterable;
            boolean bl;
            PreviewSize it;
            List sizeList;
            block7: {
                Object v0;
                Object object2;
                boolean bl2;
                Iterable iterable2;
                block6: {
                    sizeList = Camera.getAllPreviewSizes$default(this, null, 1, null);
                    iterable2 = sizeList;
                    bl2 = false;
                    boolean bl3 = false;
                    if (iterable2 == null || iterable2.isEmpty()) {
                        return new PreviewSize(640, 480);
                    }
                    iterable2 = sizeList;
                    bl2 = false;
                    Iterable iterable3 = iterable2;
                    boolean bl4 = false;
                    for (Object object2 : iterable3) {
                        it = (PreviewSize)object2;
                        boolean bl5 = false;
                        if (!(it.getWidth() == maxWidth && it.getHeight() == maxHeight)) continue;
                        v0 = object2;
                        break block6;
                    }
                    v0 = null;
                }
                iterable2 = v0;
                bl2 = false;
                bl = false;
                Object size = (PreviewSize)((Object)iterable2);
                boolean bl6 = false;
                object2 = size;
                if (object2 != null) {
                    return size;
                }
                float aspectRatio = (float)maxWidth / (float)maxHeight;
                iterable = sizeList;
                bl = false;
                size = iterable;
                bl6 = false;
                object2 = size.iterator();
                while (object2.hasNext()) {
                    int h;
                    PreviewSize it2 = it = object2.next();
                    boolean bl7 = false;
                    int w = it2.getWidth();
                    float ratio = (float)w / (float)(h = it2.getHeight());
                    if (!(ratio == aspectRatio && w <= maxWidth && h <= maxHeight)) continue;
                    previewSize = it;
                    break block7;
                }
                previewSize = null;
            }
            iterable = previewSize;
            bl = false;
            boolean size = false;
            PreviewSize size2 = (PreviewSize)((Object)iterable);
            boolean bl8 = false;
            it = size2;
            if (it != null) {
                return size2;
            }
            int minDistance = 0;
            minDistance = maxWidth;
            PreviewSize closetSize = null;
            closetSize = (PreviewSize)sizeList.get(0);
            Iterable $this$forEach$iv = sizeList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreviewSize size3 = (PreviewSize)element$iv;
                boolean bl9 = false;
                int n = maxWidth - size3.getWidth();
                boolean bl10 = false;
                if (minDistance < Math.abs(n)) continue;
                n = maxWidth - size3.getWidth();
                bl10 = false;
                minDistance = Math.abs(n);
                closetSize = size3;
            }
            return closetSize;
        }

        private final boolean isPreviewSizeSupported(PreviewSize previewSize) {
            Object v0;
            block1: {
                Iterable iterable = Camera.getAllPreviewSizes$default(this, null, 1, null);
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    PreviewSize it = (PreviewSize)t;
                    boolean bl3 = false;
                    if (!(it.getWidth() == previewSize.getWidth() && it.getHeight() == previewSize.getHeight())) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        private final CameraRequest getDefaultCameraRequest() {
            return new CameraRequest.Builder().setPreviewWidth(640).setPreviewHeight(480).create();
        }

        private static final void frameCallBack$lambda-2(Camera this$0, ByteBuffer frame) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ByteBuffer byteBuffer = frame;
            if (byteBuffer != null) {
                ByteBuffer byteBuffer2 = byteBuffer;
                boolean bl = false;
                boolean bl2 = false;
                ByteBuffer $this$frameCallBack_u24lambda_u2d2_u24lambda_u2d1 = byteBuffer2;
                boolean bl3 = false;
                byte[] data = new byte[$this$frameCallBack_u24lambda_u2d2_u24lambda_u2d1.capacity()];
                $this$frameCallBack_u24lambda_u2d2_u24lambda_u2d1.get(data);
                Object object = this$0.mPreviewCallback;
                if (object != null) {
                    object.onPreviewData(data, IPreviewDataCallBack.DataFormat.NV21);
                }
                if (this$0.getMNV21DataQueue().size() >= 5) {
                    this$0.getMNV21DataQueue().removeLast();
                }
                this$0.getMNV21DataQueue().offerFirst(data);
                object = this$0.mPreviewSize;
                if (object != null) {
                    Object object2 = object;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object $this$frameCallBack_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0 = object2;
                    boolean bl6 = false;
                    if (data.length != ((PreviewSize)$this$frameCallBack_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0).getWidth() * ((PreviewSize)$this$frameCallBack_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0).getHeight() * 3 / 2) {
                        return;
                    }
                    YUVUtils.INSTANCE.nv21ToYuv420sp(data, ((PreviewSize)$this$frameCallBack_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0).getWidth(), ((PreviewSize)$this$frameCallBack_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0).getHeight());
                    AbstractProcessor abstractProcessor = this$0.mVideoProcess;
                    if (abstractProcessor != null) {
                        abstractProcessor.putRawData(new RawData(data, data.length));
                    }
                }
            }
        }

        private static final void openCameraInternal$lambda-6(Camera this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                iCameraStateCallBack.onCameraState(this$0, ICameraStateCallBack.State.ERROR, "Has no CAMERA permission.");
            }
        }

        private static final void openCameraInternal$lambda-7(Camera this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                iCameraStateCallBack.onCameraState(this$0, ICameraStateCallBack.State.ERROR, "Usb control block can not be null ");
            }
        }

        private static final void openCameraInternal$lambda-9(Camera this$0, Exception $e) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                iCameraStateCallBack.onCameraState(this$0, ICameraStateCallBack.State.ERROR, Intrinsics.stringPlus((String)"open camera failed ", (Object)$e.getLocalizedMessage()));
            }
        }

        private static final void openCameraInternal$lambda-10(Camera this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                iCameraStateCallBack.onCameraState(this$0, ICameraStateCallBack.State.ERROR, "unsupported preview size");
            }
        }

        private static final void openCameraInternal$lambda-11(Camera this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                iCameraStateCallBack.onCameraState(this$0, ICameraStateCallBack.State.ERROR, "unsupported preview size");
            }
        }

        private static final void openCameraInternal$lambda-12(Camera this$0, Exception $e) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                iCameraStateCallBack.onCameraState(this$0, ICameraStateCallBack.State.ERROR, $e.getLocalizedMessage());
            }
        }

        private static final void openCameraInternal$lambda-13(Camera this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                ICameraStateCallBack.DefaultImpls.onCameraState$default(iCameraStateCallBack, this$0, ICameraStateCallBack.State.OPENED, null, 4, null);
            }
        }

        private static final void closeCameraInternal$lambda-14(Camera this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                ICameraStateCallBack.DefaultImpls.onCameraState$default(iCameraStateCallBack, this$0, ICameraStateCallBack.State.CLOSED, null, 4, null);
            }
        }

        private static final void captureImageInternal$lambda-21$lambda-15(ICaptureCallBack $callback) {
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            $callback.onError("have no storage permission");
        }

        private static final void captureImageInternal$lambda-21$lambda-16(ICaptureCallBack $callback) {
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            $callback.onError("camera not previewing");
        }

        private static final void captureImageInternal$lambda-21$lambda-17(ICaptureCallBack $callback) {
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            $callback.onError("Times out");
        }

        private static final void captureImageInternal$lambda-21$lambda-18(ICaptureCallBack $callback) {
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            $callback.onBegin();
        }

        private static final void captureImageInternal$lambda-21$lambda-19(ICaptureCallBack $callback) {
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            $callback.onError("save yuv to jpeg failed.");
        }

        private static final void captureImageInternal$lambda-21$lambda-20(ICaptureCallBack $callback, String $path) {
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
            $callback.onComplete($path);
        }

        private static final void captureImageInternal$lambda-21(Camera this$0, String $savePath, ICaptureCallBack $callback) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            if (!CameraUtils.INSTANCE.hasStoragePermission(this$0.ctx)) {
                this$0.getMMainHandler().post(() -> Camera.captureImageInternal$lambda-21$lambda-15($callback));
                Logger.INSTANCE.e(MultiCameraClient.TAG, "open camera failed, have no storage permission");
                return;
            }
            if (!this$0.isPreviewed || this$0.mPreviewSize == null) {
                this$0.getMMainHandler().post(() -> Camera.captureImageInternal$lambda-21$lambda-16($callback));
                Logger.INSTANCE.i(MultiCameraClient.TAG, "captureImageInternal failed, camera not previewing");
                return;
            }
            byte[] data = this$0.getMNV21DataQueue().pollFirst(3L, TimeUnit.SECONDS);
            if (data == null) {
                this$0.getMMainHandler().post(() -> Camera.captureImageInternal$lambda-21$lambda-17($callback));
                Logger.INSTANCE.i(MultiCameraClient.TAG, "captureImageInternal failed, times out.");
                return;
            }
            this$0.getMMainHandler().post(() -> Camera.captureImageInternal$lambda-21$lambda-18($callback));
            String date = this$0.getMDateFormat().format(System.currentTimeMillis());
            String string = $savePath;
            String title = string == null ? Intrinsics.stringPlus((String)"IMG_AUSBC_", (Object)date) : string;
            String string2 = $savePath;
            String displayName = string2 == null ? Intrinsics.stringPlus((String)title, (Object)".jpg") : string2;
            String string3 = $savePath;
            String path = string3 == null ? this$0.getMCameraDir() + '/' + displayName : string3;
            Location location = Utils.INSTANCE.getGpsLocation(this$0.ctx);
            PreviewSize previewSize = this$0.mPreviewSize;
            Intrinsics.checkNotNull((Object)previewSize);
            int width = previewSize.getWidth();
            PreviewSize previewSize2 = this$0.mPreviewSize;
            Intrinsics.checkNotNull((Object)previewSize2);
            int height = previewSize2.getHeight();
            YUVUtils.INSTANCE.yuv420spToNv21(data, width, height);
            boolean ret = MediaUtils.INSTANCE.saveYuv2Jpeg(path, data, width, height);
            if (!ret) {
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                }
                this$0.getMMainHandler().post(() -> Camera.captureImageInternal$lambda-21$lambda-19($callback));
                Logger.INSTANCE.w(MultiCameraClient.TAG, "save yuv to jpeg failed.");
                return;
            }
            ContentValues values = new ContentValues();
            values.put("title", title);
            values.put("_display_name", displayName);
            values.put("_data", path);
            values.put("datetaken", date);
            Location location2 = location;
            values.put("longitude", location2 == null ? null : Double.valueOf(location2.getLongitude()));
            location2 = location;
            values.put("latitude", location2 == null ? null : Double.valueOf(location2.getLatitude()));
            location2 = this$0.ctx.getContentResolver();
            if (location2 != null) {
                location2.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
            }
            this$0.getMMainHandler().post(() -> Camera.captureImageInternal$lambda-21$lambda-20($callback, path));
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"captureImageInternal save path = ", (Object)path));
            }
        }

        private static final void captureVideoStartInternal$lambda-22(ICaptureCallBack $callBack) {
            Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
            $callBack.onError("have no storage or audio permission");
        }

        private static final void updateResolution$lambda-29(Camera this$0, int $width, int $height) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            CameraRequest cameraRequest = this$0.mCameraRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            cameraRequest.setPreviewWidth($width);
            CameraRequest cameraRequest2 = this$0.mCameraRequest;
            Intrinsics.checkNotNull((Object)cameraRequest2);
            cameraRequest2.setPreviewHeight($height);
            Camera.openCamera$default(this$0, null, null, 3, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jiangdg/ausbc/MultiCameraClient$Companion;", "", "()V", "CAPTURE_TIMES_OUT_SEC", "", "DEFAULT_PREVIEW_HEIGHT", "", "DEFAULT_PREVIEW_WIDTH", "MAX_FS", "MAX_NV21_DATA", "MIN_FS", "MSG_CAPTURE_IMAGE", "MSG_CAPTURE_VIDEO_START", "MSG_CAPTURE_VIDEO_STOP", "MSG_SEND_COMMAND", "MSG_START_PREVIEW", "MSG_STOP_PREVIEW", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

