/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.camera;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.location.Location;
import android.os.Build;
import android.provider.MediaStore;
import android.view.SurfaceHolder;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IDeviceConnectCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.CameraUvcStrategy;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraInfo;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.CameraUvcInfo;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.utils.CameraUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.MediaUtils;
import com.jiangdg.ausbc.utils.SettableFuture;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.usb.DeviceFilter;
import com.jiangdg.usb.USBMonitor;
import com.jiangdg.utils.Size;
import com.jiangdg.uvc.IFrameCallback;
import com.jiangdg.uvc.UVCCamera;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b<\u0018\u0000 i2\u00020\u0001:\u0001iB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u000f\u0010&\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016\u00a2\u0006\u0002\u0010,J\r\u0010-\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/J\r\u00100\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/J\b\u00101\u001a\u0004\u0018\u00010\tJ\r\u00102\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/J\r\u00103\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/J\r\u00104\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/J\r\u00105\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/J\r\u00106\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/J\b\u00107\u001a\u0004\u0018\u00010\u000eJ\u001f\u00108\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\n\b\u0002\u00109\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\r\u0010<\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/J\u0006\u0010=\u001a\u00020\fJ\u0018\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020.2\u0006\u0010@\u001a\u00020.H\u0002J\b\u0010A\u001a\u00020#H\u0014J\u0010\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020\tH\u0002J\u000f\u0010D\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010'J\b\u0010E\u001a\u00020#H\u0016J\u0012\u0010F\u001a\u00020#2\b\u0010G\u001a\u0004\u0018\u00010\tH\u0002J\u0015\u0010H\u001a\u0004\u0018\u00010.2\u0006\u0010I\u001a\u00020.\u00a2\u0006\u0002\u0010JJ\u000e\u0010K\u001a\u00020#2\u0006\u0010L\u001a\u00020\fJ\u000e\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020\fJ\u000e\u0010O\u001a\u00020#2\u0006\u0010P\u001a\u00020.J\u000e\u0010Q\u001a\u00020#2\u0006\u0010R\u001a\u00020.J\u000e\u0010S\u001a\u00020#2\u0006\u0010T\u001a\u00020\u0010J\u000e\u0010U\u001a\u00020#2\u0006\u0010V\u001a\u00020.J\u000e\u0010W\u001a\u00020#2\u0006\u0010X\u001a\u00020.J\u000e\u0010Y\u001a\u00020#2\u0006\u0010Z\u001a\u00020.J\u000e\u0010[\u001a\u00020#2\u0006\u0010\\\u001a\u00020.J\u000e\u0010]\u001a\u00020#2\u0006\u0010^\u001a\u00020.J\u000e\u0010_\u001a\u00020#2\u0006\u0010`\u001a\u00020.J\b\u0010a\u001a\u00020#H\u0014J\b\u0010b\u001a\u00020#H\u0014J\u0012\u0010c\u001a\u00020#2\b\u0010d\u001a\u0004\u0018\u00010%H\u0014J\b\u0010e\u001a\u00020#H\u0016J\u0018\u0010f\u001a\u00020#2\u0006\u0010g\u001a\u00020.2\u0006\u0010h\u001a\u00020.H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/jiangdg/ausbc/camera/CameraUvcStrategy;", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "frameCallBack", "Lcom/jiangdg/uvc/IFrameCallback;", "mCacheDeviceList", "", "Landroid/hardware/usb/UsbDevice;", "mConnectSettableFuture", "Lcom/jiangdg/ausbc/utils/SettableFuture;", "", "mCtrlBlockSettableFuture", "Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;", "mDevConnectCallBack", "Lcom/jiangdg/ausbc/callback/IDeviceConnectCallBack;", "mDevSettableFuture", "mNV21DataQueue", "Ljava/util/concurrent/LinkedBlockingDeque;", "", "getMNV21DataQueue", "()Ljava/util/concurrent/LinkedBlockingDeque;", "mNV21DataQueue$delegate", "Lkotlin/Lazy;", "mRequestPermission", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMRequestPermission", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mRequestPermission$delegate", "mUVCCamera", "Lcom/jiangdg/uvc/UVCCamera;", "mUsbMonitor", "Lcom/jiangdg/usb/USBMonitor;", "captureImageInternal", "", "savePath", "", "createCamera", "()Ljava/lang/Boolean;", "getAllPreviewSizes", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getBrightness", "", "()Ljava/lang/Integer;", "getContrast", "getCurrentDevice", "getGain", "getGamma", "getHue", "getSaturation", "getSharpness", "getUsbControlBlock", "getUsbDeviceList", "resId", "(Ljava/lang/Integer;)Ljava/util/List;", "getUsbDeviceListInternal", "getZoom", "isMicSupported", "isPreviewSizeSupported", "previewWidth", "previewHeight", "loadCameraInfo", "loadCameraInfoInternal", "dev", "realStartPreview", "register", "requestCameraPermission", "device", "sendCameraCommand", "command", "(I)Ljava/lang/Integer;", "setAutoFocus", "enable", "setAutoWhiteBalance", "autoWhiteBalance", "setBrightness", "brightness", "setContrast", "contrast", "setDeviceConnectStatusListener", "cb", "setGain", "gain", "setGamma", "gamma", "setHue", "hue", "setSaturation", "saturation", "setSharpness", "sharpness", "setZoom", "zoom", "startPreviewInternal", "stopPreviewInternal", "switchCameraInternal", "cameraId", "unRegister", "updateResolutionInternal", "width", "height", "Companion", "libausbc_release"})
public final class CameraUvcStrategy
extends ICameraStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SettableFuture<UsbDevice> mDevSettableFuture;
    @Nullable
    private SettableFuture<USBMonitor.UsbControlBlock> mCtrlBlockSettableFuture;
    @NotNull
    private final SettableFuture<Boolean> mConnectSettableFuture;
    @NotNull
    private final Lazy mNV21DataQueue$delegate;
    @NotNull
    private final Lazy mRequestPermission$delegate;
    @Nullable
    private USBMonitor mUsbMonitor;
    @Nullable
    private UVCCamera mUVCCamera;
    @Nullable
    private IDeviceConnectCallBack mDevConnectCallBack;
    @NotNull
    private List<UsbDevice> mCacheDeviceList;
    @NotNull
    private final IFrameCallback frameCallBack;
    @NotNull
    private static final String TAG = "CameraUvc";
    private static final int MIN_FS = 10;
    private static final int MAX_FS = 60;
    private static final int MAX_NV21_DATA = 5;
    private static final long CAPTURE_TIMES_OUT_SEC = 1L;

    public CameraUvcStrategy(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
        this.mConnectSettableFuture = new SettableFuture();
        this.mNV21DataQueue$delegate = LazyKt.lazy((Function0)mNV21DataQueue.2.INSTANCE);
        this.mRequestPermission$delegate = LazyKt.lazy((Function0)mRequestPermission.2.INSTANCE);
        boolean bl = false;
        this.mCacheDeviceList = new ArrayList();
        this.register();
        this.frameCallBack = arg_0 -> CameraUvcStrategy.frameCallBack$lambda-35(this, arg_0);
    }

    private final LinkedBlockingDeque<byte[]> getMNV21DataQueue() {
        Lazy lazy = this.mNV21DataQueue$delegate;
        boolean bl = false;
        return (LinkedBlockingDeque)lazy.getValue();
    }

    private final AtomicBoolean getMRequestPermission() {
        Lazy lazy = this.mRequestPermission$delegate;
        boolean bl = false;
        return (AtomicBoolean)lazy.getValue();
    }

    @Override
    protected void loadCameraInfo() {
        try {
            List<UsbDevice> devList = this.getUsbDeviceListInternal();
            Collection collection = devList;
            boolean bl = false;
            boolean bl2 = false;
            if (collection == null || collection.isEmpty()) {
                String emptyTip = "Find no uvc devices, if you want some special device please use getUsbDeviceList() or add device info into default_device_filter.xml";
                this.postCameraStatus(new CameraStatus(-1, emptyTip));
                Logger.INSTANCE.e(TAG, emptyTip);
                return;
            }
            Iterable $this$forEach$iv = devList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UsbDevice dev = (UsbDevice)element$iv;
                boolean bl3 = false;
                this.loadCameraInfoInternal(dev);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)" Find no uvc devices, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    private final void loadCameraInfoInternal(UsbDevice dev) {
        if (this.getMCameraInfoMap().containsKey(dev.getDeviceId())) {
            return;
        }
        Object object = new CameraUvcInfo(String.valueOf(dev.getDeviceId()));
        boolean bl = false;
        boolean bl2 = false;
        CameraUvcInfo $this$loadCameraInfoInternal_u24lambda_u2d1 = object;
        boolean bl3 = false;
        $this$loadCameraInfoInternal_u24lambda_u2d1.setCameraVid(dev.getVendorId());
        $this$loadCameraInfoInternal_u24lambda_u2d1.setCameraPid(dev.getProductId());
        String string = dev.getDeviceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dev.deviceName");
        $this$loadCameraInfoInternal_u24lambda_u2d1.setCameraName(string);
        $this$loadCameraInfoInternal_u24lambda_u2d1.setCameraProtocol(dev.getDeviceProtocol());
        $this$loadCameraInfoInternal_u24lambda_u2d1.setCameraClass(dev.getDeviceClass());
        $this$loadCameraInfoInternal_u24lambda_u2d1.setCameraSubClass(dev.getDeviceSubclass());
        if (Build.VERSION.SDK_INT >= 21) {
            $this$loadCameraInfoInternal_u24lambda_u2d1.setCameraProductName(dev.getProductName());
            $this$loadCameraInfoInternal_u24lambda_u2d1.setCameraManufacturerName(dev.getManufacturerName());
        }
        CameraUvcInfo cameraInfo = object;
        object = this.getMCameraInfoMap();
        Integer n = dev.getDeviceId();
        bl2 = false;
        object.put(n, cameraInfo);
    }

    @Override
    protected void startPreviewInternal() {
        try {
            this.createCamera();
            this.realStartPreview();
        }
        catch (Exception e) {
            this.stopPreview();
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)" preview failed, err = ", (Object)e.getLocalizedMessage()), e);
            this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean createCamera() {
        SettableFuture<USBMonitor.UsbControlBlock> settableFuture = this.mCtrlBlockSettableFuture;
        USBMonitor.UsbControlBlock ctrlBlock = settableFuture == null ? null : settableFuture.get();
        Object object = this.mDevSettableFuture;
        UsbDevice device = object == null ? null : ((SettableFuture)object).get();
        if ((object = device) == null) {
            return null;
        }
        object = ctrlBlock;
        if (object == null) {
            return null;
        }
        object = this.getRequest();
        if (object != null) {
            void $this$createCamera_u24lambda_u2d3_u24lambda_u2d2;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object request = object2;
            boolean bl3 = false;
            int previewWidth = ((CameraRequest)request).getPreviewWidth();
            int previewHeight = ((CameraRequest)request).getPreviewHeight();
            ((CameraRequest)request).setCameraId(String.valueOf(device.getDeviceId()));
            UVCCamera uVCCamera = new UVCCamera();
            boolean bl4 = false;
            boolean bl5 = false;
            UVCCamera uVCCamera2 = uVCCamera;
            CameraUvcStrategy cameraUvcStrategy = this;
            boolean bl6 = false;
            $this$createCamera_u24lambda_u2d3_u24lambda_u2d2.open(ctrlBlock);
            Unit unit = Unit.INSTANCE;
            cameraUvcStrategy.mUVCCamera = uVCCamera;
            if (!this.isPreviewSizeSupported(previewWidth, previewHeight)) {
                this.postCameraStatus(new CameraStatus(-2, "unsupported preview size(" + ((CameraRequest)request).getPreviewWidth() + ", " + ((CameraRequest)request).getPreviewHeight() + ')'));
                Logger.INSTANCE.e(TAG, " unsupported preview size(" + ((CameraRequest)request).getPreviewWidth() + ", " + ((CameraRequest)request).getPreviewHeight() + ')');
                return null;
            }
            try {
                uVCCamera = this.mUVCCamera;
                if (uVCCamera != null) {
                    uVCCamera.setPreviewSize(((CameraRequest)request).getPreviewWidth(), ((CameraRequest)request).getPreviewHeight(), 10, 60, 1, 1.0f);
                }
            }
            catch (Exception e) {
                try {
                    Logger.INSTANCE.w(TAG, " setPreviewSize failed " + e.getLocalizedMessage() + ", try yuv format...");
                    if (!this.isPreviewSizeSupported(previewWidth, previewHeight)) {
                        this.postCameraStatus(new CameraStatus(-2, "unsupported preview size(" + ((CameraRequest)request).getPreviewWidth() + ", " + ((CameraRequest)request).getPreviewHeight() + ')'));
                        Logger.INSTANCE.e(TAG, " unsupported preview size(" + ((CameraRequest)request).getPreviewWidth() + ", " + ((CameraRequest)request).getPreviewHeight() + ')');
                        return null;
                    }
                    UVCCamera uVCCamera3 = this.mUVCCamera;
                    if (uVCCamera3 != null) {
                        uVCCamera3.setPreviewSize(((CameraRequest)request).getPreviewWidth(), ((CameraRequest)request).getPreviewHeight(), 10, 60, 0, 1.0f);
                    }
                }
                catch (Exception e2) {
                    this.postCameraStatus(new CameraStatus(-1, Intrinsics.stringPlus((String)"setPreviewSize failed, err = ", (Object)e2.getLocalizedMessage())));
                    Logger.INSTANCE.e(TAG, " setPreviewSize failed", e2);
                    return null;
                }
            }
            uVCCamera = this.mUVCCamera;
            if (uVCCamera != null) {
                uVCCamera.setFrameCallback(this.frameCallBack, 4);
            }
            Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)" createCamera success! request = ", (Object)request));
        }
        return true;
    }

    private final boolean isPreviewSizeSupported(int previewWidth, int previewHeight) {
        PreviewSize previewSize;
        List list = ICameraStrategy.getAllPreviewSizes$default(this, null, 1, null);
        if (list == null) {
            previewSize = null;
        } else {
            Object v1;
            block3: {
                Iterable iterable = list;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    PreviewSize it = (PreviewSize)t;
                    boolean bl3 = false;
                    if (!(it.getWidth() == previewWidth && it.getHeight() == previewHeight)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            previewSize = v1;
        }
        return previewSize != null;
    }

    private final Boolean realStartPreview() {
        try {
            boolean bl;
            boolean bl2;
            Object object;
            Object object2;
            SurfaceTexture st = this.getSurfaceTexture();
            SurfaceHolder holder = this.getSurfaceHolder();
            if (st == null && holder == null) {
                this.postCameraStatus(new CameraStatus(-1, "surface is null"));
                Logger.INSTANCE.e(TAG, " SurfaceTexture or SurfaceHolder cannot be null.");
                return null;
            }
            if (st != null) {
                object2 = this.mUVCCamera;
                if (object2 != null) {
                    object2.setPreviewTexture(st);
                }
            } else {
                object2 = this.mUVCCamera;
                if (object2 != null) {
                    object2.setPreviewDisplay(holder);
                }
            }
            object2 = this.mUVCCamera;
            if (object2 != null) {
                object2.setAutoFocus(true);
            }
            object2 = this.mUVCCamera;
            if (object2 != null) {
                object2.setAutoWhiteBlance(true);
            }
            object2 = this.mUVCCamera;
            if (object2 != null) {
                object2.startPreview();
            }
            object2 = this.mUVCCamera;
            if (object2 != null) {
                object2.updateCameraParams();
            }
            this.getMIsPreviewing().set(true);
            object2 = this.getRequest();
            if (object2 != null) {
                object = object2;
                bl2 = false;
                bl = false;
                Object $this$realStartPreview_u24lambda_u2d5 = object;
                boolean bl3 = false;
                this.postCameraStatus(new CameraStatus(1, new Pair((Object)((CameraRequest)$this$realStartPreview_u24lambda_u2d5).getPreviewWidth(), (Object)((CameraRequest)$this$realStartPreview_u24lambda_u2d5).getPreviewHeight()).toString()));
            }
            object = this.mDevSettableFuture;
            object = object == null ? null : (UsbDevice)((SettableFuture)object).get();
            bl2 = false;
            bl = false;
            Object $this$realStartPreview_u24lambda_u2d6 = object;
            boolean bl4 = false;
            IDeviceConnectCallBack iDeviceConnectCallBack = this.mDevConnectCallBack;
            if (iDeviceConnectCallBack != null) {
                IDeviceConnectCallBack.DefaultImpls.onConnectDev$default(iDeviceConnectCallBack, (UsbDevice)$this$realStartPreview_u24lambda_u2d6, null, 2, null);
            }
            Object dev = object;
            if (Utils.INSTANCE.getDebugCamera()) {
                object = dev;
                Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)" start preview success!!!, id(", (Object)(object == null ? null : object.getDeviceName())));
            }
        }
        catch (Exception e) {
            this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)" startPreview failed. err = ", (Object)e.getLocalizedMessage()), e);
            return null;
        }
        return true;
    }

    @Override
    protected void stopPreviewInternal() {
        if (Utils.INSTANCE.getDebugCamera() && this.getMIsPreviewing().get()) {
            Logger.INSTANCE.i(TAG, "stopPreviewInternal");
        }
        this.getMRequestPermission().set(false);
        this.getMIsPreviewing().set(false);
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.stopPreview();
        }
        uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.destroy();
        }
        this.mUVCCamera = null;
        this.postCameraStatus(new CameraStatus(2, null, 2, null));
    }

    @Override
    protected void captureImageInternal(@Nullable String savePath) {
        if (!this.hasCameraPermission() || !this.hasStoragePermission()) {
            this.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda-7(this));
            Logger.INSTANCE.i(TAG, "captureImageInternal failed, has no storage/camera permission.");
            return;
        }
        if (this.getMIsCapturing().get()) {
            return;
        }
        this.getMSaveImageExecutor().submit(() -> CameraUvcStrategy.captureImageInternal$lambda-12(this, savePath));
    }

    @Override
    protected void switchCameraInternal(@Nullable String cameraId) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest it = cameraRequest2;
            boolean bl3 = false;
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"switchCameraInternal, camera id = ", (Object)cameraId));
            }
            Object object = cameraId;
            boolean bl4 = false;
            boolean bl5 = false;
            if (object == null || object.length() == 0) {
                Logger.INSTANCE.e(TAG, "camera id invalid.");
            } else {
                String string;
                object = this.getCurrentDevice();
                if (object == null) {
                    string = null;
                } else {
                    Integer n = object.getDeviceId();
                    string = n.toString();
                }
                if (Intrinsics.areEqual(string, (Object)cameraId)) {
                    Logger.INSTANCE.e(TAG, "camera was already opened.");
                } else {
                    UsbDevice usbDevice;
                    object = CameraUvcStrategy.getUsbDeviceList$default(this, null, 1, null);
                    if (object == null) {
                        usbDevice = null;
                    } else {
                        Object v2;
                        block14: {
                            Iterable iterable = (Iterable)object;
                            bl5 = false;
                            Iterable iterable2 = iterable;
                            boolean bl6 = false;
                            for (Object t : iterable2) {
                                UsbDevice it2 = (UsbDevice)t;
                                boolean bl7 = false;
                                if (!Intrinsics.areEqual((Object)cameraId, (Object)String.valueOf(it2.getDeviceId()))) continue;
                                v2 = t;
                                break block14;
                            }
                            v2 = null;
                        }
                        usbDevice = v2;
                    }
                    object = usbDevice;
                    bl4 = false;
                    bl5 = false;
                    Object dev = object;
                    boolean bl8 = false;
                    if (dev == null) {
                        Logger.INSTANCE.e(TAG, "switch camera(: " + cameraId + ") failed, not found.");
                    } else {
                        if (!this.mCacheDeviceList.contains(dev)) {
                            this.mCacheDeviceList.add((UsbDevice)dev);
                        }
                        this.stopPreviewInternal();
                        this.requestCameraPermission((UsbDevice)dev);
                    }
                }
            }
        }
    }

    @Override
    protected void updateResolutionInternal(int width, int height) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest request = cameraRequest2;
            boolean bl3 = false;
            request.setPreviewWidth(width);
            request.setPreviewHeight(height);
            this.stopPreviewInternal();
            this.startPreviewInternal();
        }
    }

    @Override
    @Nullable
    public List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            List<PreviewSize> list;
            List previewSizeList;
            List list2;
            Object object;
            CameraInfo cameraInfo;
            boolean bl;
            Object object2;
            block16: {
                CameraRequest cameraRequest2 = cameraRequest;
                boolean bl2 = false;
                boolean bl3 = false;
                CameraRequest request = cameraRequest2;
                boolean bl4 = false;
                Iterable<CameraInfo> iterable = this.getMCameraInfoMap().values();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"mCameraInfoMap.values");
                iterable = iterable;
                boolean bl5 = false;
                object2 = iterable;
                bl = false;
                Iterator<CameraInfo> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    CameraInfo cameraInfo2;
                    CameraInfo it = cameraInfo2 = iterator.next();
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)request.getCameraId(), (Object)it.getCameraId())) continue;
                    cameraInfo = cameraInfo2;
                    break block16;
                }
                cameraInfo = null;
            }
            CameraInfo cameraInfo3 = cameraInfo;
            object2 = cameraInfo3;
            Object object3 = object = object2 == null ? null : ((CameraInfo)object2).getCameraPreviewSizes();
            if (object == null) {
                boolean bl7 = false;
                list2 = new ArrayList();
            } else {
                list2 = previewSizeList = object;
            }
            if (previewSizeList.isEmpty()) {
                boolean bl8;
                object = this.mUVCCamera;
                Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"getAllPreviewSizes = ", (Object)(object == null ? null : object.getSupportedSizeList())));
                object = this.mUVCCamera;
                if (object == null) {
                    bl8 = false;
                } else {
                    List list3 = object.getSupportedSizeList();
                    if (list3 == null) {
                        bl8 = false;
                    } else {
                        Collection collection = list3;
                        boolean bl9 = false;
                        bl8 = !collection.isEmpty();
                    }
                }
                object = bl8 ? ((object = this.mUVCCamera) == null ? null : object.getSupportedSizeList()) : ((object = this.mUVCCamera) == null ? null : object.getSupportedSizeList(0));
                boolean bl10 = false;
                bl = false;
                Object sizeList = object;
                boolean bl11 = false;
                Object object4 = sizeList;
                if (object4 != null) {
                    Iterable $this$forEach$iv = (Iterable)object4;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Object v4;
                        boolean bl12;
                        Iterable iterable;
                        Size size;
                        block17: {
                            size = (Size)element$iv;
                            boolean bl13 = false;
                            iterable = previewSizeList;
                            bl12 = false;
                            Iterable iterable2 = iterable;
                            boolean bl14 = false;
                            for (Object t : iterable2) {
                                PreviewSize it = (PreviewSize)t;
                                boolean bl15 = false;
                                if (!(it.getWidth() == size.width && it.getHeight() == size.height)) continue;
                                v4 = t;
                                break block17;
                            }
                            v4 = null;
                        }
                        iterable = v4;
                        bl12 = false;
                        boolean bl16 = false;
                        PreviewSize it = (PreviewSize)((Object)iterable);
                        boolean bl17 = false;
                        if (it != null) continue;
                        previewSizeList.add(new PreviewSize(size.width, size.height));
                    }
                }
                object4 = cameraInfo3;
                if (object4 != null) {
                    ((CameraInfo)object4).setCameraPreviewSizes(previewSizeList);
                }
            }
            if ((object = aspectRatio) == null) {
                return previewSizeList;
            }
            ((Double)object).doubleValue();
            boolean bl18 = false;
            List aspectList = new ArrayList();
            aspectList.clear();
            CameraInfo cameraInfo4 = cameraInfo3;
            if (cameraInfo4 != null && (list = cameraInfo4.getCameraPreviewSizes()) != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int height;
                    PreviewSize size = (PreviewSize)element$iv;
                    boolean bl19 = false;
                    int width = size.getWidth();
                    double ratio = (double)width / (double)(height = size.getHeight());
                    if (!Intrinsics.areEqual((double)ratio, (Double)aspectRatio)) continue;
                    aspectList.add(size);
                }
            }
            Logger.INSTANCE.i(TAG, "getAllPreviewSizes aspectRatio = " + aspectRatio + ", size = " + aspectList);
            return aspectList;
        }
        return null;
    }

    @Override
    public void register() {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor == null ? false : uSBMonitor.isRegistered()) {
            return;
        }
        this.mUsbMonitor = new USBMonitor(this.getContext(), new USBMonitor.OnDeviceConnectListener(this){
            final /* synthetic */ CameraUvcStrategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAttach(@Nullable UsbDevice device) {
                Object object;
                if (Utils.INSTANCE.getDebugCamera()) {
                    object = device;
                    Logger.INSTANCE.i("CameraUvc", Intrinsics.stringPlus((String)"attach device = ", (Object)(object == null ? null : object.toString())));
                }
                if ((object = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device)) {
                    return;
                }
                if (!CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0).contains(device)) {
                    object = device;
                    CameraUvcStrategy cameraUvcStrategy = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    UsbDevice it = object;
                    boolean bl3 = false;
                    CameraUvcStrategy.access$getMCacheDeviceList$p(cameraUvcStrategy).add(it);
                    object = CameraUvcStrategy.access$getMDevConnectCallBack$p(this.this$0);
                    if (object != null) {
                        object.onAttachDev(device);
                    }
                }
                CameraUvcStrategy.access$loadCameraInfoInternal(this.this$0, device);
                CameraUvcStrategy.access$requestCameraPermission(this.this$0, device);
            }

            public void onDetach(@Nullable UsbDevice device) {
                SettableFuture settableFuture;
                Object object;
                if (Utils.INSTANCE.getDebugCamera()) {
                    object = device;
                    Logger.INSTANCE.i("CameraUvc", Intrinsics.stringPlus((String)"onDetach device = ", (Object)(object == null ? null : object.getDeviceName())));
                }
                if (!(CameraUtils.INSTANCE.isUsbCamera(device) || CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device) || CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device))) {
                    return;
                }
                object = this.this$0.getMCameraInfoMap();
                UsbDevice usbDevice = device;
                usbDevice = usbDevice == null ? null : Integer.valueOf(usbDevice.getDeviceId());
                boolean bl = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                }
                TypeIntrinsics.asMutableMap((Object)object2).remove(usbDevice);
                object = CameraUvcStrategy.access$getMDevConnectCallBack$p(this.this$0);
                if (object != null) {
                    object.onDetachDec(device);
                }
                if (CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device)) {
                    object = CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0);
                    boolean bl2 = false;
                    Object object3 = object;
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                    }
                    TypeIntrinsics.asMutableCollection((Object)object3).remove(device);
                }
                UsbDevice dev = (settableFuture = CameraUvcStrategy.access$getMDevSettableFuture$p(this.this$0)) == null ? null : (UsbDevice)settableFuture.get();
                settableFuture = dev;
                Integer n = settableFuture == null ? null : Integer.valueOf(settableFuture.getDeviceId());
                settableFuture = device;
                if (Intrinsics.areEqual((Object)n, settableFuture == null ? null : Integer.valueOf(settableFuture.getDeviceId()))) {
                    CameraUvcStrategy.access$getMRequestPermission(this.this$0).set(false);
                }
            }

            public void onConnect(@Nullable UsbDevice device, @Nullable USBMonitor.UsbControlBlock ctrlBlock, boolean createNew) {
                Object object;
                if (Utils.INSTANCE.getDebugCamera()) {
                    object = device;
                    Logger.INSTANCE.i("CameraUvc", Intrinsics.stringPlus((String)"onConnect device = ", (Object)(object == null ? null : object.getDeviceName())));
                }
                if (!(CameraUtils.INSTANCE.isUsbCamera(device) || CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device) || CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device))) {
                    return;
                }
                CameraUvcStrategy.access$setMDevSettableFuture$p(this.this$0, new SettableFuture<V>());
                CameraUvcStrategy.access$setMCtrlBlockSettableFuture$p(this.this$0, new SettableFuture<V>());
                object = this.this$0.getRequest();
                if (object != null) {
                    Object object2 = object;
                    CameraUvcStrategy cameraUvcStrategy = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object $this$onConnect_u24lambda_u2d1 = object2;
                    boolean bl3 = false;
                    if (cameraUvcStrategy.getSurfaceTexture() != null) {
                        cameraUvcStrategy.startPreview((CameraRequest)$this$onConnect_u24lambda_u2d1, cameraUvcStrategy.getSurfaceTexture());
                    } else {
                        cameraUvcStrategy.startPreview((CameraRequest)$this$onConnect_u24lambda_u2d1, cameraUvcStrategy.getSurfaceHolder());
                    }
                }
                object = CameraUvcStrategy.access$getMDevSettableFuture$p(this.this$0);
                if (object != null) {
                    ((SettableFuture)object).set(device);
                }
                object = CameraUvcStrategy.access$getMCtrlBlockSettableFuture$p(this.this$0);
                if (object != null) {
                    ((SettableFuture)object).set(ctrlBlock);
                }
                CameraUvcStrategy.access$getMConnectSettableFuture$p(this.this$0).set(true);
            }

            public void onDisconnect(@Nullable UsbDevice device, @Nullable USBMonitor.UsbControlBlock ctrlBlock) {
                if (Utils.INSTANCE.getDebugCamera()) {
                    UsbDevice usbDevice = device;
                    Logger.INSTANCE.i("CameraUvc", Intrinsics.stringPlus((String)"onDisconnect device = ", (Object)(usbDevice == null ? null : usbDevice.getDeviceName())));
                }
                if (!(CameraUtils.INSTANCE.isUsbCamera(device) || CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device) || CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device))) {
                    return;
                }
                Object object = CameraUvcStrategy.access$getMDevSettableFuture$p(this.this$0);
                UsbDevice curDevice = object == null ? null : (UsbDevice)((SettableFuture)object).get();
                object = curDevice;
                if (!Intrinsics.areEqual((Object)(object == null ? null : Integer.valueOf(object.getDeviceId())), (object = device) == null ? null : Integer.valueOf(object.getDeviceId()))) {
                    return;
                }
                this.this$0.stopPreview();
                object = CameraUvcStrategy.access$getMDevConnectCallBack$p(this.this$0);
                if (object != null) {
                    object.onDisConnectDec(device, ctrlBlock);
                }
                CameraUvcStrategy.access$getMConnectSettableFuture$p(this.this$0).set(false);
            }

            public void onCancel(@Nullable UsbDevice device) {
                if (Utils.INSTANCE.getDebugCamera()) {
                    UsbDevice usbDevice = device;
                    Logger.INSTANCE.i("CameraUvc", Intrinsics.stringPlus((String)"onCancel device = ", (Object)(usbDevice == null ? null : usbDevice.getDeviceName())));
                }
                if (!(CameraUtils.INSTANCE.isUsbCamera(device) || CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device) || CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device))) {
                    return;
                }
                Object object = CameraUvcStrategy.access$getMDevSettableFuture$p(this.this$0);
                UsbDevice curDevice = object == null ? null : (UsbDevice)((SettableFuture)object).get();
                object = curDevice;
                if (!Intrinsics.areEqual((Object)(object == null ? null : Integer.valueOf(object.getDeviceId())), (object = device) == null ? null : Integer.valueOf(object.getDeviceId()))) {
                    return;
                }
                this.this$0.stopPreview();
                object = CameraUvcStrategy.access$getMDevConnectCallBack$p(this.this$0);
                if (object != null) {
                    IDeviceConnectCallBack.DefaultImpls.onDisConnectDec$default((IDeviceConnectCallBack)object, device, null, 2, null);
                }
            }
        });
        uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.register();
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "register uvc device monitor");
        }
    }

    @Override
    public void unRegister() {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor == null ? false : !uSBMonitor.isRegistered()) {
            return;
        }
        uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.unregister();
        }
        uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.destroy();
        }
        this.mUsbMonitor = null;
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "unRegister uvc device monitor");
        }
    }

    public final void setDeviceConnectStatusListener(@NotNull IDeviceConnectCallBack cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        this.mDevConnectCallBack = cb;
    }

    @Nullable
    public final List<UsbDevice> getUsbDeviceList(@Nullable Integer resId) {
        ArrayList<UsbDevice> arrayList;
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor == null) {
            arrayList = null;
        } else {
            List list = uSBMonitor.getDeviceList();
            if (list == null) {
                arrayList = null;
            } else {
                List list2 = list;
                boolean bl = false;
                boolean bl2 = false;
                List usbDevList = list2;
                boolean bl3 = false;
                boolean bl4 = false;
                ArrayList<UsbDevice> list3 = new ArrayList<UsbDevice>();
                List list4 = resId == null ? (List)null : DeviceFilter.getDeviceFilters((Context)this.getContext(), (int)resId);
                boolean bl5 = false;
                boolean bl6 = false;
                List filterList = list4;
                boolean bl7 = false;
                if (filterList == null) {
                    list3.addAll(usbDevList);
                } else {
                    Iterable $this$forEach$iv = usbDevList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DeviceFilter filterDev;
                        Object v1;
                        UsbDevice dev;
                        block8: {
                            dev = (UsbDevice)element$iv;
                            boolean bl8 = false;
                            Iterable iterable = filterList;
                            boolean bl9 = false;
                            Iterable iterable2 = iterable;
                            boolean bl10 = false;
                            for (Object t : iterable2) {
                                DeviceFilter it = (DeviceFilter)t;
                                boolean bl11 = false;
                                int n = it.mProductId;
                                UsbDevice usbDevice = dev;
                                if (!((usbDevice == null ? false : n == usbDevice.getProductId()) && it.mVendorId == dev.getVendorId())) continue;
                                v1 = t;
                                break block8;
                            }
                            v1 = null;
                        }
                        if ((filterDev = (DeviceFilter)v1) == null) continue;
                        list3.add(dev);
                    }
                }
                arrayList = list3;
            }
        }
        return arrayList;
    }

    public static /* synthetic */ List getUsbDeviceList$default(CameraUvcStrategy cameraUvcStrategy, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return cameraUvcStrategy.getUsbDeviceList(n);
    }

    @Nullable
    public final UsbDevice getCurrentDevice() {
        UsbDevice usbDevice;
        try {
            Boolean isConnected = this.mConnectSettableFuture.get(3L, TimeUnit.SECONDS);
            if (!Intrinsics.areEqual((Object)isConnected, (Object)true)) {
                return null;
            }
            SettableFuture<UsbDevice> settableFuture = this.mDevSettableFuture;
            usbDevice = settableFuture == null ? null : settableFuture.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            usbDevice = null;
        }
        return usbDevice;
    }

    @Nullable
    public final USBMonitor.UsbControlBlock getUsbControlBlock() {
        USBMonitor.UsbControlBlock usbControlBlock;
        try {
            Boolean isConnected = this.mConnectSettableFuture.get(3L, TimeUnit.SECONDS);
            if (!Intrinsics.areEqual((Object)isConnected, (Object)true)) {
                return null;
            }
            SettableFuture<USBMonitor.UsbControlBlock> settableFuture = this.mCtrlBlockSettableFuture;
            usbControlBlock = settableFuture == null ? null : settableFuture.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logger.INSTANCE.w(TAG, "get current usb control block times out");
            usbControlBlock = null;
        }
        return usbControlBlock;
    }

    public final boolean isMicSupported() {
        return CameraUtils.INSTANCE.isCameraContainsMic(this.getCurrentDevice());
    }

    @Nullable
    public final Integer sendCameraCommand(int command) {
        UVCCamera uVCCamera = this.mUVCCamera;
        uVCCamera = uVCCamera == null ? null : Integer.valueOf(uVCCamera.sendCommand(command));
        boolean bl = false;
        boolean bl2 = false;
        UVCCamera $this$sendCameraCommand_u24lambda_u2d28 = uVCCamera;
        boolean bl3 = false;
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"send command ret = ", (Object)$this$sendCameraCommand_u24lambda_u2d28));
        return uVCCamera;
    }

    public final void setAutoFocus(boolean enable) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setAutoFocus(enable);
        }
    }

    public final void setAutoWhiteBalance(boolean autoWhiteBalance) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setAutoWhiteBlance(autoWhiteBalance);
        }
    }

    public final void setZoom(int zoom) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setZoom(zoom);
        }
    }

    @Nullable
    public final Integer getZoom() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera == null ? null : Integer.valueOf(uVCCamera.getZoom());
    }

    public final void setGain(int gain) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setGain(gain);
        }
    }

    @Nullable
    public final Integer getGain() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera == null ? null : Integer.valueOf(uVCCamera.getGain());
    }

    public final void setGamma(int gamma) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setGamma(gamma);
        }
    }

    @Nullable
    public final Integer getGamma() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera == null ? null : Integer.valueOf(uVCCamera.getGamma());
    }

    public final void setBrightness(int brightness) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setBrightness(brightness);
        }
    }

    @Nullable
    public final Integer getBrightness() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera == null ? null : Integer.valueOf(uVCCamera.getBrightness());
    }

    public final void setContrast(int contrast) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setContrast(contrast);
        }
    }

    @Nullable
    public final Integer getContrast() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera == null ? null : Integer.valueOf(uVCCamera.getContrast());
    }

    public final void setSharpness(int sharpness) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setSharpness(sharpness);
        }
    }

    @Nullable
    public final Integer getSharpness() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera == null ? null : Integer.valueOf(uVCCamera.getSharpness());
    }

    public final void setSaturation(int saturation) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setSaturation(saturation);
        }
    }

    @Nullable
    public final Integer getSaturation() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera == null ? null : Integer.valueOf(uVCCamera.getSaturation());
    }

    public final void setHue(int hue) {
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.setHue(hue);
        }
    }

    @Nullable
    public final Integer getHue() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera == null ? null : Integer.valueOf(uVCCamera.getHue());
    }

    private final List<UsbDevice> getUsbDeviceListInternal() {
        List<UsbDevice> list;
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor == null) {
            list = null;
        } else {
            boolean bl = false;
            List list2 = uSBMonitor.getDeviceList((List)new ArrayList());
            if (list2 == null) {
                list = null;
            } else {
                List list3 = list2;
                boolean bl2 = false;
                boolean bl3 = false;
                List devList = list3;
                boolean bl4 = false;
                this.mCacheDeviceList.clear();
                ArrayList<String> devInfoList = new ArrayList<String>();
                Iterable $this$forEach$iv = devList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UsbDevice it = (UsbDevice)element$iv;
                    boolean bl5 = false;
                    devInfoList.add(it.getDeviceName());
                    if (!CameraUtils.INSTANCE.isUsbCamera(it) && !CameraUtils.INSTANCE.isFilterDevice(this.getContext(), it)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.mCacheDeviceList.add(it);
                }
                Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)" find some device list, = ", devInfoList));
                list = this.mCacheDeviceList;
            }
        }
        return list;
    }

    private final void requestCameraPermission(UsbDevice device) {
        Object v0;
        boolean bl;
        Iterable iterable;
        block5: {
            if (this.getMRequestPermission().get()) {
                return;
            }
            iterable = this.mCacheDeviceList;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object object : iterable2) {
                UsbDevice it = (UsbDevice)object;
                boolean bl3 = false;
                UsbDevice usbDevice = device;
                if (!(usbDevice == null ? false : usbDevice.getDeviceId() == it.getDeviceId())) continue;
                v0 = object;
                break block5;
            }
            v0 = null;
        }
        iterable = v0;
        bl = false;
        boolean bl4 = false;
        UsbDevice dev = (UsbDevice)iterable;
        boolean bl5 = false;
        if (dev == null) {
            Logger.INSTANCE.e(TAG, "open camera failed, not found.");
        } else {
            Object object;
            this.getMRequestPermission().set(true);
            object = this.mUsbMonitor;
            if (object != null) {
                object.requestPermission(dev);
            }
        }
    }

    private static final void captureImageInternal$lambda-7(CameraUvcStrategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError("Have no storage or camera permission.");
        }
    }

    private static final void captureImageInternal$lambda-12$lambda-8(CameraUvcStrategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError("Times out or camera request is null");
        }
    }

    private static final void captureImageInternal$lambda-12$lambda-9(CameraUvcStrategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onBegin();
        }
    }

    private static final void captureImageInternal$lambda-12$lambda-10(CameraUvcStrategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError("save yuv to jpeg failed.");
        }
    }

    private static final void captureImageInternal$lambda-12$lambda-11(CameraUvcStrategy this$0, String $path) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onComplete($path);
        }
    }

    private static final void captureImageInternal$lambda-12(CameraUvcStrategy this$0, String $savePath) {
        ContentResolver contentResolver;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        byte[] data = this$0.getMNV21DataQueue().pollFirst(1L, TimeUnit.SECONDS);
        if (data == null || this$0.getRequest() == null) {
            this$0.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda-12$lambda-8(this$0));
            Logger.INSTANCE.i(TAG, "captureImageInternal failed, times out.");
            return;
        }
        this$0.getMIsCapturing().set(true);
        this$0.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda-12$lambda-9(this$0));
        String date = this$0.getMDateFormat().format(System.currentTimeMillis());
        String string = $savePath;
        String title = string == null ? Intrinsics.stringPlus((String)"IMG_JJCamera_", (Object)date) : string;
        String string2 = $savePath;
        String displayName = string2 == null ? Intrinsics.stringPlus((String)title, (Object)".jpg") : string2;
        String string3 = $savePath;
        String path = string3 == null ? this$0.getMCameraDir() + '/' + displayName : string3;
        int orientation = 0;
        Location location = Utils.INSTANCE.getGpsLocation(this$0.getContext());
        CameraRequest cameraRequest = this$0.getRequest();
        Intrinsics.checkNotNull((Object)cameraRequest);
        int width = cameraRequest.getPreviewWidth();
        CameraRequest cameraRequest2 = this$0.getRequest();
        Intrinsics.checkNotNull((Object)cameraRequest2);
        int height = cameraRequest2.getPreviewHeight();
        boolean ret = MediaUtils.INSTANCE.saveYuv2Jpeg(path, data, width, height);
        if (!ret) {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            this$0.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda-12$lambda-10(this$0));
            Logger.INSTANCE.w(TAG, "save yuv to jpeg failed.");
            return;
        }
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        values.put("_data", path);
        values.put("datetaken", date);
        values.put("orientation", Integer.valueOf(orientation));
        Location location2 = location;
        values.put("longitude", location2 == null ? null : Double.valueOf(location2.getLongitude()));
        location2 = location;
        values.put("latitude", location2 == null ? null : Double.valueOf(location2.getLatitude()));
        location2 = this$0.getContext();
        if (location2 != null && (contentResolver = location2.getContentResolver()) != null) {
            contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        this$0.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda-12$lambda-11(this$0, path));
        this$0.getMIsCapturing().set(false);
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"captureImageInternal save path = ", (Object)path));
        }
    }

    private static final void frameCallBack$lambda-35(CameraUvcStrategy this$0, ByteBuffer frame) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.getMPreviewDataCbList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPreviewDataCallBack cb = (IPreviewDataCallBack)element$iv;
            boolean bl = false;
            ByteBuffer byteBuffer = frame;
            if (byteBuffer == null) continue;
            ByteBuffer byteBuffer2 = byteBuffer;
            boolean bl2 = false;
            boolean bl3 = false;
            ByteBuffer $this$frameCallBack_u24lambda_u2d35_u24lambda_u2d34_u24lambda_u2d33 = byteBuffer2;
            boolean bl4 = false;
            frame.position(0);
            byte[] data = new byte[$this$frameCallBack_u24lambda_u2d35_u24lambda_u2d34_u24lambda_u2d33.capacity()];
            $this$frameCallBack_u24lambda_u2d35_u24lambda_u2d34_u24lambda_u2d33.get(data);
            cb.onPreviewData(data, IPreviewDataCallBack.DataFormat.NV21);
            if (this$0.getMNV21DataQueue().size() >= 5) {
                this$0.getMNV21DataQueue().removeLast();
            }
            this$0.getMNV21DataQueue().offerFirst(data);
        }
    }

    public static final /* synthetic */ List access$getMCacheDeviceList$p(CameraUvcStrategy $this) {
        return $this.mCacheDeviceList;
    }

    public static final /* synthetic */ IDeviceConnectCallBack access$getMDevConnectCallBack$p(CameraUvcStrategy $this) {
        return $this.mDevConnectCallBack;
    }

    public static final /* synthetic */ void access$loadCameraInfoInternal(CameraUvcStrategy $this, UsbDevice dev) {
        $this.loadCameraInfoInternal(dev);
    }

    public static final /* synthetic */ void access$requestCameraPermission(CameraUvcStrategy $this, UsbDevice device) {
        $this.requestCameraPermission(device);
    }

    public static final /* synthetic */ SettableFuture access$getMDevSettableFuture$p(CameraUvcStrategy $this) {
        return $this.mDevSettableFuture;
    }

    public static final /* synthetic */ AtomicBoolean access$getMRequestPermission(CameraUvcStrategy $this) {
        return $this.getMRequestPermission();
    }

    public static final /* synthetic */ void access$setMDevSettableFuture$p(CameraUvcStrategy $this, SettableFuture settableFuture) {
        $this.mDevSettableFuture = settableFuture;
    }

    public static final /* synthetic */ void access$setMCtrlBlockSettableFuture$p(CameraUvcStrategy $this, SettableFuture settableFuture) {
        $this.mCtrlBlockSettableFuture = settableFuture;
    }

    public static final /* synthetic */ SettableFuture access$getMCtrlBlockSettableFuture$p(CameraUvcStrategy $this) {
        return $this.mCtrlBlockSettableFuture;
    }

    public static final /* synthetic */ SettableFuture access$getMConnectSettableFuture$p(CameraUvcStrategy $this) {
        return $this.mConnectSettableFuture;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jiangdg/ausbc/camera/CameraUvcStrategy$Companion;", "", "()V", "CAPTURE_TIMES_OUT_SEC", "", "MAX_FS", "", "MAX_NV21_DATA", "MIN_FS", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

