/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000  2\u00020\u0001:\u0002 !B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\u001f\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\""}, d2={"Lcom/jiangdg/ausbc/encode/H264EncodeProcessor;", "Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "width", "", "height", "gLESRender", "", "(IIZ)V", "getHeight", "()I", "mBitRate", "Ljava/lang/Integer;", "mFrameRate", "mReadyListener", "Lcom/jiangdg/ausbc/encode/H264EncodeProcessor$OnEncodeReadyListener;", "getWidth", "getEncodeBitrate", "getPTSUs", "", "bufferSize", "getSupportColorFormat", "getThreadName", "", "handleStartEncode", "", "handleStopEncode", "setEncodeRate", "bitRate", "frameRate", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "setOnEncodeReadyListener", "listener", "Companion", "OnEncodeReadyListener", "libausbc_release"})
public final class H264EncodeProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    private final boolean gLESRender;
    @Nullable
    private Integer mFrameRate;
    @Nullable
    private Integer mBitRate;
    @Nullable
    private OnEncodeReadyListener mReadyListener;
    @NotNull
    private static final String TAG = "H264EncodeProcessor";
    @NotNull
    private static final String MIME = "video/avc";
    private static final int FRAME_RATE = 30;
    private static final int KEY_FRAME_INTERVAL = 1;

    public H264EncodeProcessor(int width, int height, boolean gLESRender) {
        this.width = width;
        this.height = height;
        this.gLESRender = gLESRender;
    }

    public /* synthetic */ H264EncodeProcessor(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        this(n, n2, bl);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    protected String getThreadName() {
        return TAG;
    }

    @Override
    protected void handleStartEncode() {
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)MIME, (int)this.width, (int)this.height);
            Object object = this.mFrameRate;
            mediaFormat.setInteger("frame-rate", object == null ? 30 : (Integer)object);
            object = this.mBitRate;
            mediaFormat.setInteger("bitrate", object == null ? this.getEncodeBitrate(this.width, this.height) : ((Integer)object).intValue());
            mediaFormat.setInteger("i-frame-interval", 1);
            mediaFormat.setInteger("color-format", this.getSupportColorFormat());
            this.setMMediaCodec(MediaCodec.createEncoderByType((String)MIME));
            object = this.getMMediaCodec();
            if (object != null) {
                object.configure(mediaFormat, null, null, 1);
            }
            if (this.gLESRender && (object = this.mReadyListener) != null) {
                MediaCodec mediaCodec = this.getMMediaCodec();
                object.onReady(mediaCodec == null ? null : mediaCodec.createInputSurface());
            }
            if ((object = this.getMMediaCodec()) != null) {
                object.start();
            }
            this.getMEncodeState().set(true);
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "init h264 media codec success.");
            }
            this.doEncodeData();
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"start h264 media codec failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleStopEncode() {
        try {
            this.getMEncodeState().set(false);
            MediaCodec mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.stop();
            }
            mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.release();
            }
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "release h264 media codec success.");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Stop mediaCodec failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
        finally {
            this.getMRawDataQueue().clear();
            this.setMMediaCodec(null);
        }
    }

    @Override
    protected long getPTSUs(int bufferSize) {
        return System.nanoTime() / 1000L;
    }

    public final void setOnEncodeReadyListener(@NotNull OnEncodeReadyListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.mReadyListener = listener2;
    }

    private final int getSupportColorFormat() {
        if (this.gLESRender) {
            return 2130708361;
        }
        if (this.isLowerLollipop()) {
            return 21;
        }
        return 2135033992;
    }

    private final int getEncodeBitrate(int width, int height) {
        float bitRate = (float)(width * height * 20 * 3) * 0.07f;
        if (width >= 1920 || height >= 1920) {
            bitRate *= 0.75f;
        } else if (width >= 1280 || height >= 1280) {
            bitRate *= 1.2f;
        } else if (width >= 640 || height >= 640) {
            bitRate *= 1.4f;
        }
        return (int)bitRate;
    }

    public final void setEncodeRate(@Nullable Integer bitRate, @Nullable Integer frameRate) {
        this.mBitRate = bitRate;
        this.mFrameRate = frameRate;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/encode/H264EncodeProcessor$OnEncodeReadyListener;", "", "onReady", "", "surface", "Landroid/view/Surface;", "libausbc_release"})
    public static interface OnEncodeReadyListener {
        public void onReady(@Nullable Surface var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jiangdg/ausbc/encode/H264EncodeProcessor$Companion;", "", "()V", "FRAME_RATE", "", "KEY_FRAME_INTERVAL", "MIME", "", "TAG", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

