/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.encoder.biz;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import com.serenegiant.usb.encoder.biz.Mp4MediaMuxer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public class H264EncodeConsumer
extends Thread {
    private static final boolean DEBUG = false;
    private static final String TAG = "H264EncodeConsumer";
    private static final String MIME_TYPE = "video/avc";
    private static final int FRAME_INTERVAL = 1;
    private static final int TIMES_OUT = 10000;
    private MediaCodec mMediaCodec;
    private int mColorFormat;
    private boolean isExit = false;
    private boolean isEncoderStart = false;
    private MediaFormat mFormat;
    private static String path = Environment.getExternalStorageDirectory().getAbsolutePath() + "/test2.h264";
    private BufferedOutputStream outputStream;
    final int millisPerframe = 50;
    long lastPush = 0L;
    private OnH264EncodeResultListener listener;
    private int mWidth;
    private int mHeight;
    private MediaFormat newFormat;
    private WeakReference<Mp4MediaMuxer> mMuxerRef;
    private boolean isAddKeyFrame = false;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private static final int FRAME_RATE = 15;
    private static final float BPP = 0.5f;
    protected static int[] recognizedFormats = new int[]{21, 2141391872};

    public void setOnH264EncodeResultListener(OnH264EncodeResultListener listener) {
        this.listener = listener;
    }

    public H264EncodeConsumer(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public synchronized void setTmpuMuxer(Mp4MediaMuxer mMuxer) {
        this.mMuxerRef = new WeakReference<Mp4MediaMuxer>(mMuxer);
        Mp4MediaMuxer muxer = (Mp4MediaMuxer)this.mMuxerRef.get();
        if (muxer != null && this.newFormat != null) {
            muxer.addTrack(this.newFormat, true);
        }
    }

    public void setRawYuv(byte[] yuvData, int width, int height) {
        if (!this.isEncoderStart) {
            return;
        }
        if (this.mWidth != width || this.mHeight != height) {
            this.mWidth = width;
            this.mHeight = height;
            return;
        }
        try {
            long time;
            if (this.lastPush == 0L) {
                this.lastPush = System.currentTimeMillis();
            }
            if ((time = System.currentTimeMillis() - this.lastPush) >= 0L && (time = 50L - time) > 0L) {
                Thread.sleep(time / 2L);
            }
            this.feedMediaCodecData(this.nv12ToNV21(yuvData, this.mWidth, this.mHeight));
            if (time > 0L) {
                Thread.sleep(time / 2L);
            }
            this.lastPush = System.currentTimeMillis();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private void feedMediaCodecData(byte[] data) {
        if (!this.isEncoderStart) {
            return;
        }
        int bufferIndex = -1;
        try {
            bufferIndex = this.mMediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        if (bufferIndex >= 0) {
            ByteBuffer buffer = Build.VERSION.SDK_INT >= 21 ? this.mMediaCodec.getInputBuffer(bufferIndex) : this.inputBuffers[bufferIndex];
            buffer.clear();
            buffer.put(data);
            buffer.clear();
            this.mMediaCodec.queueInputBuffer(bufferIndex, 0, data.length, System.nanoTime() / 1000L, 1);
        }
    }

    public void exit() {
        this.isExit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressLint(value={"WrongConstant"})
    public void run() {
        if (!this.isEncoderStart) {
            this.startMediaCodec();
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        while (!this.isExit) {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int outputBufferIndex = 0;
            byte[] mPpsSps = new byte[]{};
            byte[] h264 = new byte[this.mWidth * this.mHeight];
            do {
                if ((outputBufferIndex = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 10000L)) == -1) continue;
                if (outputBufferIndex == -3) {
                    this.outputBuffers = this.mMediaCodec.getOutputBuffers();
                    continue;
                }
                if (outputBufferIndex == -2) {
                    H264EncodeConsumer h264EncodeConsumer = this;
                    synchronized (h264EncodeConsumer) {
                        Mp4MediaMuxer muxer;
                        this.newFormat = this.mMediaCodec.getOutputFormat();
                        if (this.mMuxerRef != null && (muxer = (Mp4MediaMuxer)this.mMuxerRef.get()) != null) {
                            muxer.addTrack(this.newFormat, true);
                        }
                    }
                } else {
                    Mp4MediaMuxer muxer;
                    if (outputBufferIndex < 0) continue;
                    ByteBuffer outputBuffer = Build.VERSION.SDK_INT >= 21 ? this.mMediaCodec.getOutputBuffer(outputBufferIndex) : this.outputBuffers[outputBufferIndex];
                    outputBuffer.position(bufferInfo.offset);
                    outputBuffer.limit(bufferInfo.offset + bufferInfo.size);
                    boolean sync = false;
                    if ((bufferInfo.flags & 2) != 0) {
                        boolean bl = sync = (bufferInfo.flags & 1) != 0;
                        if (!sync) {
                            byte[] temp = new byte[bufferInfo.size];
                            outputBuffer.get(temp);
                            mPpsSps = temp;
                            this.mMediaCodec.releaseOutputBuffer(outputBufferIndex, false);
                            continue;
                        }
                        mPpsSps = new byte[]{};
                    }
                    sync |= (bufferInfo.flags & 1) != 0;
                    int len = mPpsSps.length + bufferInfo.size;
                    if (len > h264.length) {
                        h264 = new byte[len];
                    }
                    if (sync) {
                        System.arraycopy(mPpsSps, 0, h264, 0, mPpsSps.length);
                        outputBuffer.get(h264, mPpsSps.length, bufferInfo.size);
                        if (this.listener != null) {
                            this.listener.onEncodeResult(h264, 0, mPpsSps.length + bufferInfo.size, bufferInfo.presentationTimeUs / 1000L);
                        }
                        if (this.mMuxerRef != null) {
                            muxer = (Mp4MediaMuxer)this.mMuxerRef.get();
                            if (muxer != null) {
                                muxer.pumpStream(outputBuffer, bufferInfo, true);
                            }
                            this.isAddKeyFrame = true;
                        }
                    } else {
                        outputBuffer.get(h264, 0, bufferInfo.size);
                        if (this.listener != null) {
                            this.listener.onEncodeResult(h264, 0, bufferInfo.size, bufferInfo.presentationTimeUs / 1000L);
                        }
                        if (this.isAddKeyFrame && this.mMuxerRef != null && (muxer = (Mp4MediaMuxer)this.mMuxerRef.get()) != null) {
                            muxer.pumpStream(outputBuffer, bufferInfo, true);
                        }
                    }
                    this.mMediaCodec.releaseOutputBuffer(outputBufferIndex, false);
                }
            } while (!this.isExit && this.isEncoderStart);
        }
        this.stopMediaCodec();
    }

    private void startMediaCodec() {
        MediaCodecInfo videoCodecInfo = this.selectVideoCodec(MIME_TYPE);
        if (videoCodecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", this.mColorFormat);
        format.setInteger("bitrate", this.calcBitRate());
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 1);
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mMediaCodec.configure(format, null, null, 1);
        this.mMediaCodec.start();
        this.isEncoderStart = true;
        if (Build.VERSION.SDK_INT >= 22) {
            this.outputBuffers = null;
            this.inputBuffers = null;
        } else {
            this.inputBuffers = this.mMediaCodec.getInputBuffers();
            this.outputBuffers = this.mMediaCodec.getOutputBuffers();
        }
        Bundle params = new Bundle();
        params.putInt("request-sync", 0);
        if (Build.VERSION.SDK_INT >= 19) {
            this.mMediaCodec.setParameters(params);
        }
    }

    private void stopMediaCodec() {
        this.isEncoderStart = false;
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            Log.d((String)TAG, (String)"\u5173\u95ed\u89c6\u9891\u7f16\u7801\u5668");
        }
    }

    private int calcBitRate() {
        int bitrate = (int)(7.5f * (float)this.mWidth * (float)this.mHeight);
        Log.i((String)TAG, (String)String.format("bitrate=%5.2f[Mbps]", Float.valueOf((float)bitrate / 1024.0f / 1024.0f)));
        return bitrate;
    }

    protected final MediaCodecInfo selectVideoCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                int format;
                if (!types[j].equalsIgnoreCase(mimeType) || (format = H264EncodeConsumer.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                this.mColorFormat = format;
                return codecInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities caps;
        int result = 0;
        try {
            Thread.currentThread().setPriority(10);
            caps = codecInfo.getCapabilitiesForType(mimeType);
        }
        finally {
            Thread.currentThread().setPriority(5);
        }
        for (int i = 0; i < caps.colorFormats.length; ++i) {
            int colorFormat = caps.colorFormats[i];
            if (!H264EncodeConsumer.isRecognizedViewoFormat(colorFormat)) continue;
            if (result != 0) break;
            result = colorFormat;
            break;
        }
        if (result == 0) {
            Log.e((String)TAG, (String)("couldn't find a good color format for " + codecInfo.getName() + " / " + mimeType));
        }
        return result;
    }

    private static final boolean isRecognizedViewoFormat(int colorFormat) {
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }

    private byte[] nv21ToI420(byte[] data, int width, int height) {
        byte[] ret = new byte[width * height * 3 / 2];
        int total = width * height;
        ByteBuffer bufferY = ByteBuffer.wrap(ret, 0, total);
        ByteBuffer bufferU = ByteBuffer.wrap(ret, total, total / 4);
        ByteBuffer bufferV = ByteBuffer.wrap(ret, total + total / 4, total / 4);
        bufferY.put(data, 0, total);
        for (int i = total; i < data.length; i += 2) {
            bufferV.put(data[i]);
            bufferU.put(data[i + 1]);
        }
        return ret;
    }

    private byte[] nv12ToI420(byte[] data, int width, int height) {
        byte[] ret = new byte[width * height * 3 / 2];
        int total = width * height;
        ByteBuffer bufferY = ByteBuffer.wrap(ret, 0, total);
        ByteBuffer bufferU = ByteBuffer.wrap(ret, total, total / 4);
        ByteBuffer bufferV = ByteBuffer.wrap(ret, total + total / 4, total / 4);
        bufferY.put(data, 0, total);
        for (int i = total; i < data.length; i += 2) {
            bufferU.put(data[i]);
            bufferV.put(data[i + 1]);
        }
        return ret;
    }

    private byte[] nv12ToNv21(byte[] data, int width, int height) {
        byte[] ret = new byte[width * height * 3 / 2];
        int total = width * height;
        ByteBuffer bufferY = ByteBuffer.wrap(ret, 0, total);
        ByteBuffer bufferU = ByteBuffer.wrap(ret, total, total / 4);
        ByteBuffer bufferV = ByteBuffer.wrap(ret, total + total / 4, total / 4);
        bufferY.put(data, 0, total);
        for (int i = total; i < data.length; i += 2) {
            bufferU.put(data[i]);
            bufferV.put(data[i + 1]);
        }
        return ret;
    }

    private byte[] nv21ToNV12(byte[] nv21, int width, int height) {
        byte[] ret = new byte[width * height * 3 / 2];
        int framesize = width * height;
        boolean i = false;
        int j = 0;
        System.arraycopy(nv21, 0, ret, 0, framesize);
        for (j = framesize; j < nv21.length; j += 2) {
            ret[j + 1] = nv21[j + 1];
            ret[j] = nv21[j];
        }
        return ret;
    }

    private byte[] nv12ToNV21(byte[] nv12, int width, int height) {
        byte[] ret = new byte[width * height * 3 / 2];
        int framesize = width * height;
        boolean i = false;
        int j = 0;
        System.arraycopy(nv12, 0, ret, 0, framesize);
        for (j = framesize; j < nv12.length; j += 2) {
            ret[j] = nv12[j + 1];
            ret[j + 1] = nv12[j];
        }
        return ret;
    }

    public static interface OnH264EncodeResultListener {
        public void onEncodeResult(byte[] var1, int var2, int var3, long var4);
    }
}

