/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.common;

import android.app.Activity;
import android.view.Surface;
import com.serenegiant.glutils.RendererHolder;
import com.serenegiant.usb.common.AbstractUVCCameraHandler;
import com.serenegiant.usb.widget.CameraViewInterface;

public class UVCCameraHandlerMultiSurface
extends AbstractUVCCameraHandler {
    private RendererHolder mRendererHolder;

    public static final UVCCameraHandlerMultiSurface createHandler(Activity parent, CameraViewInterface cameraView, int width, int height) {
        return UVCCameraHandlerMultiSurface.createHandler(parent, cameraView, 1, width, height, 1, 1.0f);
    }

    public static final UVCCameraHandlerMultiSurface createHandler(Activity parent, CameraViewInterface cameraView, int width, int height, float bandwidthFactor) {
        return UVCCameraHandlerMultiSurface.createHandler(parent, cameraView, 1, width, height, 1, bandwidthFactor);
    }

    public static final UVCCameraHandlerMultiSurface createHandler(Activity parent, CameraViewInterface cameraView, int encoderType, int width, int height) {
        return UVCCameraHandlerMultiSurface.createHandler(parent, cameraView, encoderType, width, height, 1, 1.0f);
    }

    public static final UVCCameraHandlerMultiSurface createHandler(Activity parent, CameraViewInterface cameraView, int encoderType, int width, int height, int format) {
        return UVCCameraHandlerMultiSurface.createHandler(parent, cameraView, encoderType, width, height, format, 1.0f);
    }

    public static final UVCCameraHandlerMultiSurface createHandler(Activity parent, CameraViewInterface cameraView, int encoderType, int width, int height, int format, float bandwidthFactor) {
        AbstractUVCCameraHandler.CameraThread thread = new AbstractUVCCameraHandler.CameraThread(UVCCameraHandlerMultiSurface.class, parent, cameraView, encoderType, width, height, format, bandwidthFactor);
        thread.start();
        return (UVCCameraHandlerMultiSurface)thread.getHandler();
    }

    protected UVCCameraHandlerMultiSurface(AbstractUVCCameraHandler.CameraThread thread) {
        super(thread);
        this.mRendererHolder = new RendererHolder(thread.getWidth(), thread.getHeight(), null);
    }

    @Override
    public synchronized void release() {
        if (this.mRendererHolder != null) {
            this.mRendererHolder.release();
            this.mRendererHolder = null;
        }
        super.release();
    }

    @Override
    public synchronized void resize(int width, int height) {
        super.resize(width, height);
        if (this.mRendererHolder != null) {
            this.mRendererHolder.resize(width, height);
        }
    }

    public synchronized void startPreview() {
        this.checkReleased();
        if (this.mRendererHolder == null) {
            throw new IllegalStateException();
        }
        super.startPreview(this.mRendererHolder.getSurface());
    }

    public synchronized void addSurface(int surfaceId, Surface surface, boolean isRecordable) {
        this.checkReleased();
        this.mRendererHolder.addSurface(surfaceId, (Object)surface, isRecordable);
    }

    public synchronized void removeSurface(int surfaceId) {
        if (this.mRendererHolder != null) {
            this.mRendererHolder.removeSurface(surfaceId);
        }
    }

    @Override
    public void captureStill(final String path, AbstractUVCCameraHandler.OnCaptureListener listener) {
        this.checkReleased();
        this.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UVCCameraHandlerMultiSurface uVCCameraHandlerMultiSurface = UVCCameraHandlerMultiSurface.this;
                synchronized (uVCCameraHandlerMultiSurface) {
                    if (UVCCameraHandlerMultiSurface.this.mRendererHolder != null) {
                        UVCCameraHandlerMultiSurface.this.mRendererHolder.captureStill(path);
                        UVCCameraHandlerMultiSurface.this.updateMedia(path);
                    }
                }
            }
        });
    }
}

