/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.attribute.SimpleLength;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class SVGRectangle
implements XMLConvertible {
    private final Length x;
    private final Length y;
    private final Length width;
    private final Length height;

    public static SVGRectangle mm(double x, double y, double width, double height) {
        return new SVGRectangle(SimpleLength.mm(x), SimpleLength.mm(y), SimpleLength.mm(width), SimpleLength.mm(height));
    }

    public static SVGRectangle cm(double x, double y, double width, double height) {
        return new SVGRectangle(SimpleLength.cm(x), SimpleLength.cm(y), SimpleLength.cm(width), SimpleLength.cm(height));
    }

    public static SVGRectangle in(double x, double y, double width, double height) {
        return new SVGRectangle(SimpleLength.in(x), SimpleLength.in(y), SimpleLength.in(width), SimpleLength.in(height));
    }

    public static SVGRectangle pt(double x, double y, double width, double height) {
        return new SVGRectangle(SimpleLength.pt(x), SimpleLength.pt(y), SimpleLength.pt(width), SimpleLength.pt(height));
    }

    public static SVGRectangle pc(double x, double y, double width, double height) {
        return new SVGRectangle(SimpleLength.pc(x), SimpleLength.pc(y), SimpleLength.pc(width), SimpleLength.pc(height));
    }

    public static SVGRectangle em(double x, double y, double width, double height) {
        return new SVGRectangle(SimpleLength.em(x), SimpleLength.em(y), SimpleLength.em(width), SimpleLength.em(height));
    }

    public SVGRectangle(Length x, Length y, Length width, Length height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        if (this.x != null) {
            util.appendAttribute(appendable, (CharSequence)"svg:x", this.x);
        }
        if (this.y != null) {
            util.appendAttribute(appendable, (CharSequence)"svg:y", this.y);
        }
        if (this.width != null) {
            util.appendAttribute(appendable, (CharSequence)"svg:width", this.width);
        }
        if (this.height != null) {
            util.appendAttribute(appendable, (CharSequence)"svg:height", this.height);
        }
        if (this.x == null && this.y == null && (this.width != null || this.height != null)) {
            util.appendAttribute(appendable, (CharSequence)"svg:x", "");
        }
    }
}

