/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.util.CharsetUtil;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class MacroModule {
    private final String name;
    private final String language;
    private final CharSequence code;

    public static MacroModule createBasic(String name, CharSequence code) {
        return new MacroModule(name, "StarBasic", code);
    }

    public MacroModule(String name, String language, CharSequence code) {
        this.name = name;
        this.language = language;
        this.code = code;
    }

    public void add(XMLUtil util, OdsDocument document, String libraryNameSlash) throws IOException {
        document.addExtraFile(libraryNameSlash + this.name + ".xml", "text/xml", this.module(util));
    }

    private byte[] module(XMLUtil util) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE script:module PUBLIC \"-//OpenOffice.org//DTD OfficeDocument 1.0//EN\" \"module.dtd\">");
        sb.append("<script:module xmlns:script=\"http://openoffice.org/2000/script\"");
        util.appendAttribute((Appendable)sb, (CharSequence)"script:name", this.name);
        util.appendAttribute((Appendable)sb, (CharSequence)"script:language", this.language);
        util.appendAttribute((Appendable)sb, (CharSequence)"script:moduleType", "normal");
        sb.append(">");
        sb.append(this.code);
        sb.append("</script:module>");
        return sb.toString().getBytes(CharsetUtil.UTF_8);
    }

    public void appendIndexLine(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<library:element");
        util.appendAttribute(appendable, (CharSequence)"library:name", this.name);
        appendable.append("/>");
    }
}

