/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.ObjectStyleFamily;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.TableStyleBuilder;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class TableStyle
implements ObjectStyle {
    public static final TableStyle DEFAULT_TABLE_STYLE = TableStyle.builder("ta1").build();
    private final boolean hidden;
    private final PageStyle pageStyle;
    private final String name;
    private String key;

    public static TableStyleBuilder builder(String name) {
        return new TableStyleBuilder(name);
    }

    TableStyle(String styleName, boolean hidden, PageStyle pageStyle) {
        this.name = styleName;
        this.hidden = hidden;
        this.pageStyle = pageStyle;
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addContentStyle(this);
        this.pageStyle.addToElements(odsElements);
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:style");
        util.appendEAttribute(appendable, "style:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"style:family", "table");
        if (this.pageStyle != null) {
            util.appendEAttribute(appendable, "style:master-page-name", this.pageStyle.getMasterName());
        }
        appendable.append("><style:table-properties");
        util.appendAttribute(appendable, (CharSequence)"table:display", "true");
        util.appendAttribute(appendable, (CharSequence)"style:writing-mode", "lr-tb");
        appendable.append("/></style:style>");
    }

    @Override
    public ObjectStyleFamily getFamily() {
        return ObjectStyleFamily.TABLE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = (Object)((Object)this.getFamily()) + "@" + this.getName();
        }
        return this.key;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public PageStyle getPageStyle() {
        return this.pageStyle;
    }
}

