/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.attribute.Angle;
import com.github.jferard.fastods.attribute.BorderAttribute;
import com.github.jferard.fastods.attribute.BorderStyle;
import com.github.jferard.fastods.attribute.CellAlign;
import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.attribute.SimpleColor;
import com.github.jferard.fastods.attribute.VerticalAlign;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.style.Borders;
import com.github.jferard.fastods.style.BordersBuilder;
import com.github.jferard.fastods.style.HidableBuilder;
import com.github.jferard.fastods.style.Margins;
import com.github.jferard.fastods.style.MarginsBuilder;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableStyleBuilder;
import com.github.jferard.fastods.style.TextProperties;
import com.github.jferard.fastods.style.TextPropertiesBuilder;
import com.github.jferard.fastods.util.StyleBuilder;

public class TableCellStyleBuilder
implements StyleBuilder<TableCellStyle>,
HidableBuilder<TableCellStyleBuilder> {
    private final BordersBuilder bordersBuilder;
    private final MarginsBuilder marginsBuilder;
    private final String name;
    private final TextPropertiesBuilder tpBuilder;
    private Color backgroundColor;
    private DataStyle dataStyle;
    private CellAlign textAlign;
    private VerticalAlign verticalAlign;
    private Angle textRotating;
    private boolean wrap;
    private boolean hidden;
    private TableCellStyle parentCellStyle;

    TableCellStyleBuilder(String name) {
        this.name = TableStyleBuilder.checker.checkStyleName(name);
        this.parentCellStyle = TableCellStyle.DEFAULT_CELL_STYLE;
        this.tpBuilder = TextProperties.builder();
        this.bordersBuilder = new BordersBuilder();
        this.marginsBuilder = new MarginsBuilder();
        this.backgroundColor = SimpleColor.NONE;
        this.hidden = false;
    }

    public TableCellStyleBuilder(String name, boolean hidden, Borders borders, Margins margins, DataStyle dataStyle, Color backgroundColor, TextProperties textProperties, CellAlign textAlign, VerticalAlign verticalAlign, boolean wrap, TableCellStyle parentCellStyle, Angle textRotating) {
        this.name = name;
        this.hidden = hidden;
        this.dataStyle = dataStyle;
        this.backgroundColor = backgroundColor;
        this.textAlign = textAlign;
        this.verticalAlign = verticalAlign;
        this.wrap = wrap;
        this.parentCellStyle = parentCellStyle;
        this.textRotating = textRotating;
        this.tpBuilder = textProperties.toBuilder();
        this.bordersBuilder = borders.toBuilder();
        this.marginsBuilder = margins.toBuilder();
    }

    public TableCellStyleBuilder allMargins(Length size) {
        this.marginsBuilder.all(size);
        return this;
    }

    public TableCellStyleBuilder backgroundColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public TableCellStyleBuilder borderAll(Length size, Color borderColor, BorderStyle style) {
        BorderAttribute borderAttribute = new BorderAttribute(size, borderColor, style);
        return this.borderAll(borderAttribute);
    }

    public TableCellStyleBuilder borderAll(BorderAttribute borderAttribute) {
        this.bordersBuilder.all(borderAttribute);
        return this;
    }

    public TableCellStyleBuilder borderBottom(Length size, Color borderColor, BorderStyle style) {
        BorderAttribute borderAttribute = new BorderAttribute(size, borderColor, style);
        return this.borderBottom(borderAttribute);
    }

    public TableCellStyleBuilder borderBottom(BorderAttribute borderAttribute) {
        this.bordersBuilder.bottom(borderAttribute);
        return this;
    }

    public TableCellStyleBuilder borderLeft(Length size, Color borderColor, BorderStyle style) {
        BorderAttribute borderAttribute = new BorderAttribute(size, borderColor, style);
        return this.borderLeft(borderAttribute);
    }

    public TableCellStyleBuilder borderLeft(BorderAttribute borderAttribute) {
        this.bordersBuilder.left(borderAttribute);
        return this;
    }

    public TableCellStyleBuilder borderRight(Length size, Color borderColor, BorderStyle style) {
        BorderAttribute borderAttribute = new BorderAttribute(size, borderColor, style);
        return this.borderRight(borderAttribute);
    }

    public TableCellStyleBuilder borderRight(BorderAttribute borderAttribute) {
        this.bordersBuilder.right(borderAttribute);
        return this;
    }

    public TableCellStyleBuilder borderTop(Length size, Color borderColor, BorderStyle style) {
        BorderAttribute borderAttribute = new BorderAttribute(size, borderColor, style);
        return this.borderTop(borderAttribute);
    }

    public TableCellStyleBuilder borderTop(BorderAttribute borderAttribute) {
        this.bordersBuilder.top(borderAttribute);
        return this;
    }

    @Override
    public TableCellStyle build() {
        return new TableCellStyle(this.name, this.hidden, this.dataStyle, this.backgroundColor, this.tpBuilder.build(), this.textAlign, this.verticalAlign, this.wrap, this.parentCellStyle, this.bordersBuilder.build(), this.marginsBuilder.build(), this.textRotating);
    }

    public TableCellStyleBuilder textRotating(Angle angle) {
        this.textRotating = angle;
        return this;
    }

    public TableCellStyleBuilder dataStyle(DataStyle ds) {
        this.dataStyle = ds;
        return this;
    }

    public TableCellStyleBuilder fontColor(Color color) {
        this.tpBuilder.fontColor(color);
        return this;
    }

    public TableCellStyleBuilder fontName(String name) {
        this.tpBuilder.fontName(name);
        return this;
    }

    public TableCellStyleBuilder fontSize(Length fontSize) {
        this.tpBuilder.fontSize(fontSize);
        return this;
    }

    public TableCellStyleBuilder fontSizePercentage(double percentage) {
        this.tpBuilder.fontSizePercentage(percentage);
        return this;
    }

    public TableCellStyleBuilder fontStyleItalic() {
        this.tpBuilder.fontStyleItalic();
        return this;
    }

    public TableCellStyleBuilder fontStyleNormal() {
        this.tpBuilder.fontStyleNormal();
        return this;
    }

    public TableCellStyleBuilder fontUnderlineColor(Color color) {
        this.tpBuilder.fontUnderlineColor(color);
        return this;
    }

    public TableCellStyleBuilder fontUnderlineStyle(TextProperties.Underline style) {
        this.tpBuilder.fontUnderlineStyle(style);
        return this;
    }

    public TableCellStyleBuilder fontWeightBold() {
        this.tpBuilder.fontWeightBold();
        return this;
    }

    public TableCellStyleBuilder fontWeightNormal() {
        this.tpBuilder.fontWeightNormal();
        return this;
    }

    public TableCellStyleBuilder fontWrap(boolean fSetWrap) {
        this.wrap = fSetWrap;
        return this;
    }

    public TableCellStyleBuilder marginBottom(Length size) {
        this.marginsBuilder.bottom(size);
        return this;
    }

    public TableCellStyleBuilder marginLeft(Length size) {
        this.marginsBuilder.left(size);
        return this;
    }

    public TableCellStyleBuilder marginRight(Length size) {
        this.marginsBuilder.right(size);
        return this;
    }

    public TableCellStyleBuilder marginTop(Length size) {
        this.marginsBuilder.top(size);
        return this;
    }

    public TableCellStyleBuilder parentCellStyle(TableCellStyle tableCellStyle) {
        this.parentCellStyle = tableCellStyle;
        return this;
    }

    public TableCellStyleBuilder textAlign(CellAlign align) {
        this.textAlign = align;
        return this;
    }

    public TableCellStyleBuilder verticalAlign(VerticalAlign align) {
        this.verticalAlign = align;
        return this;
    }

    @Override
    public TableCellStyleBuilder hidden() {
        this.hidden = true;
        return this;
    }
}

