/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.attribute.Angle;
import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.DrawFill;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.ObjectStyleFamily;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class DrawFillGradient
implements DrawFill,
ObjectStyle {
    private final Angle angle;
    private final Color startColor;
    private final int startIntensity;
    private final Color endColor;
    private final int endIntensity;
    private String name;
    private String key;

    public DrawFillGradient(String name, Angle angle, Color startColor, int startIntensity, Color endColor, int endIntensity) {
        this.angle = angle;
        this.startColor = startColor;
        this.startIntensity = startIntensity;
        this.endColor = endColor;
        this.endIntensity = endIntensity;
    }

    @Override
    public ObjectStyleFamily getFamily() {
        return ObjectStyleFamily.DRAW_FILL_GRADIENT;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = (Object)((Object)this.getFamily()) + "@" + this.getName();
        }
        return this.key;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<draw:gradient");
        util.appendAttribute(appendable, (CharSequence)"draw:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"draw:angle", this.angle);
        util.appendAttribute(appendable, (CharSequence)"draw:start-color", this.startColor);
        util.appendAttribute(appendable, (CharSequence)"draw:start-intensity", this.startIntensity);
        util.appendAttribute(appendable, (CharSequence)"draw:end-color", this.endColor);
        util.appendAttribute(appendable, (CharSequence)"draw:end-intensity", this.endIntensity);
        appendable.append("/>");
    }

    @Override
    public void addToElements(OdsElements odsElements) {
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void appendAttributes(XMLUtil util, Appendable appendable) throws IOException {
        util.appendAttribute(appendable, (CharSequence)"draw:fill", "gradient");
        util.appendAttribute(appendable, (CharSequence)"draw:fill-gradient-name", this.name);
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        stylesContainer.addStylesStyle(this);
    }
}

