/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.ref.LocalCellAddressParser;
import com.github.jferard.fastods.ref.LocalCellRef;
import com.github.jferard.fastods.ref.RangeRef;
import com.github.jferard.fastods.ref.TableAddressParser;
import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.ref.TableRef;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

class RangeAddressParser {
    private final TableAddressParser tableAddressParser;
    private final LocalCellAddressParser localCellAddressParser;

    public static RangeAddressParser create(TableNameUtil tableNameUtil) {
        return new RangeAddressParser(new TableAddressParser(tableNameUtil), new LocalCellAddressParser());
    }

    public RangeAddressParser(TableAddressParser tableAddressParser, LocalCellAddressParser localCellAddressParser) {
        this.tableAddressParser = tableAddressParser;
        this.localCellAddressParser = localCellAddressParser;
    }

    public RangeRef parse(String address) throws ParseException, UnsupportedEncodingException {
        String localRangeAddress;
        TableRef tableRef;
        int tableSepIndex = address.lastIndexOf(46);
        if (tableSepIndex == -1) {
            tableRef = null;
            localRangeAddress = address;
        } else {
            String tableAddress = address.substring(0, tableSepIndex);
            tableRef = this.tableAddressParser.parse(tableAddress);
            localRangeAddress = address.substring(tableSepIndex + 1);
        }
        int colonSepIndex = localRangeAddress.indexOf(58);
        if (colonSepIndex == -1) {
            throw new ParseException("Expected a `:` symbol: " + localRangeAddress, 0);
        }
        LocalCellRef localFromCellRef = this.localCellAddressParser.parse(localRangeAddress.substring(0, colonSepIndex));
        LocalCellRef localToCellRef = this.localCellAddressParser.parse(localRangeAddress.substring(colonSepIndex + 1));
        return new RangeRef(tableRef, localFromCellRef, localToCellRef);
    }
}

