/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.attribute.ScriptEvent;
import com.github.jferard.fastods.odselement.ScriptEventListenerBuilder;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class ScriptEventListener
implements XMLConvertible {
    public static final String BASIC_LANG = "Basic";
    public static final String PYTHON_LANG = "Python";
    public static final String JAVA_LANG = "Java";
    public static final String JAVASCRIPT_LANG = "JavaScript";
    private final String genericLanguage;
    private final ScriptEvent event;
    private final String functionName;
    private final String language;

    public static ScriptEventListener create(ScriptEvent event, String functionName) {
        return new ScriptEventListener("ooo:script", event, functionName, BASIC_LANG);
    }

    public static ScriptEventListenerBuilder builder(ScriptEvent event, String functionName) {
        return new ScriptEventListenerBuilder(event, functionName);
    }

    public ScriptEventListener(String genericLanguage, ScriptEvent event, String functionName, String language) {
        this.genericLanguage = genericLanguage;
        this.event = event;
        this.functionName = functionName;
        this.language = language;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<script:event-listener");
        util.appendAttribute(appendable, (CharSequence)"script:language", this.genericLanguage);
        util.appendAttribute(appendable, (CharSequence)"script:event-name", this.event);
        util.appendAttribute(appendable, (CharSequence)"xlink:href", "vnd.sun.star.script:" + this.functionName + "?language=" + this.language + "&amp;location=document");
        util.appendAttribute(appendable, (CharSequence)"xlink:type", "simple");
        appendable.append("/>");
    }
}

