/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.attribute.FormatSource;
import com.github.jferard.fastods.datastyle.CoreDataStyleBuilder;
import com.github.jferard.fastods.datastyle.DataStyleBuilder;
import com.github.jferard.fastods.datastyle.DateTimeStyleFormat;
import com.github.jferard.fastods.datastyle.TimeStyle;
import java.util.Locale;

public class TimeStyleBuilder
implements DataStyleBuilder<TimeStyle, TimeStyleBuilder> {
    private final CoreDataStyleBuilder dataStyleBuilder;
    private DateTimeStyleFormat timeFormat;
    private FormatSource formatSource;

    public TimeStyleBuilder(String name, Locale locale) {
        this.dataStyleBuilder = new CoreDataStyleBuilder(name, locale);
        this.formatSource = FormatSource.FIXED;
        this.timeFormat = TimeStyle.Format.HHMMSS;
    }

    @Override
    public TimeStyle build() {
        return new TimeStyle(this.dataStyleBuilder.build(), this.formatSource, this.timeFormat);
    }

    public TimeStyleBuilder formatSource(FormatSource formatSource) {
        this.formatSource = formatSource;
        return this;
    }

    public TimeStyleBuilder timeFormat(DateTimeStyleFormat format) {
        this.timeFormat = format;
        return this;
    }

    @Override
    public TimeStyleBuilder country(String countryCode) {
        this.dataStyleBuilder.country(countryCode);
        return this;
    }

    @Override
    public TimeStyleBuilder language(String languageCode) {
        this.dataStyleBuilder.language(languageCode);
        return this;
    }

    @Override
    public TimeStyleBuilder locale(Locale locale) {
        this.dataStyleBuilder.locale(locale);
        return this;
    }

    @Override
    public TimeStyleBuilder volatileStyle(boolean volatileStyle) {
        this.dataStyleBuilder.volatileStyle(volatileStyle);
        return this;
    }

    @Override
    public TimeStyleBuilder visible() {
        this.dataStyleBuilder.visible();
        return this;
    }
}

