/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.attribute.FormatSource;
import com.github.jferard.fastods.datastyle.CoreDataStyleBuilder;
import com.github.jferard.fastods.datastyle.DataStyleBuilder;
import com.github.jferard.fastods.datastyle.DateStyle;
import com.github.jferard.fastods.datastyle.DateTimeStyleFormat;
import java.util.Locale;

public class DateStyleBuilder
implements DataStyleBuilder<DateStyle, DateStyleBuilder> {
    private final CoreDataStyleBuilder dataStyleBuilder;
    private boolean automaticOrder;
    private FormatSource formatSource;
    private DateTimeStyleFormat dateFormat;

    public DateStyleBuilder(String name, Locale locale) {
        this.dataStyleBuilder = new CoreDataStyleBuilder(name, locale);
        this.automaticOrder = false;
        this.formatSource = FormatSource.FIXED;
        this.dateFormat = DateStyle.Format.YYYYMMDD;
    }

    public DateStyleBuilder automaticOrder(boolean automatic) {
        this.automaticOrder = automatic;
        return this;
    }

    public DateStyleBuilder formatSource(FormatSource formatSource) {
        this.formatSource = formatSource;
        return this;
    }

    @Override
    public DateStyle build() {
        return new DateStyle(this.dataStyleBuilder.build(), this.dateFormat, this.automaticOrder, this.formatSource);
    }

    public DateStyleBuilder dateFormat(DateTimeStyleFormat format) {
        this.dateFormat = format;
        return this;
    }

    @Override
    public DateStyleBuilder country(String countryCode) {
        this.dataStyleBuilder.country(countryCode);
        return this;
    }

    @Override
    public DateStyleBuilder language(String languageCode) {
        this.dataStyleBuilder.language(languageCode);
        return this;
    }

    @Override
    public DateStyleBuilder locale(Locale locale) {
        this.dataStyleBuilder.locale(locale);
        return this;
    }

    @Override
    public DateStyleBuilder volatileStyle(boolean volatileStyle) {
        this.dataStyleBuilder.volatileStyle(volatileStyle);
        return this;
    }

    @Override
    public DateStyleBuilder visible() {
        this.dataStyleBuilder.visible();
        return this;
    }
}

