/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.attribute.FormatSource;
import com.github.jferard.fastods.datastyle.CoreDataStyle;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DateTimeStyleFormat;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class DateStyle
implements DataStyle {
    private final FormatSource formatSource;
    private final boolean automaticOrder;
    private final CoreDataStyle dataStyle;
    private final DateTimeStyleFormat dateFormat;

    DateStyle(CoreDataStyle dataStyle, DateTimeStyleFormat dateFormat, boolean automaticOrder, FormatSource formatSource) {
        this.dataStyle = dataStyle;
        this.dateFormat = dateFormat;
        this.automaticOrder = automaticOrder;
        this.formatSource = formatSource;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<number:date-style");
        util.appendEAttribute(appendable, "style:name", this.dataStyle.getName());
        this.dataStyle.appendLVAttributes(util, appendable);
        util.appendAttribute(appendable, (CharSequence)"number:automatic-order", this.automaticOrder);
        if (this.formatSource != FormatSource.FIXED) {
            util.appendAttribute(appendable, (CharSequence)"number:format-source", this.formatSource);
        }
        appendable.append(">");
        this.dateFormat.appendXMLContent(util, appendable);
        appendable.append("</number:date-style>");
    }

    @Override
    public String getName() {
        return this.dataStyle.getName();
    }

    @Override
    public boolean isHidden() {
        return this.dataStyle.isHidden();
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addDataStyle(this);
    }

    public static class Format {
        public static final DateTimeStyleFormat DDMMYYYY = new DateTimeStyleFormat("<number:day number:style=\"long\"/>", "<number:text>.</number:text>", "<number:month number:style=\"long\"/>", "<number:text>.</number:text>", "<number:year number:style=\"long\"/>");
        public static final DateTimeStyleFormat DDMMYY = new DateTimeStyleFormat("<number:day number:style=\"long\"/>", "<number:text>.</number:text>", "<number:month number:style=\"long\"/>", "<number:text>.</number:text>", "<number:year/>");
        public static final DateTimeStyleFormat MMMM = new DateTimeStyleFormat("<number:month number:style=\"long\" number:textual=\"true\"/>");
        public static final DateTimeStyleFormat MMYY = new DateTimeStyleFormat("<number:month number:style=\"long\"/>", "<number:text>.</number:text>", "<number:year/>");
        public static final DateTimeStyleFormat TMMMMYYYY = new DateTimeStyleFormat("<number:day/>", "<number:text>. </number:text>", "<number:month number:style=\"long\" number:textual=\"true\"/>", "<number:text> </number:text>", "<number:year number:style=\"long\"/>");
        public static final DateTimeStyleFormat WW = new DateTimeStyleFormat("<number:week-of-year/>");
        public static final DateTimeStyleFormat YYYYMMDD = new DateTimeStyleFormat("<number:year number:style=\"long\"/>", "<number:text>-</number:text>", "<number:month number:style=\"long\"/>", "<number:text>-</number:text>", "<number:day number:style=\"long\"/>");
    }
}

