/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.attribute;

import com.github.jferard.fastods.attribute.Length;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class SimpleLength
implements Length {
    private final double value;
    private final Unit unit;

    public static SimpleLength mm(double value) {
        return new SimpleLength(value, Unit.MM);
    }

    public static SimpleLength cm(double value) {
        return new SimpleLength(value, Unit.CM);
    }

    public static SimpleLength in(double value) {
        return new SimpleLength(value, Unit.IN);
    }

    public static SimpleLength pt(double value) {
        return new SimpleLength(value, Unit.PT);
    }

    public static SimpleLength pc(double value) {
        return new SimpleLength(value, Unit.PC);
    }

    public static SimpleLength em(double value) {
        return new SimpleLength(value, Unit.EM);
    }

    SimpleLength(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleLength)) {
            return false;
        }
        SimpleLength other = (SimpleLength)o;
        if (this.unit == other.unit) {
            double delta = this.value - other.value;
            return delta >= 0.0 ? delta < 1.0E-5 : delta > -1.0E-5;
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode() * 31 + this.unit.hashCode();
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public String getValue() {
        return new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US)).format(this.value) + this.unit.toString().toLowerCase(Locale.US);
    }

    @Override
    public boolean isNotNull() {
        return this.value <= -1.0E-5 || this.value >= 1.0E-5;
    }

    public static enum Unit {
        MM,
        CM,
        IN,
        PT,
        PC,
        EM;

    }
}

