/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.TableColumn;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableColumnStyle;
import com.github.jferard.fastods.util.EqualityUtil;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TableColumnImpl
implements TableColumn {
    public static final TableColumnImpl DEFAULT_TABLE_COLUMN = new TableColumnImpl();
    private TableColumnStyle columnStyle;
    private TableCellStyle defaultCellStyle;
    private Map<String, CharSequence> customValueByAttribute;

    @Override
    public void setColumnStyle(TableColumnStyle columnStyle) {
        this.columnStyle = columnStyle;
    }

    @Override
    public void setColumnAttribute(String attribute, CharSequence value) {
        if (this.customValueByAttribute == null) {
            this.customValueByAttribute = new HashMap<String, CharSequence>();
        }
        this.customValueByAttribute.put(attribute, value);
    }

    public TableCellStyle getColumnDefaultCellStyle() {
        return this.defaultCellStyle;
    }

    @Override
    public void setColumnDefaultCellStyle(TableCellStyle defaultCellStyle) {
        this.defaultCellStyle = defaultCellStyle;
    }

    public void appendXMLToTable(XMLUtil util, Appendable appendable, int count) throws IOException {
        appendable.append("<table:table-column");
        util.appendEAttribute(appendable, "table:style-name", this.getColumnStyleName());
        if (count > 1) {
            util.appendAttribute(appendable, (CharSequence)"table:number-columns-repeated", count);
        }
        util.appendEAttribute(appendable, "table:default-cell-style-name", this.getDefaultCellStyleName());
        if (this.customValueByAttribute != null) {
            for (Map.Entry<String, CharSequence> entry : this.customValueByAttribute.entrySet()) {
                util.appendAttribute(appendable, (CharSequence)entry.getKey(), entry.getValue());
            }
        }
        appendable.append("/>");
    }

    private String getColumnStyleName() {
        if (this.columnStyle != null) {
            return this.columnStyle.getName();
        }
        return TableColumnStyle.DEFAULT_TABLE_COLUMN_STYLE.getName();
    }

    private String getDefaultCellStyleName() {
        if (this.defaultCellStyle == null) {
            return TableCellStyle.DEFAULT_CELL_STYLE.getName();
        }
        return this.defaultCellStyle.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableColumnImpl)) {
            return false;
        }
        TableColumnImpl other = (TableColumnImpl)o;
        return EqualityUtil.equal(this.columnStyle, other.columnStyle) && EqualityUtil.equal(this.customValueByAttribute, other.customValueByAttribute) && EqualityUtil.equal(this.defaultCellStyle, other.defaultCellStyle);
    }

    public int hashCode() {
        return EqualityUtil.hashObjects(this.columnStyle, this.customValueByAttribute, this.defaultCellStyle);
    }

    static {
        DEFAULT_TABLE_COLUMN.setColumnDefaultCellStyle(TableCellStyle.DEFAULT_CELL_STYLE);
    }
}

