/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.Tooltip;
import com.github.jferard.fastods.TooltipBuilder;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.util.SVGRectangle;
import com.github.jferard.fastods.util.Validation;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class TableColdCell {
    private final XMLUtil xmlUtil;
    private int columnsSpanned;
    private String currency;
    private int rowsSpanned;
    private Text text;
    private Tooltip tooltip;
    private String formula;
    private int matrixRowsSpanned;
    private int matrixColumnsSpanned;
    private Map<String, CharSequence> customValueByAttribute;
    private Validation validation;

    public static TableColdCell create(XMLUtil xmlUtil) {
        return new TableColdCell(xmlUtil);
    }

    TableColdCell(XMLUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setColumnsSpanned(int n) {
        this.columnsSpanned = n;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public void setTooltip(String tooltipText) {
        this.tooltip = Tooltip.builder(this.xmlUtil, tooltipText).build();
    }

    public void setTooltip(String tooltipText, Length width, Length height, boolean visible) {
        TooltipBuilder builder = Tooltip.builder(this.xmlUtil, tooltipText).rectangle(new SVGRectangle(null, null, width, height));
        if (visible) {
            builder.visible();
        }
        this.tooltip = builder.build();
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    public void appendXMLToTable(XMLUtil util, Appendable appendable) throws IOException {
        if (this.formula != null) {
            util.appendEAttribute(appendable, "table:formula", "of:=" + this.formula);
            if (this.matrixRowsSpanned != 0) {
                util.appendAttribute(appendable, (CharSequence)"table:number-matrix-rows-spanned", this.matrixRowsSpanned);
            }
            if (this.matrixColumnsSpanned != 0) {
                util.appendAttribute(appendable, (CharSequence)"table:number-matrix-columns-spanned", this.matrixColumnsSpanned);
            }
        }
        if (!this.isCovered()) {
            if (this.columnsSpanned != 0) {
                util.appendAttribute(appendable, (CharSequence)"table:number-columns-spanned", this.columnsSpanned);
            }
            if (this.rowsSpanned != 0) {
                util.appendAttribute(appendable, (CharSequence)"table:number-rows-spanned", this.rowsSpanned);
            }
        }
        if (this.customValueByAttribute != null) {
            for (Map.Entry<String, CharSequence> entry : this.customValueByAttribute.entrySet()) {
                util.appendAttribute(appendable, (CharSequence)entry.getKey(), entry.getValue());
            }
        }
        if (this.validation != null) {
            util.appendEAttribute(appendable, "table:content-validation-name", this.validation.getName());
        }
        if (this.text == null && this.tooltip == null) {
            appendable.append("/>");
        } else {
            appendable.append(">");
            if (this.text != null) {
                this.text.appendXMLContent(util, appendable);
            }
            if (this.tooltip != null) {
                this.tooltip.appendXMLContent(util, appendable);
            }
            if (this.isCovered()) {
                appendable.append("</table:covered-table-cell>");
            } else {
                appendable.append("</table:table-cell>");
            }
        }
    }

    public boolean isCovered() {
        return this.columnsSpanned == -1;
    }

    public void setCovered() {
        this.columnsSpanned = -1;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public void setRowsSpanned(int n) {
        this.rowsSpanned = n;
    }

    public void setMatrixRowsSpanned(int n) {
        this.matrixRowsSpanned = n;
    }

    public void setMatrixColumnsSpanned(int n) {
        this.matrixColumnsSpanned = n;
    }

    public void setAttribute(String attribute, CharSequence value) {
        if (this.customValueByAttribute == null) {
            this.customValueByAttribute = new HashMap<String, CharSequence>();
        }
        this.customValueByAttribute.put(attribute, value);
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }
}

