/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Link;
import com.github.jferard.fastods.Paragraph;
import com.github.jferard.fastods.ParagraphElement;
import com.github.jferard.fastods.Span;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.style.TextStyle;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ParagraphBuilder {
    private final List<ParagraphElement> paragraphElements = new ArrayList<ParagraphElement>();
    private TextStyle style;

    ParagraphBuilder() {
    }

    public Paragraph build() {
        return new Paragraph(this.paragraphElements, this.style);
    }

    public ParagraphBuilder span(String text) {
        Span paragraphElement = new Span(text);
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder link(String text, String ref) {
        Link paragraphElement = Link.builder(text).to(ref).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder styledLink(String text, TextStyle ts, String ref) {
        Link paragraphElement = Link.builder(text).style(ts).to(ref).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder link(String text, Table table) {
        Link paragraphElement = Link.builder(text).to(table).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder styledLink(String text, TextStyle ts, Table table) {
        Link paragraphElement = Link.builder(text).style(ts).to(table).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder link(String text, File file) {
        Link paragraphElement = Link.builder(text).to(file).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder styledLink(String text, TextStyle ts, File file) {
        Link paragraphElement = Link.builder(text).style(ts).to(file).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder link(String text, URL url) {
        Link paragraphElement = Link.builder(text).to(url).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder styledLink(String text, TextStyle ts, URL url) {
        Link paragraphElement = Link.builder(text).style(ts).to(url).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder link(String text, URI uri) {
        Link paragraphElement = Link.builder(text).to(uri).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder styledLink(String text, TextStyle ts, URI uri) {
        Link paragraphElement = Link.builder(text).style(ts).to(uri).build();
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder style(TextStyle ts) {
        this.style = ts;
        return this;
    }

    public ParagraphBuilder styledSpan(String text, TextStyle ts) {
        Span paragraphElement = new Span(text, ts);
        this.paragraphElements.add(paragraphElement);
        return this;
    }

    public ParagraphBuilder element(ParagraphElement element) {
        this.paragraphElements.add(element);
        return this;
    }
}

