/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.NamedOdsDocument;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsFileDirectWriter;
import com.github.jferard.fastods.util.FileOpen;
import com.github.jferard.fastods.util.FileOpenResult;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import com.github.jferard.fastods.util.ZipUTF8WriterBuilderImpl;
import com.github.jferard.fastods.util.ZipUTF8WriterImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class OdsFileWriterBuilder {
    private final Logger logger;
    private final NamedOdsDocument document;
    private OutputStream out;
    private ZipUTF8WriterBuilderImpl builder;

    OdsFileWriterBuilder(Logger logger, NamedOdsDocument document) {
        this.logger = logger;
        this.document = document;
        this.builder = ZipUTF8WriterImpl.builder();
    }

    public NamedOdsFileWriter build() {
        ZipUTF8Writer writer = this.builder.build(this.out);
        return new OdsFileDirectWriter(this.logger, XMLUtil.create(), this.document, writer);
    }

    public OdsFileWriterBuilder file(String filename) throws FileNotFoundException {
        return this.openResult(FileOpen.openFile(filename));
    }

    public OdsFileWriterBuilder file(File file) throws FileNotFoundException {
        return this.openResult(FileOpen.openFile(file));
    }

    public OdsFileWriterBuilder outputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public OdsFileWriterBuilder openResult(FileOpenResult lockResult) throws FileNotFoundException {
        this.out = lockResult.getStream();
        return this;
    }

    public OdsFileWriterBuilder zipBuilder(ZipUTF8WriterBuilderImpl builder) {
        this.builder = builder;
        return this;
    }
}

