/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.DrawFrameBuilder;
import com.github.jferard.fastods.FrameContent;
import com.github.jferard.fastods.Shape;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.GraphicStyle;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.SVGRectangle;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class DrawFrame
implements Shape {
    private final FrameContent content;
    private final SVGRectangle rectangle;
    private final int zIndex;
    private final GraphicStyle drawStyle;
    private final TextStyle textStyle;
    private final String name;

    public static DrawFrameBuilder builder(String name, FrameContent content, SVGRectangle rectangle) {
        return new DrawFrameBuilder(name, content, rectangle);
    }

    DrawFrame(String name, FrameContent content, SVGRectangle rectangle, int zIndex, GraphicStyle drawStyle, TextStyle textStyle) {
        this.name = name;
        this.content = content;
        this.rectangle = rectangle;
        this.zIndex = zIndex;
        this.drawStyle = drawStyle;
        this.textStyle = textStyle;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<draw:frame");
        this.appendAttributes(util, appendable);
        appendable.append(">");
        this.content.appendXMLContent(util, appendable);
        appendable.append("</draw:frame>");
    }

    private void appendAttributes(XMLUtil util, Appendable appendable) throws IOException {
        util.appendAttribute(appendable, (CharSequence)"draw:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"draw:z-index", this.zIndex);
        if (this.drawStyle != null) {
            util.appendAttribute(appendable, (CharSequence)"draw:style-name", this.drawStyle.getName());
        }
        if (this.textStyle != null) {
            util.appendAttribute(appendable, (CharSequence)"draw:text-style-name", this.textStyle.getName());
        }
        this.rectangle.appendXMLContent(util, appendable);
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        if (this.drawStyle != null) {
            stylesContainer.addContentStyle(this.drawStyle);
        }
        if (this.textStyle != null) {
            stylesContainer.addContentStyle(this.textStyle);
        }
    }
}

