/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class FastOdsBus<E> {
    private final Queue<E> elements = new LinkedList();
    private boolean closed = false;

    public void close() {
        this.closed = true;
    }

    public synchronized E get() {
        if (this.isClosed()) {
            throw new NoSuchElementException();
        }
        while (this.elements.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return this.elements.remove();
    }

    public synchronized boolean isClosed() {
        return this.closed && this.elements.isEmpty();
    }

    public synchronized void put(E element) {
        if (this.closed) {
            throw new IllegalStateException("Bus is closed");
        }
        this.elements.add(element);
        this.notifyAll();
    }
}

