/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.style.FontFace;
import com.github.jferard.fastods.style.FontFaceContainerStyle;
import com.github.jferard.fastods.style.ObjectStyleFamily;
import com.github.jferard.fastods.style.TableStyleBuilder;
import com.github.jferard.fastods.style.TextProperties;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class TextStyle
implements FontFaceContainerStyle {
    public static final TextStyle DEFAULT_TEXT_STYLE = TextProperties.builder().buildStyle("Default");
    private final String name;
    private final boolean hidden;
    private final TextProperties textProperties;
    private String key;

    TextStyle(String name, boolean hidden, TextProperties textProperties) {
        this.name = TableStyleBuilder.checker.checkStyleName(name);
        this.hidden = hidden;
        this.textProperties = textProperties;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:style");
        util.appendEAttribute(appendable, "style:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"style:family", "text");
        appendable.append(">");
        this.textProperties.appendXMLContent(util, appendable);
        appendable.append("</style:style>");
    }

    @Override
    public FontFace getFontFace() {
        return this.textProperties.getFontFace();
    }

    @Override
    public ObjectStyleFamily getFamily() {
        return ObjectStyleFamily.TEXT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isNotEmpty() {
        return this.textProperties.isNotEmpty();
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = (Object)((Object)this.getFamily()) + "@" + this.getName();
        }
        return this.key;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        throw new UnsupportedOperationException();
    }
}

