/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.FontFace;
import com.github.jferard.fastods.style.FontFaceContainerStyle;
import com.github.jferard.fastods.style.ObjectStyleFamily;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableRowStyleBuilder;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class TableRowStyle
implements FontFaceContainerStyle {
    public static final TableRowStyle DEFAULT_TABLE_ROW_STYLE = TableRowStyle.builder("ro1").build();
    private final String name;
    private final boolean hidden;
    private final Length rowHeight;
    private final TableCellStyle defaultCellStyle;
    private final boolean optimalHeight;
    private String key;

    public static TableRowStyleBuilder builder(String name) {
        return new TableRowStyleBuilder(name);
    }

    TableRowStyle(String styleName, boolean hidden, Length rowHeight, TableCellStyle defaultCellStyle, boolean optimalHeight) {
        this.name = styleName;
        this.hidden = hidden;
        this.rowHeight = rowHeight;
        this.defaultCellStyle = defaultCellStyle;
        this.optimalHeight = optimalHeight;
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addContentStyle(this);
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:style");
        util.appendAttribute(appendable, (CharSequence)"style:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"style:family", "table-row");
        appendable.append("><style:table-row-properties");
        if (this.optimalHeight) {
            util.appendAttribute(appendable, (CharSequence)"style:use-optimal-row-width", this.optimalHeight);
        } else if (this.rowHeight.isNotNull()) {
            util.appendAttribute(appendable, (CharSequence)"style:row-height", this.rowHeight);
        }
        util.appendAttribute(appendable, (CharSequence)"fo:break-before", "auto");
        util.appendAttribute(appendable, (CharSequence)"style:use-optimal-row-height", "true");
        appendable.append("/></style:style>");
    }

    @Override
    public ObjectStyleFamily getFamily() {
        return ObjectStyleFamily.TABLE_ROW;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Length getRowHeight() {
        return this.rowHeight;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = (Object)((Object)this.getFamily()) + "@" + this.getName();
        }
        return this.key;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public FontFace getFontFace() {
        if (this.defaultCellStyle == null) {
            return null;
        }
        return this.defaultCellStyle.getFontFace();
    }

    public TableCellStyle getDefaultCellStyle() {
        return this.defaultCellStyle;
    }

    public void addToContentStyles(StylesContainer stylesContainer) {
        stylesContainer.addContentFontFaceContainerStyle(this);
        stylesContainer.addContentStyle(this);
        TableCellStyle defaultCellStyle = this.getDefaultCellStyle();
        if (defaultCellStyle != null) {
            stylesContainer.addStylesFontFaceContainerStyle(defaultCellStyle);
            stylesContainer.addContentStyle(defaultCellStyle);
        }
    }
}

