/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.attribute.SimpleLength;
import com.github.jferard.fastods.style.ShowableBuilder;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableColumnStyle;
import com.github.jferard.fastods.style.TableStyleBuilder;
import com.github.jferard.fastods.util.StyleBuilder;

public class TableColumnStyleBuilder
implements StyleBuilder<TableColumnStyle>,
ShowableBuilder<TableColumnStyleBuilder> {
    private static final Length DEFAULT_COLUMN_WIDTH = SimpleLength.cm(2.5);
    private final String name;
    private Length columnWidth;
    private TableCellStyle defaultCellStyle;
    private boolean hidden;
    private boolean optimalWidth;

    TableColumnStyleBuilder(String name) {
        this.name = TableStyleBuilder.checker.checkStyleName(name);
        this.columnWidth = DEFAULT_COLUMN_WIDTH;
        this.defaultCellStyle = TableCellStyle.DEFAULT_CELL_STYLE;
        this.optimalWidth = false;
        this.hidden = true;
    }

    @Override
    public TableColumnStyle build() {
        return new TableColumnStyle(this.name, this.hidden, this.columnWidth, this.defaultCellStyle, this.optimalWidth);
    }

    public TableColumnStyleBuilder columnWidth(Length width) {
        this.columnWidth = width;
        this.optimalWidth = false;
        return this;
    }

    public TableColumnStyleBuilder defaultCellStyle(TableCellStyle defaultCellStyle) {
        this.defaultCellStyle = defaultCellStyle;
        return this;
    }

    @Deprecated
    public TableColumnStyleBuilder optimalWidth() {
        this.optimalWidth = true;
        this.columnWidth = Length.NULL_LENGTH;
        return this;
    }

    @Override
    public TableColumnStyleBuilder visible() {
        this.hidden = false;
        return this;
    }
}

