/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.attribute.CellType;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.FlushPosition;
import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.ScriptEventListener;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.StylesContainerImpl;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.AutoFilter;
import com.github.jferard.fastods.util.PilotTable;
import com.github.jferard.fastods.util.UniqueList;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;

public class ContentElement
implements OdsElement {
    private final FlushPosition flushPosition;
    private final DataStyles format;
    private final PositionUtil positionUtil;
    private final StylesContainerImpl stylesContainer;
    private final UniqueList<Table> tables;
    private final WriteUtil writeUtil;
    private final XMLUtil xmlUtil;
    private final boolean libreOfficeMode;
    private List<AutoFilter> autoFilters;
    private final List<ScriptEventListener> scriptEvents;
    private List<PilotTable> pilotTables;

    ContentElement(PositionUtil positionUtil, XMLUtil xmlUtil, WriteUtil writeUtil, DataStyles format, boolean libreOfficeMode, StylesContainerImpl stylesContainer) {
        this.writeUtil = writeUtil;
        this.xmlUtil = xmlUtil;
        this.positionUtil = positionUtil;
        this.format = format;
        this.libreOfficeMode = libreOfficeMode;
        this.stylesContainer = stylesContainer;
        this.tables = new UniqueList();
        this.flushPosition = new FlushPosition();
        this.scriptEvents = new ArrayList<ScriptEventListener>();
    }

    public TableCellStyle addChildCellStyle(TableCellStyle style, CellType type) {
        DataStyle dataStyle = this.format.getDataStyle(type);
        TableCellStyle newStyle = dataStyle == null ? style : this.stylesContainer.addChildCellStyle(style, dataStyle);
        return newStyle;
    }

    public Table addTable(String name, int rowCapacity, int columnCapacity) {
        Table table = this.tables.getByName(name);
        if (table == null) {
            table = Table.create(this, this.positionUtil, this.writeUtil, this.xmlUtil, name, rowCapacity, columnCapacity, this.stylesContainer, this.format, this.libreOfficeMode);
            this.tables.add(table);
        }
        return table;
    }

    public Table getLastTable() {
        int size = this.tables.size();
        return size <= 0 ? null : (Table)this.tables.get(size - 1);
    }

    public StylesContainer getStyleTagsContainer() {
        return this.stylesContainer;
    }

    public Table getTable(int tableIndex) {
        return (Table)this.tables.get(tableIndex);
    }

    public Table getTable(String name) {
        return this.tables.getByName(name);
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public List<Table> getTables() {
        return this.tables;
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        this.writePreamble(util, writer);
        for (Table table : this.tables) {
            table.appendXMLToContentEntry(util, writer);
        }
        this.writePostamble(util, writer);
    }

    public void writePostamble(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        if (this.autoFilters != null) {
            this.appendAutoFilters(util, writer);
        }
        if (this.pilotTables != null) {
            this.appendPilotTables(util, writer);
        }
        writer.write("</office:spreadsheet>");
        writer.write("</office:body>");
        writer.write("</office:document-content>");
        writer.flush();
        writer.closeEntry();
    }

    public void writePreamble(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putNextEntry(new ZipEntry("content.xml"));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("<office:document-content xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:ooow=\"http://openoffice.org/2004/writer\" xmlns:oooc=\"http://openoffice.org/2004/calc\" xmlns:dom=\"http://www.w3.org/2001/xml-events\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:of=\"urn:oasis:names:tc:opendocument:xmlns:of:1.2\" office:version=\"1.2\">");
        this.writeEvents(util, writer);
        this.stylesContainer.writeFontFaceDecls(util, writer);
        writer.write("<office:automatic-styles>");
        this.stylesContainer.writeHiddenDataStyles(util, writer);
        this.stylesContainer.writeContentAutomaticStyles(util, writer);
        writer.write("</office:automatic-styles>");
        writer.write("<office:body>");
        writer.write("<office:spreadsheet>");
    }

    public void writeEvents(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        if (this.scriptEvents.isEmpty()) {
            return;
        }
        writer.write("<office:scripts><office:event-listeners>");
        for (ScriptEventListener event : this.scriptEvents) {
            event.appendXMLContent(util, writer);
        }
        writer.write("</office:event-listeners></office:scripts>");
    }

    private void appendAutoFilters(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:database-ranges>");
        for (AutoFilter autoFilter : this.autoFilters) {
            autoFilter.appendXMLContent(util, appendable);
        }
        appendable.append("</table:database-ranges>");
    }

    private void appendPilotTables(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:data-pilot-tables>");
        for (PilotTable pilotTable : this.pilotTables) {
            pilotTable.appendXMLContent(util, appendable);
        }
        appendable.append("</table:data-pilot-tables>");
    }

    public void addAutoFilter(AutoFilter autoFilter) {
        if (this.autoFilters == null) {
            this.autoFilters = new ArrayList<AutoFilter>();
        }
        this.autoFilters.add(autoFilter);
    }

    public void addEvents(ScriptEventListener ... events) {
        this.scriptEvents.addAll(Arrays.asList(events));
    }

    public void addPilotTable(PilotTable pilotTable) {
        if (this.pilotTables == null) {
            this.pilotTables = new ArrayList<PilotTable>();
        }
        this.pilotTables.add(pilotTable);
    }
}

