/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.attribute;

import com.github.jferard.fastods.attribute.AttributeValue;

public class Angle
implements AttributeValue {
    public static final Angle NO_ROTATING = Angle.deg(0.0);
    public static final Angle ROTATE_90 = Angle.deg(90.0);
    public static final Angle ROTATE_180 = Angle.deg(180.0);
    public static final Angle ROTATE_270 = Angle.deg(270.0);
    private final double value;
    private final Unit unit;

    public static Angle deg(double degs) {
        return new Angle(degs, Unit.DEG);
    }

    public static Angle grad(double grads) {
        return new Angle(grads, Unit.GRAD);
    }

    public static Angle rad(double rads) {
        return new Angle(rads, Unit.RAD);
    }

    public Angle(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public String getValue() {
        String ret = "";
        switch (this.unit) {
            case DEG: {
                ret = String.valueOf((int)this.value);
                break;
            }
            case GRAD: {
                ret = this.value + "grad";
                break;
            }
            case RAD: {
                ret = this.value + "rad";
            }
        }
        return ret;
    }

    public static enum Unit {
        DEG,
        GRAD,
        RAD;

    }
}

