/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.TableColdCell;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.attribute.CellType;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TableCellImpl
implements TableCell {
    static final SimpleDateFormat DATE_VALUE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final TableRowImpl parentRow;
    private final WriteUtil writeUtil;
    private final XMLUtil xmlUtil;
    private final StylesContainer stylesContainer;
    private final DataStyles dataStyles;
    private final boolean libreOfficeMode;
    private final int columnIndex;
    private TableCellStyle style;
    private CellType type;
    private TableColdCell coldCell;
    private String value;

    TableCellImpl(WriteUtil writeUtil, XMLUtil xmlUtil, StylesContainer stylesContainer, DataStyles dataStyles, boolean libreOfficeMode, TableRowImpl parentRow, int columnIndex) {
        this.writeUtil = writeUtil;
        this.stylesContainer = stylesContainer;
        this.xmlUtil = xmlUtil;
        this.dataStyles = dataStyles;
        this.libreOfficeMode = libreOfficeMode;
        this.parentRow = parentRow;
        this.columnIndex = columnIndex;
    }

    public void appendXMLToTableRow(XMLUtil util, Appendable appendable) throws IOException {
        boolean covered = this.isCovered();
        if (covered) {
            appendable.append("<table:covered-table-cell");
        } else {
            appendable.append("<table:table-cell");
        }
        if (this.style != null) {
            util.appendEAttribute(appendable, "table:style-name", this.style.getName());
        } else if (this.libreOfficeMode) {
            util.appendEAttribute(appendable, "table:style-name", this.getCurCellStyle().getName());
        }
        if (this.type != null) {
            util.appendAttribute(appendable, (CharSequence)"office:value-type", this.type);
            util.appendEAttribute(appendable, this.type.getValueType(), this.value);
            if (this.type == CellType.CURRENCY) {
                String currency = this.getCurrency();
                util.appendEAttribute(appendable, "office:currency", currency);
            }
        }
        if (this.hasColdCell()) {
            this.coldCell.appendXMLToTable(util, appendable);
        } else {
            appendable.append("/>");
        }
    }

    @Override
    public boolean isCovered() {
        return this.hasColdCell() && this.coldCell.isCovered();
    }

    private boolean hasColdCell() {
        return this.coldCell != null;
    }

    @Override
    public void setCovered() {
        this.ensureColdCell();
        this.coldCell.setCovered();
    }

    @Override
    public void setColumnsSpanned(int n) {
        this.parentRow.setColumnsSpanned(this.columnIndex, n);
    }

    @Override
    public void markColumnsSpanned(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Can't mark a negative number of columns");
        }
        if (n <= 1) {
            return;
        }
        this.ensureColdCell();
        this.coldCell.setColumnsSpanned(n);
    }

    @Override
    public void setRowsSpanned(int n) throws IOException {
        this.parentRow.setRowsSpanned(this.columnIndex, n);
    }

    @Override
    public void markRowsSpanned(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Can't mark a negative number of rows");
        }
        if (n <= 1) {
            return;
        }
        this.ensureColdCell();
        this.coldCell.setRowsSpanned(n);
    }

    private String getCurrency() {
        assert (this.coldCell != null);
        return this.coldCell.getCurrency();
    }

    @Override
    public void setBooleanValue(boolean value) {
        this.value = value ? "true" : "false";
        this.type = CellType.BOOLEAN;
        this.setImplicitDataStyle(this.dataStyles.getBooleanDataStyle());
    }

    @Override
    public void setCellValue(CellValue value) {
        value.setToCell(this);
    }

    @Override
    public void setCurrencyValue(float value, String currency) {
        this.setCurrencyValue(Float.toString(value), currency);
    }

    private void setCurrencyValue(String valueAsString, String currency) {
        this.value = valueAsString;
        this.type = CellType.CURRENCY;
        this.setImplicitDataStyle(this.dataStyles.getCurrencyDataStyle());
        this.ensureColdCell();
        this.coldCell.setCurrency(currency);
    }

    @Override
    public void setCurrencyValue(int value, String currency) {
        this.setCurrencyValue(Integer.toString(value), currency);
    }

    @Override
    public void setCurrencyValue(Number value, String currency) {
        this.setCurrencyValue(value.toString(), currency);
    }

    private void ensureColdCell() {
        if (this.coldCell == null) {
            this.coldCell = TableColdCell.create(this.xmlUtil);
        }
    }

    @Override
    public void setDataStyle(DataStyle dataStyle) {
        if (dataStyle == null) {
            return;
        }
        this.stylesContainer.addDataStyle(dataStyle);
        TableCellStyle curStyle = this.getCurCellStyle();
        DataStyle curDataStyle = curStyle.getDataStyle();
        this.style = curDataStyle == null ? this.stylesContainer.addChildCellStyle(curStyle, dataStyle) : this.stylesContainer.addChildCellStyle(curStyle.getParentCellStyle(), dataStyle);
    }

    @Override
    public int colIndex() {
        return this.columnIndex;
    }

    private void setImplicitDataStyle(DataStyle dataStyle) {
        assert (dataStyle != null);
        TableCellStyle curStyle = this.getCurCellStyle();
        DataStyle curDataStyle = curStyle.getDataStyle();
        if (curDataStyle == null) {
            this.stylesContainer.addDataStyle(dataStyle);
            this.style = this.stylesContainer.addChildCellStyle(curStyle, dataStyle);
        } else {
            this.stylesContainer.addDataStyle(curDataStyle);
            this.style = this.stylesContainer.addChildCellStyle(curStyle.getParentCellStyle(), curDataStyle);
        }
    }

    private TableCellStyle getCurCellStyle() {
        if (this.style == null) {
            return this.parentRow.findDefaultCellStyle(this.columnIndex);
        }
        return this.style;
    }

    @Override
    public void setDateValue(Calendar cal) {
        this.setDateValue(cal.getTime());
    }

    @Override
    public void setDateValue(Date value) {
        this.value = DATE_VALUE_FORMAT.format(value);
        this.type = CellType.DATE;
        this.setImplicitDataStyle(this.dataStyles.getDateDataStyle());
    }

    private void setFloatValue(String valueAsString) {
        this.value = valueAsString;
        this.type = CellType.FLOAT;
        this.setImplicitDataStyle(this.dataStyles.getFloatDataStyle());
    }

    @Override
    public void setFloatValue(float value) {
        this.setFloatValue(Float.toString(value));
    }

    @Override
    public void setFloatValue(int value) {
        this.setFloatValue(this.writeUtil.toString(value));
    }

    @Override
    public void setFloatValue(Number value) {
        this.setFloatValue(value.toString());
    }

    @Override
    public void setPercentageValue(int value) {
        this.setPercentageValue(Integer.toString(value));
    }

    private void setPercentageValue(String valueAsString) {
        this.value = valueAsString;
        this.type = CellType.PERCENTAGE;
        this.setImplicitDataStyle(this.dataStyles.getPercentageDataStyle());
    }

    @Override
    public void setPercentageValue(float value) {
        this.setPercentageValue(Float.toString(value));
    }

    @Override
    public void setPercentageValue(Number value) {
        this.setPercentageValue(value.toString());
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
        this.type = CellType.STRING;
    }

    @Override
    public void setStyle(TableCellStyle style) {
        DataStyle dataStyle;
        if (style == null) {
            return;
        }
        this.stylesContainer.addContentFontFaceContainerStyle(style);
        TableCellStyle curStyle = this.style;
        this.style = curStyle == null ? style : ((dataStyle = curStyle.getDataStyle()) == null ? style : this.stylesContainer.addChildCellStyle(style, dataStyle));
    }

    @Override
    public void setText(Text text) {
        this.ensureColdCell();
        this.coldCell.setText(text);
        this.value = "";
        this.type = CellType.STRING;
        text.addEmbeddedStylesFromCell(this.stylesContainer);
    }

    @Override
    public void setCellMerge(int rowMerge, int columnMerge) throws IOException {
        this.parentRow.setCellMerge(this.columnIndex, rowMerge, columnMerge);
    }

    @Override
    public void setTimeValue(long timeInMillis) {
        this.value = timeInMillis < 0L ? this.xmlUtil.formatNegTimeInterval(0L, 0L, 0L, 0L, 0L, (double)(-timeInMillis) / 1000.0) : this.xmlUtil.formatTimeInterval(0L, 0L, 0L, 0L, 0L, (double)timeInMillis / 1000.0);
        this.type = CellType.TIME;
        this.setImplicitDataStyle(this.dataStyles.getTimeDataStyle());
    }

    @Override
    public void setTimeValue(long years, long months, long days, long hours, long minutes, double seconds) {
        this.value = this.xmlUtil.formatTimeInterval(years, months, days, hours, minutes, seconds);
        this.type = CellType.TIME;
        this.setImplicitDataStyle(this.dataStyles.getTimeDataStyle());
    }

    @Override
    public void setNegTimeValue(long years, long months, long days, long hours, long minutes, double seconds) {
        this.value = this.xmlUtil.formatNegTimeInterval(years, months, days, hours, minutes, seconds);
        this.type = CellType.TIME;
        this.setImplicitDataStyle(this.dataStyles.getTimeDataStyle());
    }

    @Override
    public void setTooltip(String tooltip) {
        this.ensureColdCell();
        this.coldCell.setTooltip(tooltip);
    }

    @Override
    public void setTooltip(String tooltip, Length width, Length height, boolean visible) {
        this.ensureColdCell();
        this.coldCell.setTooltip(tooltip, width, height, visible);
    }

    @Override
    public void setVoidValue() {
        this.value = "";
        this.type = CellType.VOID;
    }

    @Override
    public void setFormula(String formula) {
        this.ensureColdCell();
        this.coldCell.setFormula(formula);
    }

    @Override
    public void setMatrixFormula(String formula) {
        this.ensureColdCell();
        this.coldCell.setFormula(formula);
        this.coldCell.setMatrixRowsSpanned(1);
        this.coldCell.setMatrixColumnsSpanned(1);
    }

    @Override
    public void setMatrixFormula(String formula, int matrixRowsSpanned, int matrixColumnsSpanned) {
        this.ensureColdCell();
        this.coldCell.setFormula(formula);
        this.coldCell.setMatrixRowsSpanned(matrixRowsSpanned);
        this.coldCell.setMatrixColumnsSpanned(matrixColumnsSpanned);
    }

    @Override
    public boolean hasValue() {
        return this.value != null || this.hasColdCell();
    }

    static {
        DATE_VALUE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

