/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.AnonymousOdsDocument;
import com.github.jferard.fastods.AnonymousOdsFileWriter;
import com.github.jferard.fastods.NamedOdsDocument;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsFileDirectWriter;
import com.github.jferard.fastods.OdsFileWriterAdapter;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.datastyle.DataStylesBuilder;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.util.FileExists;
import com.github.jferard.fastods.util.FileOpen;
import com.github.jferard.fastods.util.FileOpenResult;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8WriterBuilder;
import com.github.jferard.fastods.util.ZipUTF8WriterImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;

public class OdsFactory {
    private final Logger logger;
    private final PositionUtil positionUtil;
    private final WriteUtil writeUtil;
    private final XMLUtil xmlUtil;
    private DataStyles format;
    private boolean libreOfficeMode;

    public static OdsFactory create() {
        return OdsFactory.create(Logger.getLogger(NamedOdsDocument.class.getName()), Locale.getDefault());
    }

    public static OdsFactory create(Logger logger, Locale locale) {
        PositionUtil positionUtil = new PositionUtil(new TableNameUtil());
        WriteUtil writeUtil = WriteUtil.create();
        XMLUtil xmlUtil = XMLUtil.create();
        DataStyles format = DataStylesBuilder.create(locale).build();
        return new OdsFactory(logger, positionUtil, writeUtil, xmlUtil, format, true);
    }

    OdsFactory(Logger logger, PositionUtil positionUtil, WriteUtil writeUtil, XMLUtil xmlUtil, DataStyles format, boolean libreOfficeMode) {
        this.logger = logger;
        this.positionUtil = positionUtil;
        this.writeUtil = writeUtil;
        this.xmlUtil = xmlUtil;
        this.format = format;
        this.libreOfficeMode = libreOfficeMode;
    }

    public OdsFactory dataStyles(DataStyles ds) {
        this.format = ds;
        return this;
    }

    public OdsFactory noLibreOfficeMode() {
        this.libreOfficeMode = false;
        return this;
    }

    private AnonymousOdsDocument createAnonymousDocument() {
        OdsElements odsElements = OdsElements.create(this.positionUtil, this.xmlUtil, this.writeUtil, this.format, this.libreOfficeMode);
        return AnonymousOdsDocument.create(this.logger, this.xmlUtil, odsElements);
    }

    private NamedOdsDocument createNamedDocument() {
        OdsElements odsElements = OdsElements.create(this.positionUtil, this.xmlUtil, this.writeUtil, this.format, this.libreOfficeMode);
        return NamedOdsDocument.create(this.logger, this.xmlUtil, odsElements);
    }

    public AnonymousOdsFileWriter createWriter() {
        AnonymousOdsDocument document = this.createAnonymousDocument();
        return new AnonymousOdsFileWriter(this.logger, document);
    }

    public NamedOdsFileWriter createWriter(String filename) throws IOException {
        NamedOdsDocument document = this.createNamedDocument();
        NamedOdsFileWriter writer = OdsFileDirectWriter.builder(this.logger, document).openResult(this.openFile(filename)).build();
        document.addObserver(writer);
        document.prepare();
        return writer;
    }

    public NamedOdsFileWriter createWriter(File file) throws IOException {
        NamedOdsDocument document = this.createNamedDocument();
        NamedOdsFileWriter writer = OdsFileDirectWriter.builder(this.logger, document).openResult(this.openFile(file)).build();
        document.addObserver(writer);
        document.prepare();
        return writer;
    }

    public OdsFileWriterAdapter createWriterAdapter(File file) throws IOException {
        NamedOdsDocument document = this.createNamedDocument();
        ZipUTF8WriterBuilder zipUTF8Writer = ZipUTF8WriterImpl.builder().noWriterBuffer();
        OdsFileWriterAdapter writerAdapter = OdsFileWriterAdapter.create(this.logger, OdsFileDirectWriter.builder(this.logger, document).openResult(this.openFile(file)).zipBuilder(zipUTF8Writer).build());
        document.addObserver(writerAdapter);
        document.prepare();
        return writerAdapter;
    }

    public FileOpenResult openFile(File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            return FileOpenResult.FILE_IS_DIR;
        }
        if (file.exists()) {
            return new FileExists(file);
        }
        return new FileOpen(new FileOutputStream(file));
    }

    public FileOpenResult openFile(String filename) throws FileNotFoundException {
        File f = new File(filename);
        return this.openFile(f);
    }

    @Deprecated
    public static enum FileState {
        IS_DIRECTORY,
        FILE_EXISTS,
        OK;

    }
}

