/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.BooleanValue;
import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.CurrencyValue;
import com.github.jferard.fastods.DateValue;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.FloatValue;
import com.github.jferard.fastods.PercentageValue;
import com.github.jferard.fastods.StringValue;
import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.TextValue;
import com.github.jferard.fastods.TimeValue;
import com.github.jferard.fastods.ToCellValueConverter;
import com.github.jferard.fastods.VoidValue;
import com.github.jferard.fastods.attribute.CellType;
import java.util.Calendar;
import java.util.Date;

public class ObjectToCellValueConverter
implements ToCellValueConverter {
    private final String currency;

    public ObjectToCellValueConverter(String currency) {
        this.currency = currency;
    }

    @Override
    public CellValue from(Object o) {
        if (o == null) {
            return VoidValue.INSTANCE;
        }
        if (o instanceof String) {
            return new StringValue((String)o);
        }
        if (o instanceof Text) {
            return new TextValue((Text)o);
        }
        if (o instanceof Number) {
            return new FloatValue((Number)o);
        }
        if (o instanceof Boolean) {
            return new BooleanValue((Boolean)o);
        }
        if (o instanceof Date) {
            return new DateValue((Date)o);
        }
        if (o instanceof Calendar) {
            return new DateValue(((Calendar)o).getTime());
        }
        if (o instanceof CellValue) {
            return (CellValue)o;
        }
        return new StringValue(o.toString());
    }

    @Override
    public CellValue from(CellType type, Object o) throws FastOdsException {
        switch (type) {
            case BOOLEAN: {
                return BooleanValue.from(o);
            }
            case CURRENCY: {
                return CurrencyValue.from(o, this.currency);
            }
            case DATE: {
                return DateValue.from(o);
            }
            case FLOAT: {
                return FloatValue.from(o);
            }
            case PERCENTAGE: {
                return PercentageValue.from(o);
            }
            case STRING: {
                return StringValue.from(o);
            }
            case TIME: {
                return TimeValue.from(o);
            }
            case VOID: {
                return VoidValue.from(o);
            }
        }
        throw new FastOdsException("Should not happen!");
    }
}

