/*
 * Decompiled with CFR 0.152.
 */
package dev.jeziellago.compose.markdowntext.plugins.core;

import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import dev.jeziellago.compose.markdowntext.plugins.core.MardownCorePlugin;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.RenderProps;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.core.CorePlugin;
import io.noties.markwon.core.CoreProps;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.core.SimpleBlockNodeVisitor;
import io.noties.markwon.core.factory.BlockQuoteSpanFactory;
import io.noties.markwon.core.factory.CodeBlockSpanFactory;
import io.noties.markwon.core.factory.CodeSpanFactory;
import io.noties.markwon.core.factory.EmphasisSpanFactory;
import io.noties.markwon.core.factory.HeadingSpanFactory;
import io.noties.markwon.core.factory.LinkSpanFactory;
import io.noties.markwon.core.factory.ListItemSpanFactory;
import io.noties.markwon.core.factory.StrongEmphasisSpanFactory;
import io.noties.markwon.core.factory.ThematicBreakSpanFactory;
import io.noties.markwon.image.ImageProps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0012\u001a\u00020/2\u0006\u0010$\u001a\u00020%H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldev/jeziellago/compose/markdowntext/plugins/core/MardownCorePlugin;", "Lio/noties/markwon/core/CorePlugin;", "syntaxHighlightColor", "", "syntaxHighlightTextColor", "enableUnderlineForLink", "", "onTextAddedListeners", "", "Lio/noties/markwon/core/CorePlugin$OnTextAddedListener;", "(IIZLjava/util/List;)V", "addOnTextAddedListener", "onTextAddedListener", "blockQuote", "", "builder", "Lio/noties/markwon/MarkwonVisitor$Builder;", "bulletList", "code", "configureSpansFactory", "Lio/noties/markwon/MarkwonSpansFactory$Builder;", "configureTheme", "Lio/noties/markwon/core/MarkwonTheme$Builder;", "configureVisitor", "emphasis", "fencedCodeBlock", "hardLineBreak", "heading", "image", "indentedCodeBlock", "isInTightList", "paragraph", "Lorg/commonmark/node/Paragraph;", "link", "listItem", "listLevel", "node", "Lorg/commonmark/node/Node;", "orderedList", "softLineBreak", "strongEmphasis", "text", "thematicBreak", "visitCodeBlock", "visitor", "Lio/noties/markwon/MarkwonVisitor;", "info", "", "markdowntext_release"})
@StabilityInferred(parameters=0)
public final class MardownCorePlugin
extends CorePlugin {
    private final int syntaxHighlightColor;
    private final int syntaxHighlightTextColor;
    private final boolean enableUnderlineForLink;
    @NotNull
    private final List<CorePlugin.OnTextAddedListener> onTextAddedListeners;
    public static final int $stable = 8;

    public MardownCorePlugin(int syntaxHighlightColor, int syntaxHighlightTextColor, boolean enableUnderlineForLink, @NotNull List<CorePlugin.OnTextAddedListener> onTextAddedListeners) {
        Intrinsics.checkNotNullParameter(onTextAddedListeners, (String)"onTextAddedListeners");
        this.syntaxHighlightColor = syntaxHighlightColor;
        this.syntaxHighlightTextColor = syntaxHighlightTextColor;
        this.enableUnderlineForLink = enableUnderlineForLink;
        this.onTextAddedListeners = onTextAddedListeners;
    }

    public /* synthetic */ MardownCorePlugin(int n, int n2, boolean bl, List list, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            list = new ArrayList(0);
        }
        this(n, n2, bl, list);
    }

    public void configureVisitor(@NotNull MarkwonVisitor.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.text(builder);
        this.strongEmphasis(builder);
        this.emphasis(builder);
        this.blockQuote(builder);
        this.code(builder);
        this.fencedCodeBlock(builder);
        this.indentedCodeBlock(builder);
        this.image(builder);
        this.bulletList(builder);
        this.orderedList(builder);
        this.listItem(builder);
        this.thematicBreak(builder);
        this.heading(builder);
        this.softLineBreak(builder);
        this.hardLineBreak(builder);
        this.paragraph(builder);
        this.link(builder);
    }

    public void configureTheme(@NotNull MarkwonTheme.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.codeBackgroundColor(this.syntaxHighlightColor);
        builder.isLinkUnderlined(this.enableUnderlineForLink);
        if (this.syntaxHighlightTextColor != ColorKt.toArgb-8_81llA((long)Color.Companion.getUnspecified-0d7_KjU())) {
            builder.codeTextColor(this.syntaxHighlightTextColor);
        }
        super.configureTheme(builder);
    }

    public void configureSpansFactory(@NotNull MarkwonSpansFactory.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        CodeBlockSpanFactory codeBlockSpanFactory = new CodeBlockSpanFactory();
        builder.setFactory(StrongEmphasis.class, (SpanFactory)new StrongEmphasisSpanFactory()).setFactory(Emphasis.class, (SpanFactory)new EmphasisSpanFactory()).setFactory(BlockQuote.class, (SpanFactory)new BlockQuoteSpanFactory()).setFactory(Code.class, (SpanFactory)new CodeSpanFactory()).setFactory(FencedCodeBlock.class, (SpanFactory)codeBlockSpanFactory).setFactory(IndentedCodeBlock.class, (SpanFactory)codeBlockSpanFactory).setFactory(ListItem.class, (SpanFactory)new ListItemSpanFactory()).setFactory(Heading.class, (SpanFactory)new HeadingSpanFactory()).setFactory(Link.class, (SpanFactory)new LinkSpanFactory()).setFactory(ThematicBreak.class, (SpanFactory)new ThematicBreakSpanFactory());
    }

    @NotNull
    public CorePlugin addOnTextAddedListener(@NotNull CorePlugin.OnTextAddedListener onTextAddedListener) {
        Intrinsics.checkNotNullParameter((Object)onTextAddedListener, (String)"onTextAddedListener");
        this.onTextAddedListeners.add(onTextAddedListener);
        return this;
    }

    private final void text(MarkwonVisitor.Builder builder) {
        builder.on(Text.class, new MarkwonVisitor.NodeVisitor(this){
            final /* synthetic */ MardownCorePlugin this$0;
            {
                this.this$0 = $receiver;
            }

            public final void visit(@NotNull MarkwonVisitor visitor, @NotNull Text text2) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                String literal = text2.getLiteral();
                visitor.builder().append(literal);
                if (!((Collection)MardownCorePlugin.access$getOnTextAddedListeners$p(this.this$0)).isEmpty()) {
                    int length = visitor.length() - literal.length();
                    for (CorePlugin.OnTextAddedListener onTextAddedListener : MardownCorePlugin.access$getOnTextAddedListeners$p(this.this$0)) {
                        onTextAddedListener.onTextAdded(visitor, literal, length);
                    }
                }
            }
        });
    }

    private final void strongEmphasis(MarkwonVisitor.Builder builder) {
        builder.on(StrongEmphasis.class, (MarkwonVisitor.NodeVisitor)strongEmphasis.1.INSTANCE);
    }

    private final void emphasis(MarkwonVisitor.Builder builder) {
        builder.on(Emphasis.class, (MarkwonVisitor.NodeVisitor)emphasis.1.INSTANCE);
    }

    private final void blockQuote(MarkwonVisitor.Builder builder) {
        builder.on(BlockQuote.class, (MarkwonVisitor.NodeVisitor)blockQuote.1.INSTANCE);
    }

    private final void code(MarkwonVisitor.Builder builder) {
        builder.on(Code.class, (MarkwonVisitor.NodeVisitor)code.1.INSTANCE);
    }

    private final void fencedCodeBlock(MarkwonVisitor.Builder builder) {
        builder.on(FencedCodeBlock.class, new MarkwonVisitor.NodeVisitor(this){
            final /* synthetic */ MardownCorePlugin this$0;
            {
                this.this$0 = $receiver;
            }

            public final void visit(@NotNull MarkwonVisitor visitor, @NotNull FencedCodeBlock fencedCodeBlock2) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)fencedCodeBlock2, (String)"fencedCodeBlock");
                String string = fencedCodeBlock2.getInfo();
                String string2 = fencedCodeBlock2.getLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLiteral(...)");
                this.this$0.visitCodeBlock(visitor, string, string2, (Node)fencedCodeBlock2);
            }
        });
    }

    private final void indentedCodeBlock(MarkwonVisitor.Builder builder) {
        builder.on(IndentedCodeBlock.class, new MarkwonVisitor.NodeVisitor(this){
            final /* synthetic */ MardownCorePlugin this$0;
            {
                this.this$0 = $receiver;
            }

            public final void visit(@NotNull MarkwonVisitor visitor, @NotNull IndentedCodeBlock indentedCodeBlock2) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)indentedCodeBlock2, (String)"indentedCodeBlock");
                String string = indentedCodeBlock2.getLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
                this.this$0.visitCodeBlock(visitor, null, string, (Node)indentedCodeBlock2);
            }
        });
    }

    private final void image(MarkwonVisitor.Builder builder) {
        builder.on(Image.class, MardownCorePlugin::image$lambda$0);
    }

    @VisibleForTesting
    public final void visitCodeBlock(@NotNull MarkwonVisitor visitor, @Nullable String info, @NotNull String code2, @NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)code2, (String)"code");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        visitor.blockStart(node);
        int length = visitor.length();
        visitor.builder().append('\u00a0').append('\n').append(visitor.configuration().syntaxHighlight().highlight(info, code2));
        visitor.ensureNewLine();
        visitor.builder().append('\u00a0');
        CoreProps.CODE_BLOCK_INFO.set(visitor.renderProps(), (Object)info);
        visitor.setSpansForNodeOptional(node, length);
        visitor.blockEnd(node);
    }

    private final void bulletList(MarkwonVisitor.Builder builder) {
        builder.on(BulletList.class, (MarkwonVisitor.NodeVisitor)new SimpleBlockNodeVisitor());
    }

    private final void orderedList(MarkwonVisitor.Builder builder) {
        builder.on(OrderedList.class, (MarkwonVisitor.NodeVisitor)new SimpleBlockNodeVisitor());
    }

    private final void listItem(MarkwonVisitor.Builder builder) {
        builder.on(ListItem.class, new MarkwonVisitor.NodeVisitor(this){
            final /* synthetic */ MardownCorePlugin this$0;
            {
                this.this$0 = $receiver;
            }

            public final void visit(@NotNull MarkwonVisitor visitor, @NotNull ListItem listItem2) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)listItem2, (String)"listItem");
                int length = visitor.length();
                visitor.visitChildren((Node)listItem2);
                Block block = listItem2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getParent(...)");
                Node parent = (Node)block;
                if (parent instanceof OrderedList) {
                    int start = ((OrderedList)parent).getStartNumber();
                    CoreProps.LIST_ITEM_TYPE.set(visitor.renderProps(), (Object)CoreProps.ListItemType.ORDERED);
                    CoreProps.ORDERED_LIST_ITEM_NUMBER.set(visitor.renderProps(), (Object)start);
                    Node orderedList = parent;
                    OrderedList orderedList2 = (OrderedList)orderedList;
                    orderedList2.setStartNumber(orderedList2.getStartNumber() + 1);
                } else {
                    CoreProps.LIST_ITEM_TYPE.set(visitor.renderProps(), (Object)CoreProps.ListItemType.BULLET);
                    CoreProps.BULLET_LIST_ITEM_LEVEL.set(visitor.renderProps(), (Object)MardownCorePlugin.access$listLevel(this.this$0, (Node)listItem2));
                }
                visitor.setSpansForNodeOptional((Node)listItem2, length);
                if (visitor.hasNext((Node)listItem2)) {
                    visitor.ensureNewLine();
                }
            }
        });
    }

    private final int listLevel(Node node) {
        int level = 0;
        for (Node parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ListItem)) continue;
            ++level;
        }
        return level;
    }

    private final void thematicBreak(MarkwonVisitor.Builder builder) {
        builder.on(ThematicBreak.class, (MarkwonVisitor.NodeVisitor)thematicBreak.1.INSTANCE);
    }

    private final void heading(MarkwonVisitor.Builder builder) {
        builder.on(Heading.class, (MarkwonVisitor.NodeVisitor)heading.1.INSTANCE);
    }

    private final void softLineBreak(MarkwonVisitor.Builder builder) {
        builder.on(SoftLineBreak.class, (MarkwonVisitor.NodeVisitor)softLineBreak.1.INSTANCE);
    }

    private final void hardLineBreak(MarkwonVisitor.Builder builder) {
        builder.on(HardLineBreak.class, (MarkwonVisitor.NodeVisitor)hardLineBreak.1.INSTANCE);
    }

    private final void paragraph(MarkwonVisitor.Builder builder) {
        builder.on(Paragraph.class, new MarkwonVisitor.NodeVisitor(this){
            final /* synthetic */ MardownCorePlugin this$0;
            {
                this.this$0 = $receiver;
            }

            public final void visit(@NotNull MarkwonVisitor visitor, @NotNull Paragraph paragraph2) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)paragraph2, (String)"paragraph");
                boolean inTightList = MardownCorePlugin.access$isInTightList(this.this$0, paragraph2);
                if (!inTightList) {
                    visitor.blockStart((Node)paragraph2);
                }
                int length = visitor.length();
                visitor.visitChildren((Node)paragraph2);
                CoreProps.PARAGRAPH_IS_IN_TIGHT_LIST.set(visitor.renderProps(), (Object)inTightList);
                visitor.setSpansForNodeOptional((Node)paragraph2, length);
                if (!inTightList) {
                    visitor.blockEnd((Node)paragraph2);
                }
            }
        });
    }

    private final boolean isInTightList(Paragraph paragraph2) {
        Node gramps;
        Node parent = (Node)paragraph2.getParent();
        if (parent != null && (gramps = parent.getParent()) instanceof ListBlock) {
            return ((ListBlock)gramps).isTight();
        }
        return false;
    }

    private final void link(MarkwonVisitor.Builder builder) {
        builder.on(Link.class, (MarkwonVisitor.NodeVisitor)link.1.INSTANCE);
    }

    private static final void image$lambda$0(MarkwonVisitor visitor, Image image) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        SpanFactory spanFactory = visitor.configuration().spansFactory().get(Image.class);
        if (spanFactory == null) {
            visitor.visitChildren((Node)image);
            return;
        }
        int length = visitor.length();
        visitor.visitChildren((Node)image);
        if (length == visitor.length()) {
            visitor.builder().append('\ufffc');
        }
        MarkwonConfiguration markwonConfiguration = visitor.configuration();
        Intrinsics.checkNotNullExpressionValue((Object)markwonConfiguration, (String)"configuration(...)");
        MarkwonConfiguration configuration = markwonConfiguration;
        Node parent = image.getParent();
        boolean link2 = parent instanceof Link;
        String string = configuration.imageDestinationProcessor().process(image.getDestination());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process(...)");
        String destination = string;
        RenderProps renderProps = visitor.renderProps();
        Intrinsics.checkNotNullExpressionValue((Object)renderProps, (String)"renderProps(...)");
        RenderProps props = renderProps;
        ImageProps.DESTINATION.set(props, (Object)destination);
        ImageProps.REPLACEMENT_TEXT_IS_LINK.set(props, (Object)link2);
        ImageProps.IMAGE_SIZE.set(props, null);
        visitor.setSpans(length, spanFactory.getSpans(configuration, props));
    }

    public static final /* synthetic */ List access$getOnTextAddedListeners$p(MardownCorePlugin $this) {
        return $this.onTextAddedListeners;
    }

    public static final /* synthetic */ int access$listLevel(MardownCorePlugin $this, Node node) {
        return $this.listLevel(node);
    }

    public static final /* synthetic */ boolean access$isInTightList(MardownCorePlugin $this, Paragraph paragraph2) {
        return $this.isInTightList(paragraph2);
    }
}

