/*
 * Decompiled with CFR 0.152.
 */
package com.jetradarmobile.sociallogin.facebook;

import android.content.Intent;
import androidx.fragment.app.Fragment;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.Profile;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.jetradarmobile.sociallogin.SocialAccount;
import com.jetradarmobile.sociallogin.SocialAuthCallback;
import com.jetradarmobile.sociallogin.SocialAuthError;
import com.jetradarmobile.sociallogin.SocialNetwork;
import com.jetradarmobile.sociallogin.facebook.FacebookLoginError;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001(B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\"\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J\u0012\u0010#\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010&\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010\u0003H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetradarmobile/sociallogin/facebook/FacebookNetwork;", "Lcom/jetradarmobile/sociallogin/SocialNetwork;", "Lcom/facebook/FacebookCallback;", "Lcom/facebook/login/LoginResult;", "permissions", "", "", "(Ljava/util/List;)V", "callbackManager", "Lcom/facebook/CallbackManager;", "kotlin.jvm.PlatformType", "code", "getCode", "()Ljava/lang/String;", "loginCallback", "Lcom/jetradarmobile/sociallogin/SocialAuthCallback;", "createSocialToken", "Lcom/jetradarmobile/sociallogin/SocialAccount;", "accessToken", "Lcom/facebook/AccessToken;", "profile", "Lcom/facebook/Profile;", "login", "", "fragment", "Landroidx/fragment/app/Fragment;", "callback", "logout", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCancel", "onError", "error", "Lcom/facebook/FacebookException;", "onSuccess", "result", "Companion", "facebook_release"})
public final class FacebookNetwork
implements SocialNetwork,
FacebookCallback<LoginResult> {
    private final CallbackManager callbackManager;
    @NotNull
    private final String code = "facebook";
    private SocialAuthCallback loginCallback;
    private final List<String> permissions;
    @NotNull
    public static final String CODE = "facebook";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getCode() {
        return this.code;
    }

    public void login(@NotNull Fragment fragment, @NotNull SocialAuthCallback callback) {
        block1: {
            Profile profile;
            AccessToken token;
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
                Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
                this.loginCallback = callback;
                LoginManager.getInstance().registerCallback(this.callbackManager, (FacebookCallback)this);
                token = AccessToken.getCurrentAccessToken();
                profile = Profile.getCurrentProfile();
                if (token != null) break block0;
                LoginManager.getInstance().logInWithReadPermissions(fragment, (Collection)this.permissions);
                break block1;
            }
            SocialAccount socialToken = this.createSocialToken(token, profile);
            SocialAuthCallback socialAuthCallback = this.loginCallback;
            if (socialAuthCallback == null) break block1;
            socialAuthCallback.onLoginSuccess((SocialNetwork)this, socialToken);
        }
    }

    public void logout(@NotNull Fragment fragment, @NotNull SocialAuthCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        LoginManager.getInstance().logOut();
        callback.onLogoutSuccess((SocialNetwork)this);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        this.callbackManager.onActivityResult(requestCode, resultCode, data);
    }

    public void onCancel() {
        block0: {
            SocialAuthCallback socialAuthCallback = this.loginCallback;
            if (socialAuthCallback == null) break block0;
            socialAuthCallback.onAuthError((SocialNetwork)this, (SocialAuthError)SocialAuthError.CANCELLED.INSTANCE);
        }
    }

    public void onSuccess(@Nullable LoginResult result) {
        block1: {
            block0: {
                AccessToken token;
                Profile profile = Profile.getCurrentProfile();
                LoginResult loginResult = result;
                Object object = token = loginResult != null ? loginResult.getAccessToken() : null;
                if (token == null) break block0;
                SocialAccount socialToken = this.createSocialToken(token, profile);
                SocialAuthCallback socialAuthCallback = this.loginCallback;
                if (socialAuthCallback == null) break block1;
                socialAuthCallback.onLoginSuccess((SocialNetwork)this, socialToken);
                break block1;
            }
            SocialAuthCallback socialAuthCallback = this.loginCallback;
            if (socialAuthCallback == null) break block1;
            socialAuthCallback.onAuthError((SocialNetwork)this, (SocialAuthError)new FacebookLoginError(FacebookLoginError.NoLogin.INSTANCE));
        }
    }

    public void onError(@Nullable FacebookException error) {
        block1: {
            Object object = error;
            if (object == null || (object = object.getMessage()) == null) {
                object = "";
            }
            Object message = object;
            SocialAuthCallback socialAuthCallback = this.loginCallback;
            if (socialAuthCallback == null) break block1;
            CharSequence charSequence = (CharSequence)message;
            SocialNetwork socialNetwork = this;
            SocialAuthCallback socialAuthCallback2 = socialAuthCallback;
            boolean bl = charSequence.length() > 0;
            socialAuthCallback2.onAuthError(socialNetwork, bl ? new SocialAuthError((String)message) : (SocialAuthError)SocialAuthError.CANCELLED.INSTANCE);
        }
    }

    private final SocialAccount createSocialToken(AccessToken accessToken, Profile profile) {
        String string = accessToken.getToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"accessToken.token");
        String string2 = accessToken.getUserId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accessToken.userId");
        Object object = profile;
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        return new SocialAccount(string, CODE, null, string2, (String)object, null, null, 100, null);
    }

    public FacebookNetwork(@NotNull List<String> permissions) {
        Intrinsics.checkParameterIsNotNull(permissions, (String)"permissions");
        this.permissions = permissions;
        this.callbackManager = CallbackManager.Factory.create();
        this.code = CODE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetradarmobile/sociallogin/facebook/FacebookNetwork$Companion;", "", "()V", "CODE", "", "facebook_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

