/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.view.PreviewView;
import androidx.fragment.app.Fragment;
import com.king.camera.scan.BaseCameraScan;
import com.king.camera.scan.CameraScan;
import com.king.camera.scan.R;
import com.king.camera.scan.analyze.Analyzer;
import com.king.camera.scan.util.PermissionUtils;
import com.king.logx.LogX;

public abstract class BaseCameraScanFragment<T>
extends Fragment
implements CameraScan.OnScanResultCallback<T> {
    private static final int CAMERA_PERMISSION_REQUEST_CODE = 134;
    private View mRootView;
    protected PreviewView previewView;
    protected View ivFlashlight;
    private CameraScan<T> mCameraScan;

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.isContentView()) {
            this.mRootView = this.createRootView(inflater, container);
        }
        return this.mRootView;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initUI();
    }

    public void initUI() {
        this.previewView = (PreviewView)this.mRootView.findViewById(this.getPreviewViewId());
        int ivFlashlightId = this.getFlashlightId();
        if (ivFlashlightId != -1 && ivFlashlightId != 0) {
            this.ivFlashlight = this.mRootView.findViewById(ivFlashlightId);
            if (this.ivFlashlight != null) {
                this.ivFlashlight.setOnClickListener(v -> this.onClickFlashlight());
            }
        }
        this.mCameraScan = this.createCameraScan(this.previewView);
        this.initCameraScan(this.mCameraScan);
        this.startCamera();
    }

    public void initCameraScan(@NonNull CameraScan<T> cameraScan) {
        cameraScan.setAnalyzer(this.createAnalyzer()).bindFlashlightView(this.ivFlashlight).setOnScanResultCallback(this);
    }

    protected void onClickFlashlight() {
        this.toggleTorchState();
    }

    protected void toggleTorchState() {
        if (this.getCameraScan() != null) {
            boolean isTorch = this.getCameraScan().isTorchEnabled();
            this.getCameraScan().enableTorch(!isTorch);
            if (this.ivFlashlight != null) {
                this.ivFlashlight.setSelected(!isTorch);
            }
        }
    }

    public void startCamera() {
        if (this.mCameraScan != null) {
            if (PermissionUtils.checkPermission(this.requireContext(), "android.permission.CAMERA")) {
                this.mCameraScan.startCamera();
            } else {
                LogX.d((String)"checkPermissionResult != PERMISSION_GRANTED", (Object[])new Object[0]);
                PermissionUtils.requestPermission(this, "android.permission.CAMERA", 134);
            }
        }
    }

    private void releaseCamera() {
        if (this.mCameraScan != null) {
            this.mCameraScan.release();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 134) {
            this.requestCameraPermissionResult(permissions, grantResults);
        }
    }

    public void requestCameraPermissionResult(@NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionUtils.requestPermissionsResult("android.permission.CAMERA", permissions, grantResults)) {
            this.startCamera();
        } else {
            this.requireActivity().finish();
        }
    }

    public void onDestroyView() {
        this.releaseCamera();
        super.onDestroyView();
    }

    public boolean isContentView() {
        return true;
    }

    @NonNull
    public View createRootView(LayoutInflater inflater, ViewGroup container) {
        return inflater.inflate(this.getLayoutId(), container, false);
    }

    public int getLayoutId() {
        return R.layout.camera_scan;
    }

    public int getPreviewViewId() {
        return R.id.previewView;
    }

    public int getFlashlightId() {
        return R.id.ivFlashlight;
    }

    public CameraScan<T> getCameraScan() {
        return this.mCameraScan;
    }

    public View getRootView() {
        return this.mRootView;
    }

    @NonNull
    public CameraScan<T> createCameraScan(PreviewView previewView) {
        return new BaseCameraScan(this, previewView);
    }

    @Nullable
    public abstract Analyzer<T> createAnalyzer();
}

