/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan.config;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.Preview;
import androidx.camera.core.resolutionselector.AspectRatioStrategy;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import com.king.camera.scan.config.CameraConfig;
import com.king.camera.scan.util.LogUtils;
import java.util.ArrayList;
import java.util.Locale;

public class AdaptiveCameraConfig
extends CameraConfig {
    private static final int IMAGE_QUALITY_1080P = 1080;
    private static final int IMAGE_QUALITY_720P = 720;
    private AspectRatioStrategy mAspectRatioStrategy;
    private int mPreviewQuality;
    private int mAnalysisQuality;
    private Size mPreviewTargetSize;
    private Size mAnalysisTargetSize;

    public AdaptiveCameraConfig(Context context) {
        this.initAdaptiveCameraConfig(context);
    }

    private void initAdaptiveCameraConfig(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels;
        LogUtils.d(String.format(Locale.getDefault(), "displayMetrics: %dx%d", width, height));
        if (width < height) {
            float ratio = (float)height / (float)width;
            this.mPreviewQuality = Math.min(width, 1080);
            this.mAspectRatioStrategy = Math.abs(ratio - 1.3333334f) < Math.abs(ratio - 1.7777778f) ? AspectRatioStrategy.RATIO_4_3_FALLBACK_AUTO_STRATEGY : AspectRatioStrategy.RATIO_16_9_FALLBACK_AUTO_STRATEGY;
            this.mPreviewTargetSize = new Size(this.mPreviewQuality, Math.round((float)this.mPreviewQuality * ratio));
            this.mAnalysisQuality = width > 1080 ? 1080 : Math.min(width, 720);
            this.mAnalysisTargetSize = new Size(this.mAnalysisQuality, Math.round((float)this.mAnalysisQuality * ratio));
        } else {
            this.mPreviewQuality = Math.min(height, 1080);
            float ratio = (float)width / (float)height;
            this.mAspectRatioStrategy = Math.abs(ratio - 1.3333334f) < Math.abs(ratio - 1.7777778f) ? AspectRatioStrategy.RATIO_4_3_FALLBACK_AUTO_STRATEGY : AspectRatioStrategy.RATIO_16_9_FALLBACK_AUTO_STRATEGY;
            this.mPreviewTargetSize = new Size(Math.round((float)this.mPreviewQuality * ratio), this.mPreviewQuality);
            this.mAnalysisQuality = height > 1080 ? 1080 : Math.min(height, 720);
            this.mAnalysisTargetSize = new Size(Math.round((float)this.mAnalysisQuality * ratio), this.mAnalysisQuality);
        }
    }

    @Override
    @NonNull
    public CameraSelector options(@NonNull CameraSelector.Builder builder) {
        return super.options(builder);
    }

    @Override
    @NonNull
    public Preview options(@NonNull Preview.Builder builder) {
        builder.setResolutionSelector(this.createPreviewResolutionSelector());
        return super.options(builder);
    }

    @Override
    @NonNull
    public ImageAnalysis options(@NonNull ImageAnalysis.Builder builder) {
        builder.setResolutionSelector(this.createAnalysisResolutionSelector());
        return super.options(builder);
    }

    private ResolutionSelector createPreviewResolutionSelector() {
        return new ResolutionSelector.Builder().setAspectRatioStrategy(this.mAspectRatioStrategy).setResolutionStrategy(new ResolutionStrategy(this.mPreviewTargetSize, 1)).setResolutionFilter((supportedSizes, rotationDegrees) -> {
            LogUtils.d("Preview supportedSizes: " + supportedSizes);
            ArrayList<Size> list = new ArrayList<Size>();
            for (Size supportedSize : supportedSizes) {
                int size = Math.min(supportedSize.getWidth(), supportedSize.getHeight());
                if (size > this.mPreviewQuality) continue;
                list.add(supportedSize);
            }
            return list;
        }).build();
    }

    private ResolutionSelector createAnalysisResolutionSelector() {
        return new ResolutionSelector.Builder().setAspectRatioStrategy(this.mAspectRatioStrategy).setResolutionStrategy(new ResolutionStrategy(this.mAnalysisTargetSize, 1)).setResolutionFilter((supportedSizes, rotationDegrees) -> {
            LogUtils.d("ImageAnalysis supportedSizes: " + supportedSizes);
            ArrayList<Size> list = new ArrayList<Size>();
            for (Size supportedSize : supportedSizes) {
                int size = Math.min(supportedSize.getWidth(), supportedSize.getHeight());
                if (size > this.mAnalysisQuality) continue;
                list.add(supportedSize);
            }
            return list;
        }).build();
    }
}

